##########################################################################
# texiupd_target.mk

# prerequisite: create_am_macros.mk texiupd.mk


# automake's texinfo rules assume that the input files are static.
# texiupd likes to convert files in place.  these two behaviors
# don't work well together.

# to fix things, this snippet is based upon the texinfo input being
# split into two files.  the first is a small stub file,
# <package>.texi which mostly just includes the second file,
# <package>_docs.texi (it should also include version.texi if so
# desired).  <package>_docs.texi is run through texiupd.
# <package>_docs.texi is a copy of the actual texinfo file,
# <package>_docs.texi.in, to ensure that the original file is not
# modified.

# this snippet creates a target for <package>_docs.texi, depending
# upon <package_docs>.texi.in.  it copies the latter to the former,
# then runs texiupd on it. 

# the calling Makefile.am should have the following lines in it:
#
#   info_TEXINFOS      = <package>.texi
#   <package>_TEXINFOS = $(srcdir)/<package>_docs.texi

# additional dependencies (for instance c2man stamp files) may be
# specified via the TEXIUPD_DEPS variable, which should be added to
# after including this snippet.

# the variable TEXIUPD_DOCS_TEXI must be set to the name of the file
# (but without the .in suffix) which will be processed by texiupd

include $(top_srcdir)/snippets/texiupd.mk

TEXIUPD_DEPS =

$(TEXIUPD_DOCS_TEXI) : $(TEXIUPD_DOCS_TEXI).in $(TEXIUPD_DEPS)
	cp $(TEXIUPD_DOCS_TEXI).in $@ ;\
	TEXIUPD_FILE=$@ ;\
	TEXIUPD_FLAGS='-I $(srcdir)' ;\
	$(do_texiupd) || { rm -f $@; false; }

MAINTAINERCLEANFILES	+= $(TEXIUPD_DOCS_TEXI)
