##########################################################################
# texiupd.mk

# provide a macro which will run texiupd on the top level texinfo
# file.  it tries to place nice with version.texi.

# useful variables to set

# TEXIUPD_FILE  - which file should it operate on
# TEXIUPD_FLAGS - extra things you need to pass it. perhaps -I?

# see texiupd_static.mk and texiupd_c2man.mk for an example of how to
# use this snippet.  DO NOT USE THIS DIRECTLY unless you really
# know what you are doing.

# note this will change things in $(srcdir) instead of $(builddir).
# automake tries to enforce the GNU coding standards, which require
# building of distributed texi/info files in $(srcdir)

do_texiupd = \
	if test -z "$$TEXIUPD_FILE"; then \
	  echo 'ERROR: must set $$TEXIUPD_FILE variable: see snippets/texiupd.mk' ;\
	  exit 1 ;\
	fi ;\
	need_vti=0 ; \
	file=`basename $$TEXIUPD_FILE` ;\
	! grep version.texi $$TEXIUPD_FILE \
	  || test -f version.texi || need_vti=1 ; \
	if  test $$need_vti -eq 1 ; then touch -f version.texi; fi; \
	rc=1; \
	texiupd \
		$$TEXIUPD_FLAGS \
		-insert -noinsert_headings \
		-master -menu \
		$$TEXIUPD_FILE && rc=0; \
	if  test $$need_vti -eq 1 ; then rm -f version.texi; fi; \
	test -f $@ || { p="$@"; f=$(strip_dir) cp $(srcdir)/$$f $@; } ;\
	touch -f $@ ;\
	exit $$rc




