#============================================================================
# texi_html.mk

# Preloaded Snippets:
#	create_am_macros.mk

TEXI_HTML		= $(TEXINFOS:%.texi=%.html)

TEXI_HTML_STAMP		= $(TEXINFOS:%.texi=%.hstp)

EXTRA_DIST		+= $(TEXI_HTML) $(TEXI_HTML_STAMP)

MAINTAINERCLEANFILES	+= $(TEXI_HTML) $(TEXI_HTML_STAMP)

htmldir			= $(datadir)/doc/$(PACKAGE_NAME)/html

# this is needed to trigger creation of the HTML.
noinst_DATA		= $(TEXI_HTML_STAMP)

SUFFIXES += .hstp
.texi.hstp : 
	$(MAKE) $(@:.hstp=.html)
	touch -f $@

# we can't actually install or distribute the HTML using the standard
# automake rules, as we generate a directory of HTML files, not just a
# single file and they CANT HANDLE DIRECTORIES!


include $(top_srcdir)/snippets/install_dir.mk

# patterned after what automake generates
install-data-local: $(TEXI_HTML_STAMP)
	@$(NORMAL_INSTALL)
	src_dir=$(TEXI_HTML); dst_dir=$(htmldir); $(install_dir)

uninstall-local:
	@$(NORMAL_UNINSTALL)
	src_dir=$(TEXI_HTML); dst_dir=$(htmldir); $(uninstall_dir)
