/* for popen on Solaris */
#ifdef SunOS
#ifndef __EXTENSIONS__
#  define __EXTENSIONS__
#endif
#else
#ifndef _POSIX_C_SOURCE
#  define _POSIX_C_SOURCE 2
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "help.h"

static const char help_string[] =
{
  85, 115, 97, 103, 101, 58, 10, 
  32, 32, 32, 32, 102, 111, 117, 110, 116, 97, 105, 110, 32, 91, 45, 98, 32, 98, 117, 102, 102, 101, 114, 32, 115, 105, 122, 101, 32, 45, 104, 32, 45, 118, 32, 45, 86, 93, 32, 99, 111, 109, 109, 97, 110, 100, 32, 91, 99, 111, 109, 109, 97, 110, 100, 32, 46, 46, 46, 93, 10, 
  10, 
  79, 112, 116, 105, 111, 110, 115, 58, 10, 
  32, 32, 32, 32, 45, 98, 32, 98, 117, 102, 102, 101, 114, 32, 115, 105, 122, 101, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 84, 104, 101, 32, 115, 105, 122, 101, 32, 111, 102, 32, 116, 104, 101, 32, 98, 117, 102, 102, 101, 114, 32, 40, 105, 110, 32, 98, 121, 116, 101, 115, 41, 32, 117, 115, 101, 100, 32, 116, 111, 32, 116, 114, 97, 110, 115, 102, 101, 114, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 115, 116, 114, 101, 97, 109, 46, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 73, 116, 32, 100, 101, 102, 97, 117, 108, 116, 115, 32, 116, 111, 32, 56, 49, 57, 50, 32, 98, 121, 116, 101, 115, 46, 10, 
  10, 
  32, 32, 32, 32, 45, 104, 32, 32, 79, 117, 116, 112, 117, 116, 32, 104, 101, 108, 112, 46, 10, 
  10, 
  32, 32, 32, 32, 45, 115, 32, 32, 73, 110, 32, 97, 100, 100, 105, 116, 105, 111, 110, 32, 116, 111, 32, 119, 114, 105, 116, 105, 110, 103, 32, 116, 111, 32, 116, 104, 101, 32, 99, 111, 109, 109, 97, 110, 100, 115, 32, 103, 105, 118, 101, 110, 32, 98, 121, 32, 45, 99, 44, 32, 97, 99, 116, 32, 97, 115, 32, 97, 32, 102, 105, 108, 116, 101, 114, 44, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 99, 111, 112, 121, 105, 110, 103, 32, 102, 114, 111, 109, 32, 115, 116, 97, 110, 100, 97, 114, 100, 32, 105, 110, 112, 117, 116, 32, 116, 111, 32, 115, 116, 97, 110, 100, 97, 114, 100, 32, 111, 117, 116, 112, 117, 116, 46, 10, 
  10, 
  32, 32, 32, 32, 45, 118, 32, 32, 66, 101, 32, 97, 32, 98, 105, 116, 32, 109, 111, 114, 101, 32, 118, 101, 114, 98, 111, 115, 101, 46, 10, 
  10, 
  32, 32, 32, 32, 45, 86, 32, 32, 79, 117, 116, 112, 117, 116, 32, 118, 101, 114, 115, 105, 111, 110, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 46, 10, 
  10, 
 0
};


int
help( void )
{
  const char *pager;
  FILE *pipe;

  if ( ! isatty( STDOUT_FILENO ) )
    fputs( help_string, stdout );
  else
  {
    if ( NULL == ( pager = getenv( "PAGER" )) )
      pager = "more";

    if ( NULL == ( pipe = popen( pager, "w" ) ) )
      return 1;

    fputs( help_string, pipe );
    pclose( pipe );
  }
  return 0;
}
