/*
  Copyright (C) 2008 Ben Asselstine
  Written by Ben Asselstine

  This file is part of fileschanged.

  fileschanged is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  fileschanged is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with fileschanged; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301  USA
*/
#ifndef FILESCHANGED_OPTS_H
#define FILESCHANGED_OPTS_H
#include "gettext.h"
#define _(__str) gettext(__str)
#define N_(__str) gettext_noop(__str)

struct fileschanged_arguments_t
{
	int recursive;
	int showdeleted;
	int showchanged;
	int showcreated;
	int showexecuting;
	int showfinishedexecuting;
	int filelist;
	char *filelist_filename;
	int filestomonitor;
	int filechangetimeout;
	int showaction;
	char *exec_cmd;
	int dereference_symlinks;
};
struct arguments_t 
{
	char **args;
	int arraylen; //for argument processing
	struct fileschanged_arguments_t fileschanged;
};

void parse_opts(int argc, char **argv, struct arguments_t *arguments);

#endif
