//------------------------------------------------------------------------------
// emPainter_ScTlIntGra.cpp
//
// Copyright (C) 2020 Oliver Hamann.
//
// Homepage: http://eaglemode.sourceforge.net/
//
// This program is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License version 3 as published by the
// Free Software Foundation.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License version 3 for
// more details.
//
// You should have received a copy of the GNU General Public License version 3
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "emPainter_ScTl.h"


void emPainter::ScanlineTool::InterpolateLinearGradient(
	const ScanlineTool & sct, int x, int y, int w
)
{
	emInt64 tdx = sct.TDX;
	emInt64 t = x*tdx + y*sct.TDY - sct.TX;
	emByte * buf=(emByte*)sct.InterpolationBuffer;
	emByte * bufEnd=buf+w;
	do {
		emInt64 u=t>>24;
		if ((emUInt64)u>255) u=~(u>>48);
		*buf=(emByte)u;
		buf++;
		t+=tdx;
	} while (buf<bufEnd);
}


void emPainter::ScanlineTool::InterpolateRadialGradient(
	const ScanlineTool & sct, int x, int y, int w
)
{
	static const emByte sqrtTable[64771]={
		//#include <stdio.h>
		//#include <math.h>
		//int main(int argc, char * argv[])
		//{
		//  for (int x=0, n=0, c=0;; x++) {
		//    int y=(int)(sqrt(x)+0.5);
		//    if (y==c) { n++; continue; }
		//    for (int i=512; i; i>>=1) {
		//      if ((n&i)==0) continue;
		//      if (i==1) printf("%d, ",c);
		//      else if (i==2) printf("%d, %d, ",c,c);
		//      else printf("R%d(%d), ",i,c);
		//    }
		//    c=y; n=1; printf("\n");
		//    if (y>=255) return 0;
		//  }
		//}

#		define R4(n) n,n,n,n
#		define R8(n) n,n,n,n,n,n,n,n
#		define R16(n) n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n
#		define R32(n) R16(n),R16(n)
#		define R64(n) R32(n),R32(n)
#		define R128(n) R64(n),R64(n)
#		define R256(n) R128(n),R128(n)

		0,1,1,R4(2),R4(3),3,3,R8(4),R8(5),5,5,R8(6),R4(6),R8(7),R4(7),7,
		7,R16(8),R16(9),9,9,R16(10),R4(10),R16(11),R4(11),11,11,R16(12),
		R8(12),R16(13),R8(13),13,13,R16(14),R8(14),R4(14),R16(15),R8(15),
		R4(15),15,15,R32(16),R32(17),17,17,R32(18),R4(18),R32(19),R4(19),19,
		19,R32(20),R8(20),R32(21),R8(21),21,21,R32(22),R8(22),R4(22),R32(23),
		R8(23),R4(23),23,23,R32(24),R16(24),R32(25),R16(25),25,25,R32(26),
		R16(26),R4(26),R32(27),R16(27),R4(27),27,27,R32(28),R16(28),R8(28),
		R32(29),R16(29),R8(29),29,29,R32(30),R16(30),R8(30),R4(30),R32(31),
		R16(31),R8(31),R4(31),31,31,R64(32),R64(33),33,33,R64(34),R4(34),
		R64(35),R4(35),35,35,R64(36),R8(36),R64(37),R8(37),37,37,R64(38),
		R8(38),R4(38),R64(39),R8(39),R4(39),39,39,R64(40),R16(40),R64(41),
		R16(41),41,41,R64(42),R16(42),R4(42),R64(43),R16(43),R4(43),43,43,
		R64(44),R16(44),R8(44),R64(45),R16(45),R8(45),45,45,R64(46),R16(46),
		R8(46),R4(46),R64(47),R16(47),R8(47),R4(47),47,47,R64(48),R32(48),
		R64(49),R32(49),49,49,R64(50),R32(50),R4(50),R64(51),R32(51),R4(51),
		51,51,R64(52),R32(52),R8(52),R64(53),R32(53),R8(53),53,53,R64(54),
		R32(54),R8(54),R4(54),R64(55),R32(55),R8(55),R4(55),55,55,R64(56),
		R32(56),R16(56),R64(57),R32(57),R16(57),57,57,R64(58),R32(58),R16(58),
		R4(58),R64(59),R32(59),R16(59),R4(59),59,59,R64(60),R32(60),R16(60),
		R8(60),R64(61),R32(61),R16(61),R8(61),61,61,R64(62),R32(62),R16(62),
		R8(62),R4(62),R64(63),R32(63),R16(63),R8(63),R4(63),63,63,R128(64),
		R128(65),65,65,R128(66),R4(66),R128(67),R4(67),67,67,R128(68),R8(68),
		R128(69),R8(69),69,69,R128(70),R8(70),R4(70),R128(71),R8(71),R4(71),
		71,71,R128(72),R16(72),R128(73),R16(73),73,73,R128(74),R16(74),R4(74),
		R128(75),R16(75),R4(75),75,75,R128(76),R16(76),R8(76),R128(77),R16(77),
		R8(77),77,77,R128(78),R16(78),R8(78),R4(78),R128(79),R16(79),R8(79),
		R4(79),79,79,R128(80),R32(80),R128(81),R32(81),81,81,R128(82),R32(82),
		R4(82),R128(83),R32(83),R4(83),83,83,R128(84),R32(84),R8(84),R128(85),
		R32(85),R8(85),85,85,R128(86),R32(86),R8(86),R4(86),R128(87),R32(87),
		R8(87),R4(87),87,87,R128(88),R32(88),R16(88),R128(89),R32(89),R16(89),
		89,89,R128(90),R32(90),R16(90),R4(90),R128(91),R32(91),R16(91),R4(91),
		91,91,R128(92),R32(92),R16(92),R8(92),R128(93),R32(93),R16(93),R8(93),
		93,93,R128(94),R32(94),R16(94),R8(94),R4(94),R128(95),R32(95),R16(95),
		R8(95),R4(95),95,95,R128(96),R64(96),R128(97),R64(97),97,97,R128(98),
		R64(98),R4(98),R128(99),R64(99),R4(99),99,99,R128(100),R64(100),
		R8(100),R128(101),R64(101),R8(101),101,101,R128(102),R64(102),R8(102),
		R4(102),R128(103),R64(103),R8(103),R4(103),103,103,R128(104),R64(104),
		R16(104),R128(105),R64(105),R16(105),105,105,R128(106),R64(106),
		R16(106),R4(106),R128(107),R64(107),R16(107),R4(107),107,107,R128(108),
		R64(108),R16(108),R8(108),R128(109),R64(109),R16(109),R8(109),109,109,
		R128(110),R64(110),R16(110),R8(110),R4(110),R128(111),R64(111),R16(111),
		R8(111),R4(111),111,111,R128(112),R64(112),R32(112),R128(113),R64(113),
		R32(113),113,113,R128(114),R64(114),R32(114),R4(114),R128(115),R64(115),
		R32(115),R4(115),115,115,R128(116),R64(116),R32(116),R8(116),R128(117),
		R64(117),R32(117),R8(117),117,117,R128(118),R64(118),R32(118),R8(118),
		R4(118),R128(119),R64(119),R32(119),R8(119),R4(119),119,119,R128(120),
		R64(120),R32(120),R16(120),R128(121),R64(121),R32(121),R16(121),121,121,
		R128(122),R64(122),R32(122),R16(122),R4(122),R128(123),R64(123),R32(123),
		R16(123),R4(123),123,123,R128(124),R64(124),R32(124),R16(124),R8(124),
		R128(125),R64(125),R32(125),R16(125),R8(125),125,125,R128(126),R64(126),
		R32(126),R16(126),R8(126),R4(126),R128(127),R64(127),R32(127),R16(127),
		R8(127),R4(127),127,127,R256(128),R256(129),129,129,R256(130),R4(130),
		R256(131),R4(131),131,131,R256(132),R8(132),R256(133),R8(133),133,133,
		R256(134),R8(134),R4(134),R256(135),R8(135),R4(135),135,135,R256(136),
		R16(136),R256(137),R16(137),137,137,R256(138),R16(138),R4(138),
		R256(139),R16(139),R4(139),139,139,R256(140),R16(140),R8(140),R256(141),
		R16(141),R8(141),141,141,R256(142),R16(142),R8(142),R4(142),R256(143),
		R16(143),R8(143),R4(143),143,143,R256(144),R32(144),R256(145),R32(145),
		145,145,R256(146),R32(146),R4(146),R256(147),R32(147),R4(147),147,147,
		R256(148),R32(148),R8(148),R256(149),R32(149),R8(149),149,149,R256(150),
		R32(150),R8(150),R4(150),R256(151),R32(151),R8(151),R4(151),151,151,
		R256(152),R32(152),R16(152),R256(153),R32(153),R16(153),153,153,
		R256(154),R32(154),R16(154),R4(154),R256(155),R32(155),R16(155),R4(155),
		155,155,R256(156),R32(156),R16(156),R8(156),R256(157),R32(157),R16(157),
		R8(157),157,157,R256(158),R32(158),R16(158),R8(158),R4(158),R256(159),
		R32(159),R16(159),R8(159),R4(159),159,159,R256(160),R64(160),R256(161),
		R64(161),161,161,R256(162),R64(162),R4(162),R256(163),R64(163),R4(163),
		163,163,R256(164),R64(164),R8(164),R256(165),R64(165),R8(165),165,165,
		R256(166),R64(166),R8(166),R4(166),R256(167),R64(167),R8(167),R4(167),
		167,167,R256(168),R64(168),R16(168),R256(169),R64(169),R16(169),169,
		169,R256(170),R64(170),R16(170),R4(170),R256(171),R64(171),R16(171),
		R4(171),171,171,R256(172),R64(172),R16(172),R8(172),R256(173),R64(173),
		R16(173),R8(173),173,173,R256(174),R64(174),R16(174),R8(174),R4(174),
		R256(175),R64(175),R16(175),R8(175),R4(175),175,175,R256(176),R64(176),
		R32(176),R256(177),R64(177),R32(177),177,177,R256(178),R64(178),
		R32(178),R4(178),R256(179),R64(179),R32(179),R4(179),179,179,R256(180),
		R64(180),R32(180),R8(180),R256(181),R64(181),R32(181),R8(181),181,181,
		R256(182),R64(182),R32(182),R8(182),R4(182),R256(183),R64(183),R32(183),
		R8(183),R4(183),183,183,R256(184),R64(184),R32(184),R16(184),R256(185),
		R64(185),R32(185),R16(185),185,185,R256(186),R64(186),R32(186),R16(186),
		R4(186),R256(187),R64(187),R32(187),R16(187),R4(187),187,187,R256(188),
		R64(188),R32(188),R16(188),R8(188),R256(189),R64(189),R32(189),R16(189),
		R8(189),189,189,R256(190),R64(190),R32(190),R16(190),R8(190),R4(190),
		R256(191),R64(191),R32(191),R16(191),R8(191),R4(191),191,191,R256(192),
		R128(192),R256(193),R128(193),193,193,R256(194),R128(194),R4(194),
		R256(195),R128(195),R4(195),195,195,R256(196),R128(196),R8(196),
		R256(197),R128(197),R8(197),197,197,R256(198),R128(198),R8(198),R4(198),
		R256(199),R128(199),R8(199),R4(199),199,199,R256(200),R128(200),
		R16(200),R256(201),R128(201),R16(201),201,201,R256(202),R128(202),
		R16(202),R4(202),R256(203),R128(203),R16(203),R4(203),203,203,R256(204),
		R128(204),R16(204),R8(204),R256(205),R128(205),R16(205),R8(205),205,205,
		R256(206),R128(206),R16(206),R8(206),R4(206),R256(207),R128(207),
		R16(207),R8(207),R4(207),207,207,R256(208),R128(208),R32(208),R256(209),
		R128(209),R32(209),209,209,R256(210),R128(210),R32(210),R4(210),
		R256(211),R128(211),R32(211),R4(211),211,211,R256(212),R128(212),
		R32(212),R8(212),R256(213),R128(213),R32(213),R8(213),213,213,R256(214),
		R128(214),R32(214),R8(214),R4(214),R256(215),R128(215),R32(215),R8(215),
		R4(215),215,215,R256(216),R128(216),R32(216),R16(216),R256(217),
		R128(217),R32(217),R16(217),217,217,R256(218),R128(218),R32(218),
		R16(218),R4(218),R256(219),R128(219),R32(219),R16(219),R4(219),219,219,
		R256(220),R128(220),R32(220),R16(220),R8(220),R256(221),R128(221),
		R32(221),R16(221),R8(221),221,221,R256(222),R128(222),R32(222),R16(222),
		R8(222),R4(222),R256(223),R128(223),R32(223),R16(223),R8(223),R4(223),
		223,223,R256(224),R128(224),R64(224),R256(225),R128(225),R64(225),225,
		225,R256(226),R128(226),R64(226),R4(226),R256(227),R128(227),R64(227),
		R4(227),227,227,R256(228),R128(228),R64(228),R8(228),R256(229),
		R128(229),R64(229),R8(229),229,229,R256(230),R128(230),R64(230),R8(230),
		R4(230),R256(231),R128(231),R64(231),R8(231),R4(231),231,231,R256(232),
		R128(232),R64(232),R16(232),R256(233),R128(233),R64(233),R16(233),233,
		233,R256(234),R128(234),R64(234),R16(234),R4(234),R256(235),R128(235),
		R64(235),R16(235),R4(235),235,235,R256(236),R128(236),R64(236),R16(236),
		R8(236),R256(237),R128(237),R64(237),R16(237),R8(237),237,237,R256(238),
		R128(238),R64(238),R16(238),R8(238),R4(238),R256(239),R128(239),R64(239),
		R16(239),R8(239),R4(239),239,239,R256(240),R128(240),R64(240),R32(240),
		R256(241),R128(241),R64(241),R32(241),241,241,R256(242),R128(242),
		R64(242),R32(242),R4(242),R256(243),R128(243),R64(243),R32(243),R4(243),
		243,243,R256(244),R128(244),R64(244),R32(244),R8(244),R256(245),
		R128(245),R64(245),R32(245),R8(245),245,245,R256(246),R128(246),
		R64(246),R32(246),R8(246),R4(246),R256(247),R128(247),R64(247),R32(247),
		R8(247),R4(247),247,247,R256(248),R128(248),R64(248),R32(248),R16(248),
		R256(249),R128(249),R64(249),R32(249),R16(249),249,249,R256(250),
		R128(250),R64(250),R32(250),R16(250),R4(250),R256(251),R128(251),
		R64(251),R32(251),R16(251),R4(251),251,251,R256(252),R128(252),R64(252),
		R32(252),R16(252),R8(252),R256(253),R128(253),R64(253),R32(253),R16(253),
		R8(253),253,253,R256(254),R128(254),R64(254),R32(254),R16(254),R8(254),
		R4(254)
	};

	emByte * buf=(emByte*)sct.InterpolationBuffer;
	emByte * bufEnd=buf+w;

	emInt64 ty = y*sct.TDY - sct.TY;
	if ((emUInt64)ty+(((emUInt64)0xff)<<23) >= (((emUInt64)0x1fe)<<23)) {
		do {
			*buf=255;
			buf++;
		} while (buf<bufEnd);
		return;
	}

	emInt64 tyty = ty*ty + ((((emInt64)1)<<45)-1);
	emInt64 tdx = sct.TDX;
	emInt64 tx = x*tdx - sct.TX;
	do {
		if ((emUInt64)tx+(((emUInt64)0xff)<<23) < (((emUInt64)0x1fe)<<23)) {
			emInt64 t=(tx*tx+tyty)>>46;
			if (t<64771) *buf=sqrtTable[t];
			else *buf=255;
		}
		else {
			*buf=255;
		}
		buf++;
		tx+=tdx;
	} while (buf<bufEnd);
}
