##
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##

import gtk
import os
import Constants
import DSApp

class DlgDiskAdd:
    """This class contains the implementation of the Add disk dialog."""
    
    def __init__ (self):
        """Constructor of DlgDiskAdd class."""

        # load dialog widget tree, get widgets and connect signals 
        dlg_add_widget_tree = gtk.glade.XML (Constants.RESOURCE_DIR + "/disksearch.glade", "dlg_add")
        self.dlg_add = dlg_add_widget_tree.get_widget ("dlg_add")
        self.tf_mountpoint = dlg_add_widget_tree.get_widget ("tf_mountpoint")
        self.tf_name = dlg_add_widget_tree.get_widget ("tf_name")
        self.om_type = dlg_add_widget_tree.get_widget ("om_type")
        self.tf_remark = dlg_add_widget_tree.get_widget ("tf_remark")
        self.cb_mount_disk = dlg_add_widget_tree.get_widget ("cb_mount_disk")
        dlg_add_widget_tree.signal_connect ("on_browse_clicked", self.browse_mount_point)
        dlg_add_widget_tree.signal_connect ("on_cancel_clicked", self.add_disk_cancel)
        dlg_add_widget_tree.signal_connect ("on_ok_clicked", self.add_disk_ok)
        
        # set initial values
        self.tf_mountpoint.set_text (DSApp.DSApp.doc.mountPoint)
        DSApp.DSApp.view.fill_media_type_optionmenu (self.om_type, DSApp.DSApp.doc.mediaType)
        self.cb_mount_disk.set_active (DSApp.DSApp.doc.mountMode)

        self.dlg_add.set_transient_for (DSApp.DSApp.view.app_disksearch)
        self.dlg_add.set_icon (DSApp.DSApp.view.pxb_appicon)
        self.dlg_add.show ()                

    def browse_mount_point (self, *args):
        """Choose mount point directory in file chooser dialog."""
        
        # display PyGTK 2.4 file chooser for directories
        dialog = gtk.FileChooserDialog (_("Select mount point directory"), None, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
            (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OPEN, gtk.RESPONSE_OK))
        dialog.set_default_response (gtk.RESPONSE_OK)
        dialog.set_transient_for (self.dlg_add)
        
        # preselect the previous mount point
        dialog.select_filename (self.tf_mountpoint.get_text ())
        
        response = dialog.run ()
        if response == gtk.RESPONSE_OK:
            self.tf_mountpoint.set_text (dialog.get_filename ())
        
        dialog.destroy()
        
    def add_disk_cancel (self, *args):
        """Closes the "Add disk" dialog without any action."""
        
        self.dlg_add.destroy ()

    def add_disk_ok (self, *args):
        """Adds the new disk to list (OK in "Add disk" dialog was pressed)."""

        # get mountpoint, name and mount mode from dialog and check
        mountPoint = self.tf_mountpoint.get_text ().strip ()
        name = self.tf_name.get_text ().strip ()
        type = DSApp.DSApp.doc.diskList.media_types[self.om_type.get_history ()][0]
        remark = self.tf_remark.get_text ().strip ()
        mountMode = self.cb_mount_disk.get_active ()

        if len (mountPoint) == 0 or os.path.isdir (mountPoint) == False:
            self.tf_mountpoint.select_region (0, -1)
            DSApp.DSApp.view.display_message_dialog_with_parrent (self.dlg_add, gtk.MESSAGE_ERROR, _("You need to enter a valid mountpoint!"))
            self.tf_mountpoint.grab_focus ()
            return

        if len (name) == 0:
            self.tf_name.select_region (0, -1)
            DSApp.DSApp.view.display_message_dialog_with_parrent (self.dlg_add, gtk.MESSAGE_ERROR, _("You need to enter a valid name!"))
            self.tf_name.grab_focus ()
            return

        # keep entered media type, mount point and mount mode for next dialog display
        DSApp.DSApp.doc.mediaType = type
        DSApp.DSApp.doc.mountPoint = mountPoint
        DSApp.DSApp.doc.mountMode = mountMode 

        # ensure that new name is not in use yet
        for disk in DSApp.DSApp.doc.diskList.content:
            if name == disk.name:
                self.tf_name.select_region (0, -1)
                DSApp.DSApp.view.display_message_dialog_with_parrent (self.dlg_add, gtk.MESSAGE_ERROR, _("This name is allready in use, please enter another one!"))
                self.tf_name.grab_focus ()
                return

        # close dialog
        self.dlg_add.destroy ()
        
        DSApp.DSApp.view.show_wait_cursor (DSApp.DSApp.view.app_disksearch.window)
        try:
            # mount disk if mountMode enabled 
            if mountMode != 0:
                if os.system ("mount " + mountPoint) != 0:
                    DSApp.DSApp.view.app_disksearch.window.set_cursor (None)
                    DSApp.DSApp.view.display_message_dialog (gtk.MESSAGE_ERROR, _("Failed to mount disk!\nSee console output for more informations..."))
                    return
                
            # (try to) add disk to list
            if DSApp.DSApp.doc.diskList.add_disk (name, type, remark, mountPoint) == -1:
                DSApp.DSApp.view.app_disksearch.window.set_cursor (None)
                DSApp.DSApp.view.display_message_dialog (gtk.MESSAGE_ERROR, _("Failed to add disk to list!\nSee console output for more informations..."))
                return
        
            # unmount disk if mountMode enabled 
            if mountMode != 0:
                if os.system ("umount " + mountPoint) != 0:
                    DSApp.DSApp.view.display_message_dialog (gtk.MESSAGE_ERROR, _("Failed to unmount disk!\nSee console output for more informations..."))
        finally:
            DSApp.DSApp.view.show_default_cursor (DSApp.DSApp.view.app_disksearch.window)

        # on success update the GUI disk list
        DSApp.DSApp.view.display_disk_list (name)
