/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 1 "cmdline.opt"
/* This file is part of cfpeek  -*- c -*-
   Copyright (C) 2011-2021 Sergey Poznyakoff

   Cfpeek is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   Cfpeek is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with cfpeek.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifdef HAVE_GETOPT_H
# include <getopt.h>
#endif
#include <unistd.h>
#include "grecs/gitid.h"

static struct grecs_txtacc *pp_cmd_acc;
char *program_name;

#define PREPROC_NOT_SET 0
#define PREPROC_SET     1
#define PREPROC_DEFAULT 2
static int preproc_settings = PREPROC_NOT_SET;

#define CFPEEK_NODE_FLAG_DEFAULT \
	(GRECS_NODE_FLAG_PATH|GRECS_NODE_FLAG_VALUE|GRECS_NODE_FLAG_DESCEND)

static int flags_on, flags_off;

struct format_flag {
	char *name;
	char *arg;
	char *descr;
	int flag;
	void (*handler)(const char *);
};

static void
set_parent_option(const char *str)
{
	struct locate_instr *instr = new_locate_instr();
	instr->cmd = locate_parent;
	instr->v.s = grecs_strdup(str);
}

static void
set_child_option(const char *str)
{
	struct locate_instr *instr = new_locate_instr();
	instr->cmd = locate_child;
	instr->v.s = grecs_strdup(str);
}

static void
set_sibling_option(const char *str)
{
	struct locate_instr *instr = new_locate_instr();
	instr->cmd = locate_sibling;
	instr->v.s = grecs_strdup(str);
}

static void
set_up_option(const char *str)
{
	struct locate_instr *instr = new_locate_instr();
	instr->cmd = locate_up;
	instr->v.n = atoi(str);
}

static void
set_down_option(const char *str)
{
	struct locate_instr *instr = new_locate_instr();
	instr->cmd = locate_down;
	instr->v.n = atoi(str);
}

static void
set_delim_option(const char *str)
{
	flags_on |= *str & 0xff;
}

struct format_flag format_flag_table[] = {
	{ "parent", "NAME", "print the parent node with the given NAME",
	  0, set_parent_option },
	{ "child", "NAME", "print the child node with the given NAME",
	  0, set_child_option },
	{ "up", "NUMBER", "ascend NUMBER of nodes",
	  0, set_up_option },
	{ "down", "NUMBER", "descend NUMBER of nodes",
	  0, set_down_option },
	{ "sibling",
	  "NAME", "locate a sibling with the given NAME and print it",
	  0, set_sibling_option },
	{ "delim", "CHAR", "set path component delimiter",
	  0, set_delim_option },
	{ "locus", NULL, "print locations",
	  GRECS_NODE_FLAG_LOCUS },
	{ "path", NULL, "print paths",
	  GRECS_NODE_FLAG_PATH },
	{ "value", NULL, "print values",
	  GRECS_NODE_FLAG_VALUE },
	{ "quote", NULL, "always quote values",
	  GRECS_NODE_FLAG_QUOTE },
	{ "never-quote", NULL, "never quote values",
	  GRECS_NODE_FLAG_NOQUOTE },
	{ "quote-hex", NULL, "show unprintable characters as hex",
	  GRECS_NODE_FLAG_QUOTE_HEX },
	{ "descend", NULL, "descend into subnodes",
	  GRECS_NODE_FLAG_DESCEND },
	{ "default", NULL, "set default options",
	  CFPEEK_NODE_FLAG_DEFAULT },
	{ NULL }
};

static void
flags_help(FILE *stream)
{
	struct format_flag *fp;

	fprintf(stream, "[*] FLAGS is a comma-separated list of the following:\n");

	for (fp = format_flag_table; fp->name; fp++) {
		int n;
		fprintf(stream, "  ");
		if (fp->arg)
			n = fprintf(stream, "%s=%s", fp->name, fp->arg);
		else
			n = fprintf(stream, "[no]%s", fp->name);
		if (n < 24)
			n = 24 - n;
		else
			n = 2;
		fprintf(stream, "%*s%s\n", n, "", fp->descr);
	}
	fputc('\n', stream);
}

static const char *
cmpasgn(const char *a, const char *b)
{
	for (; *a && *b; a++, b++)  {
		if (*a != *b)
			return NULL;
	}
	if (*a == 0 && *b == '=')
		return b+1;

	return NULL;
}

static void
set_flag(const char *str)
{
	struct format_flag *fp;

	for (fp = format_flag_table; fp->name; fp++) {
		if (fp->arg) {
			const char *arg = cmpasgn(fp->name, str);
			if (arg) {
				fp->handler(arg);
				return;
			}
		} else if (strcmp(str, fp->name) == 0) {
			if (fp->handler)
				fp->handler(str);
			else
				flags_on |= fp->flag;
			return;
		} else if (strncmp(str, "no", 2) == 0 &&
			   strcmp(str + 2, fp->name) == 0) {
			if (fp->handler)
				fp->handler(str);
			else
				flags_off |= fp->flag;
			return;
		}
	}
	grecs_error(NULL, 0, "unknown option: %s", str);
}

#line 378 "cmdline.opt"
#ifdef HAVE_CONFIG_H
#line 378
# include <config.h>
#line 378
#endif
#line 378
#ifdef HAVE_GETOPT_H
#line 378
# include <getopt.h>
#line 378
#endif
#line 378
#include <unistd.h>
#line 378
#include <stdlib.h>
#line 378
#include <grecs.h>
#line 378
#include <grecs/opt.h>
#line 378
#ifndef EX_USAGE
#line 378
# define EX_USAGE 64
#line 378
#endif
#line 378
/* Option codes */
#line 378
enum {
#line 378
	_OPTION_INIT=255,
#line 378 "cmdline.opt"
	OPTION_USAGE,
#line 378 "cmdline.opt"
	MAX_OPTION
#line 378
};
#line 378
#ifdef HAVE_GETOPT_LONG
#line 378
static struct option long_options[] = {
#line 198 "cmdline.opt"
	{ "format", required_argument, 0, 'H' },
#line 214 "cmdline.opt"
	{ "quiet", no_argument, 0, 'q' },
#line 222 "cmdline.opt"
	{ "parser", required_argument, 0, 'p' },
#line 245 "cmdline.opt"
	{ "literal", no_argument, 0, 'L' },
#line 251 "cmdline.opt"
	{ "reduce", no_argument, 0, 'r' },
#line 257 "cmdline.opt"
	{ "sort", no_argument, 0, 'S' },
#line 263 "cmdline.opt"
	{ "matches", required_argument, 0, 'm' },
#line 269 "cmdline.opt"
	{ "set", required_argument, 0, 's' },
#line 292 "cmdline.opt"
	{ "lang", required_argument, 0, 'l' },
#line 298 "cmdline.opt"
	{ "file", required_argument, 0, 'f' },
#line 304 "cmdline.opt"
	{ "expression", required_argument, 0, 'e' },
#line 310 "cmdline.opt"
	{ "init", required_argument, 0, 'i' },
#line 316 "cmdline.opt"
	{ "done", required_argument, 0, 'd' },
#line 324 "cmdline.opt"
	{ "include-directory", required_argument, 0, 'I' },
#line 332 "cmdline.opt"
	{ "define", required_argument, 0, 'D' },
#line 350 "cmdline.opt"
	{ "preprocessor", required_argument, 0, 'P' },
#line 357 "cmdline.opt"
	{ "no-preprocessor", no_argument, 0, 'N' },
#line 366 "cmdline.opt"
	{ "debug-parser", no_argument, 0, 'x' },
#line 372 "cmdline.opt"
	{ "debug-lexer", no_argument, 0, 'X' },
#line 378 "cmdline.opt"
	{ "help", no_argument, 0, 'h' },
#line 378 "cmdline.opt"
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 378 "cmdline.opt"
	{ "version", no_argument, 0, 'V' },
#line 378 "cmdline.opt"
	{0, 0, 0, 0}
#line 378
};
#line 378
#endif
#line 378

#line 378
static struct grecs_opthelp opthelp[] = {
#line 196 "cmdline.opt"
	{ NULL, NULL, 0, N_("Output control") },
#line 200 "cmdline.opt"
	{
#line 200
#ifdef HAVE_GETOPT_LONG
#line 200
	  "-H, --format",
#line 200
#else
#line 200
	  "-H",
#line 200
#endif
#line 200
				   N_("FLAGS"), 0, N_("set output format flags [*]") },
#line 216 "cmdline.opt"
	{
#line 216
#ifdef HAVE_GETOPT_LONG
#line 216
	  "-q, --quiet",
#line 216
#else
#line 216
	  "-q",
#line 216
#endif
#line 216
				   NULL, 0, N_("suppress error diagnostics") },
#line 220 "cmdline.opt"
	{ NULL, NULL, 0, N_("Modifiers") },
#line 224 "cmdline.opt"
	{
#line 224
#ifdef HAVE_GETOPT_LONG
#line 224
	  "-p, --parser",
#line 224
#else
#line 224
	  "-p",
#line 224
#endif
#line 224
				   N_("GRECS|META1|BIND|GIT|PATH"), 0, N_("set parser type") },
#line 247 "cmdline.opt"
	{
#line 247
#ifdef HAVE_GETOPT_LONG
#line 247
	  "-L, --literal",
#line 247
#else
#line 247
	  "-L",
#line 247
#endif
#line 247
				   NULL, 0, N_("use literal matching") },
#line 253 "cmdline.opt"
	{
#line 253
#ifdef HAVE_GETOPT_LONG
#line 253
	  "-r, --reduce",
#line 253
#else
#line 253
	  "-r",
#line 253
#endif
#line 253
				   NULL, 0, N_("reduce the tree") },
#line 259 "cmdline.opt"
	{
#line 259
#ifdef HAVE_GETOPT_LONG
#line 259
	  "-S, --sort",
#line 259
#else
#line 259
	  "-S",
#line 259
#endif
#line 259
				   NULL, 0, N_("sort parse tree lexicografically") },
#line 265 "cmdline.opt"
	{
#line 265
#ifdef HAVE_GETOPT_LONG
#line 265
	  "-m, --matches",
#line 265
#else
#line 265
	  "-m",
#line 265
#endif
#line 265
				   N_("NUMBER"), 0, N_("output at most NUMBER matches") },
#line 271 "cmdline.opt"
	{
#line 271
#ifdef HAVE_GETOPT_LONG
#line 271
	  "-s, --set",
#line 271
#else
#line 271
	  "-s",
#line 271
#endif
#line 271
				   N_("PATH=VAL"), 0, N_("set a keyword") },
#line 290 "cmdline.opt"
	{ NULL, NULL, 0, N_("Scripting") },
#line 294 "cmdline.opt"
	{
#line 294
#ifdef HAVE_GETOPT_LONG
#line 294
	  "-l, --lang",
#line 294
#else
#line 294
	  "-l",
#line 294
#endif
#line 294
				   N_("NAME"), 0, N_("select scripting language to use") },
#line 300 "cmdline.opt"
	{
#line 300
#ifdef HAVE_GETOPT_LONG
#line 300
	  "-f, --file",
#line 300
#else
#line 300
	  "-f",
#line 300
#endif
#line 300
				   N_("FILE"), 0, N_("load the script FILE") },
#line 306 "cmdline.opt"
	{
#line 306
#ifdef HAVE_GETOPT_LONG
#line 306
	  "-e, --expression",
#line 306
#else
#line 306
	  "-e",
#line 306
#endif
#line 306
				   N_("EXPR"), 0, N_("apply this expression to each node found") },
#line 312 "cmdline.opt"
	{
#line 312
#ifdef HAVE_GETOPT_LONG
#line 312
	  "-i, --init",
#line 312
#else
#line 312
	  "-i",
#line 312
#endif
#line 312
				   N_("EXPR"), 0, N_("initial setup expession") },
#line 318 "cmdline.opt"
	{
#line 318
#ifdef HAVE_GETOPT_LONG
#line 318
	  "-d, --done",
#line 318
#else
#line 318
	  "-d",
#line 318
#endif
#line 318
				   N_("EXPR"), 0, N_("final cleanup expession") },
#line 322 "cmdline.opt"
	{ NULL, NULL, 0, N_("Preprocessor control") },
#line 326 "cmdline.opt"
	{
#line 326
#ifdef HAVE_GETOPT_LONG
#line 326
	  "-I, --include-directory",
#line 326
#else
#line 326
	  "-I",
#line 326
#endif
#line 326
				   N_("DIR"), 0, N_("add include directory") },
#line 334 "cmdline.opt"
	{
#line 334
#ifdef HAVE_GETOPT_LONG
#line 334
	  "-D, --define",
#line 334
#else
#line 334
	  "-D",
#line 334
#endif
#line 334
				   N_("SYMBOL[=VALUE]"), 0, N_("define a preprocessor symbol") },
#line 352 "cmdline.opt"
	{
#line 352
#ifdef HAVE_GETOPT_LONG
#line 352
	  "-P, --preprocessor",
#line 352
#else
#line 352
	  "-P",
#line 352
#endif
#line 352
				   N_("COMMAND"), 0, N_("use COMMAND instead of the default preprocessor") },
#line 359 "cmdline.opt"
	{
#line 359
#ifdef HAVE_GETOPT_LONG
#line 359
	  "-N, --no-preprocessor",
#line 359
#else
#line 359
	  "-N",
#line 359
#endif
#line 359
				   NULL, 0, N_("disable preprocessing") },
#line 364 "cmdline.opt"
	{ NULL, NULL, 0, N_("Debugging") },
#line 368 "cmdline.opt"
	{
#line 368
#ifdef HAVE_GETOPT_LONG
#line 368
	  "-x, --debug-parser",
#line 368
#else
#line 368
	  "-x",
#line 368
#endif
#line 368
				   NULL, 0, N_("debug configuration file parser") },
#line 374 "cmdline.opt"
	{
#line 374
#ifdef HAVE_GETOPT_LONG
#line 374
	  "-X, --debug-lexer",
#line 374
#else
#line 374
	  "-X",
#line 374
#endif
#line 374
				   NULL, 0, N_("debug configuration file lexer") },
#line 378 "cmdline.opt"
	{ NULL, NULL, 0, N_("Other options") },
#line 378 "cmdline.opt"
	{
#line 378
#ifdef HAVE_GETOPT_LONG
#line 378
	  "-h, --help",
#line 378
#else
#line 378
	  "-h",
#line 378
#endif
#line 378
				   NULL, 0, N_("Give this help list") },
#line 378 "cmdline.opt"
	{
#line 378
#ifdef HAVE_GETOPT_LONG
#line 378
	  "--usage",
#line 378
#else
#line 378
	  "",
#line 378
#endif
#line 378
				   NULL, 0, N_("Give a short usage message") },
#line 378 "cmdline.opt"
	{
#line 378
#ifdef HAVE_GETOPT_LONG
#line 378
	  "-V, --version",
#line 378
#else
#line 378
	  "-V",
#line 378
#endif
#line 378
				   NULL, 0, N_("Print program version") },
#line 378 "cmdline.opt"
};
#line 189 "cmdline.opt"

#line 189

#line 189
#ifndef PACKAGE_URL
#line 189
# define PACKAGE_URL NULL
#line 189
#endif
#line 189
static struct grecs_proginfo proginfo = {
#line 189
	"cfpeek", /* progname */
#line 189
	NULL, /* subcommands */
#line 189
	N_("Get variables from a configuration file"), /* docstring */
#line 189
	N_("FILE [PATH...]"), /* args_doc */
#line 189
	opthelp, /* opthelp */
#line 189
	sizeof(opthelp)/sizeof(opthelp[0]), /* optcount */
#line 189
	NULL, /* print_help_hook */
#line 189
	NULL, /* print_version_hook */
#line 189
	PACKAGE_NAME,    /* package */
#line 189
	PACKAGE_VERSION, /* version */
#line 189
	NULL, /* license */
#line 189
	"2011-2021",/* copyright_year */
#line 189
	"Sergey Poznyakoff", /* copyright_holder */
#line 189
	NULL, /* *authors */
#line 189
	"<" PACKAGE_BUGREPORT ">", /* bug_address */
#line 189
	PACKAGE_URL, /* url */
#line 189
	NULL  /* epilogue */
#line 189
};
#line 189


#line 286 "cmdline.opt"
static struct grecs_node *cmdline_tree;
#line 378 "cmdline.opt"

#line 378


void
cfpeek_version_hook(FILE *stream)
{
	fprintf(stream, "compiled with:\n");
	fprintf(stream, "  Grecs %s\n", GRECS_GIT_ID);
#ifdef GUILE_VERSION
	fprintf(stream, "  Guile %s\n", GUILE_VERSION);
#endif
}


void
parse_options(int argc, char *argv[])
{
	program_name = strrchr(argv[0], '/');
	if (program_name)
		program_name++;
	else
		program_name = argv[0];
	proginfo.print_help_hook = flags_help;
	proginfo.print_version_hook = cfpeek_version_hook;
        
#line 401
 {
#line 401
  int c;
#line 401

#line 401
  optind = 0;
#line 401
#ifdef HAVE_GETOPT_LONG
#line 401
  while ((c = getopt_long(argc, argv, "H:qp:LrSm:s:l:f:e:i:d:I:D:P:NxXhV",
#line 401
			  long_options, NULL)) != EOF)
#line 401
#else
#line 401
  while ((c = getopt(argc, argv, "H:qp:LrSm:s:l:f:e:i:d:I:D:P:NxXhV")) != EOF)
#line 401
#endif
#line 401
    {
#line 401
      switch (c)
#line 401
	{
#line 401
	default:
#line 401
	   exit(EX_USAGE);	   exit(EX_USAGE);
#line 401
	#line 200 "cmdline.opt"
	 case 'H':
#line 200
	  {
#line 200

        int i;
        struct wordsplit ws;
	ws.ws_delim = ",";
	if (wordsplit(optarg, &ws,
		      WRDSF_DELIM|WRDSF_SQUEEZE_DELIMS|
		      WRDSF_NOVAR|WRDSF_NOCMD|WRDSF_SHOWERR))
		exit(EX_SOFTWARE);
	for (i = 0; i < ws.ws_wordc; i++) {
		set_flag(ws.ws_wordv[i]);
	}
	wordsplit_free(&ws);

#line 212
	     break;
#line 212
	  }
#line 216 "cmdline.opt"
	 case 'q':
#line 216
	  {
#line 216

	quiet_option++;

#line 218
	     break;
#line 218
	  }
#line 224 "cmdline.opt"
	 case 'p':
#line 224
	  {
#line 224

	if (strcasecmp(optarg, "GRECS") == 0) {
		grecs_parser_fun = grecs_grecs_parser;
		if (preproc_settings == PREPROC_NOT_SET)
			preproc_settings = PREPROC_DEFAULT;
	} else if (strcasecmp(optarg, "META1") == 0)
		grecs_parser_fun = grecs_meta1_parser;
	else if (strcasecmp(optarg, "BIND") == 0)
		grecs_parser_fun = grecs_bind_parser;
	else if (strcasecmp(optarg, "DHCPD") == 0)
		grecs_parser_fun = grecs_dhcpd_parser;
	else if (strcasecmp(optarg, "GIT") == 0)
		grecs_parser_fun = grecs_git_parser;
	else if (strcasecmp(optarg, "PATH") == 0)
		grecs_parser_fun = grecs_path_parser;
	else {
		grecs_error(NULL, 0, "unsupported parser type");
		exit(EX_USAGE);
	}

#line 243
	     break;
#line 243
	  }
#line 247 "cmdline.opt"
	 case 'L':
#line 247
	  {
#line 247

	mode = MODE_LITERAL;

#line 249
	     break;
#line 249
	  }
#line 253 "cmdline.opt"
	 case 'r':
#line 253
	  {
#line 253

	reduce_option = 1;

#line 255
	     break;
#line 255
	  }
#line 259 "cmdline.opt"
	 case 'S':
#line 259
	  {
#line 259

       sort_option = 1;

#line 261
	     break;
#line 261
	  }
#line 265 "cmdline.opt"
	 case 'm':
#line 265
	  {
#line 265

	max_matches = atoi(optarg);

#line 267
	     break;
#line 267
	  }
#line 271 "cmdline.opt"
	 case 's':
#line 271
	  {
#line 271

        struct wordsplit ws;

	ws.ws_delim = "=";
	if (wordsplit(optarg, &ws, WRDSF_NOVAR | WRDSF_NOCMD |
                                   WRDSF_QUOTE | WRDSF_CESCAPES	|
				   WRDSF_DELIM)) {
	     grecs_error(NULL, 0, "cannot split string: %s",
	                 wordsplit_strerror(&ws));
	     exit(EX_SOFTWARE);
	}
        if (ws.ws_wordc != 2) {
                grecs_error(NULL, 0, "set: invalid syntax");
		exit(EX_USAGE);
	}
	#line 286 "cmdline.opt"
;
#line 286
do {
#line 286
   struct grecs_node *node = grecs_node_from_path(ws.ws_wordv[0], ws.ws_wordv[1]);
#line 286
   if (!cmdline_tree)
#line 286
	cmdline_tree = node;
#line 286
   else
#line 286
	grecs_node_bind(cmdline_tree, node, 0);
#line 286
} while(0)
#line 286
;
        wordsplit_free(&ws);

#line 288
	     break;
#line 288
	  }
#line 294 "cmdline.opt"
	 case 'l':
#line 294
	  {
#line 294

	script_select(optarg);

#line 296
	     break;
#line 296
	  }
#line 300 "cmdline.opt"
	 case 'f':
#line 300
	  {
#line 300

	script_file = optarg;

#line 302
	     break;
#line 302
	  }
#line 306 "cmdline.opt"
	 case 'e':
#line 306
	  {
#line 306

	script_expr = optarg;

#line 308
	     break;
#line 308
	  }
#line 312 "cmdline.opt"
	 case 'i':
#line 312
	  {
#line 312

	script_init_expr = optarg;

#line 314
	     break;
#line 314
	  }
#line 318 "cmdline.opt"
	 case 'd':
#line 318
	  {
#line 318

	script_done_expr = optarg;

#line 320
	     break;
#line 320
	  }
#line 326 "cmdline.opt"
	 case 'I':
#line 326
	  {
#line 326

        if (preproc_settings == PREPROC_NOT_SET)
		preproc_settings = PREPROC_DEFAULT;
	grecs_preproc_add_include_dir(optarg);

#line 330
	     break;
#line 330
	  }
#line 334 "cmdline.opt"
	 case 'D':
#line 334
	  {
#line 334

        char *p;

        if (preproc_settings == PREPROC_NOT_SET)
		preproc_settings = PREPROC_DEFAULT;
        if (!pp_cmd_acc)
		pp_cmd_acc = grecs_txtacc_create();
        grecs_txtacc_grow(pp_cmd_acc, " \"-D", 4);
        for (p = optarg; *p; p++) {
		if (*p == '\\' || *p == '"')
			grecs_txtacc_grow_char(pp_cmd_acc, '\\');
		grecs_txtacc_grow_char(pp_cmd_acc, *p);
	}
	grecs_txtacc_grow_char(pp_cmd_acc, '"');			

#line 348
	     break;
#line 348
	  }
#line 352 "cmdline.opt"
	 case 'P':
#line 352
	  {
#line 352

	grecs_preprocessor = optarg;
        preproc_settings = PREPROC_SET;

#line 355
	     break;
#line 355
	  }
#line 359 "cmdline.opt"
	 case 'N':
#line 359
	  {
#line 359

	grecs_preprocessor = NULL;
        preproc_settings = PREPROC_SET;

#line 362
	     break;
#line 362
	  }
#line 368 "cmdline.opt"
	 case 'x':
#line 368
	  {
#line 368

	grecs_gram_trace(1);

#line 370
	     break;
#line 370
	  }
#line 374 "cmdline.opt"
	 case 'X':
#line 374
	  {
#line 374

	grecs_lex_trace(1);

#line 376
	     break;
#line 376
	  }
#line 378 "cmdline.opt"
	 case 'h':
#line 378
	  {
#line 378

#line 378
		grecs_print_help(&proginfo);
#line 378
		exit(0);
#line 378
	 
#line 378
	     break;
#line 378
	  }
#line 378 "cmdline.opt"
	 case OPTION_USAGE:
#line 378
	  {
#line 378

#line 378
		grecs_print_usage(&proginfo);
#line 378
		exit(0);
#line 378
	 
#line 378
	     break;
#line 378
	  }
#line 378 "cmdline.opt"
	 case 'V':
#line 378
	  {
#line 378

#line 378
	        /* Give version */
#line 378
		grecs_print_version(&proginfo, stdout);
#line 378
		exit(0);
#line 378
	 
#line 378
	     break;
#line 378
	  }

#line 401 "cmdline.opt"
	}
#line 401
    }
#line 401
  file_index = optind;
#line 401
 }
#line 401

	if (!(flags_on & _GRECS_NODE_MASK_OUTPUT)) 
		flags_on |= GRECS_NODE_FLAG_PATH|GRECS_NODE_FLAG_VALUE;
	flags = flags_on & ~flags_off;
	if (!(flags & (GRECS_NODE_FLAG_PATH|GRECS_NODE_FLAG_VALUE))) {
		grecs_warning(NULL, 0, "assuming --format=path,value");
		flags |= GRECS_NODE_FLAG_PATH|GRECS_NODE_FLAG_VALUE;
	}
	if (preproc_settings == PREPROC_DEFAULT)
		grecs_preprocessor = DEFAULT_PREPROCESSOR;
	if (pp_cmd_acc && grecs_preprocessor) {
		char *args, *cmd;

		grecs_txtacc_grow_char(pp_cmd_acc, 0);
		args = grecs_txtacc_finish(pp_cmd_acc, 0);
		cmd = grecs_malloc(strlen(grecs_preprocessor) +
				   strlen(args) + 1);
		strcpy(cmd, grecs_preprocessor);
		strcat(cmd, args);
		grecs_preprocessor = cmd;
	}
	grecs_txtacc_free(pp_cmd_acc);

	script_init();
}
