/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogFilter {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogFilter.class);
    private static ImmutableSet<String> EMPTY_FILTERS = ImmutableSet.of();
    private final ImmutableSet<String> excludedKeyspaces;
    private final ImmutableSet<String> includedKeyspaces;
    private final ImmutableSet<String> excludedCategories;
    private final ImmutableSet<String> includedCategories;
    private final ImmutableSet<String> includedUsers;
    private final ImmutableSet<String> excludedUsers;

    private AuditLogFilter(ImmutableSet<String> excludedKeyspaces, ImmutableSet<String> includedKeyspaces, ImmutableSet<String> excludedCategories, ImmutableSet<String> includedCategories, ImmutableSet<String> excludedUsers, ImmutableSet<String> includedUsers) {
        this.excludedKeyspaces = excludedKeyspaces;
        this.includedKeyspaces = includedKeyspaces;
        this.excludedCategories = excludedCategories;
        this.includedCategories = includedCategories;
        this.includedUsers = includedUsers;
        this.excludedUsers = excludedUsers;
    }

    public static AuditLogFilter create(AuditLogOptions auditLogOptions) {
        logger.trace("Loading AuditLog filters");
        IncludeExcludeHolder keyspaces = AuditLogFilter.loadInputSets(auditLogOptions.included_keyspaces, auditLogOptions.excluded_keyspaces);
        IncludeExcludeHolder categories = AuditLogFilter.loadInputSets(auditLogOptions.included_categories, auditLogOptions.excluded_categories);
        IncludeExcludeHolder users = AuditLogFilter.loadInputSets(auditLogOptions.included_users, auditLogOptions.excluded_users);
        return new AuditLogFilter((ImmutableSet<String>)keyspaces.excludedSet, (ImmutableSet<String>)keyspaces.includedSet, (ImmutableSet<String>)categories.excludedSet, (ImmutableSet<String>)categories.includedSet, (ImmutableSet<String>)users.excludedSet, (ImmutableSet<String>)users.includedSet);
    }

    private static IncludeExcludeHolder loadInputSets(String includedInput, String excludedInput) {
        ImmutableSet includedSet;
        ImmutableSet excludedSet;
        if (StringUtils.isEmpty((CharSequence)excludedInput)) {
            excludedSet = EMPTY_FILTERS;
        } else {
            String[] excludes = excludedInput.split(",");
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)excludes.length);
            for (String exclude : excludes) {
                if (exclude.isEmpty()) continue;
                builder.add((Object)exclude);
            }
            excludedSet = builder.build();
        }
        if (StringUtils.isEmpty((CharSequence)includedInput)) {
            includedSet = EMPTY_FILTERS;
        } else {
            String[] includes = includedInput.split(",");
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)includes.length);
            for (String include : includes) {
                if (include.isEmpty() || excludedSet.contains((Object)include)) continue;
                builder.add((Object)include);
            }
            includedSet = builder.build();
        }
        return new IncludeExcludeHolder(includedSet, excludedSet);
    }

    boolean isFiltered(AuditLogEntry auditLogEntry) {
        return AuditLogFilter.isFiltered(auditLogEntry.getKeyspace(), this.includedKeyspaces, this.excludedKeyspaces) || AuditLogFilter.isFiltered(auditLogEntry.getType().getCategory().toString(), this.includedCategories, this.excludedCategories) || AuditLogFilter.isFiltered(auditLogEntry.getUser(), this.includedUsers, this.excludedUsers);
    }

    static boolean isFiltered(String input, Set<String> includeSet, Set<String> excludeSet) {
        if (!excludeSet.isEmpty() && excludeSet.contains(input)) {
            return true;
        }
        return !includeSet.isEmpty() && !includeSet.contains(input);
    }

    private static class IncludeExcludeHolder {
        private final ImmutableSet<String> includedSet;
        private final ImmutableSet<String> excludedSet;

        private IncludeExcludeHolder(ImmutableSet<String> includedSet, ImmutableSet<String> excludedSet) {
            this.includedSet = includedSet;
            this.excludedSet = excludedSet;
        }
    }
}

