/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.map.hashtable;

import java.util.Iterator;
import org.psjava.ds.KeyValuePair;
import org.psjava.ds.map.Map;
import org.psjava.ds.map.MapEqualityTester;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.map.hashtable.BucketVisitor;
import org.psjava.ds.map.hashtable.HashProber;
import org.psjava.util.AssertStatus;
import org.psjava.util.ConvertedDataIterator;
import org.psjava.util.DataConverter;
import org.psjava.util.DataFilter;
import org.psjava.util.EqualityTester;
import org.psjava.util.FilteredIterator;
import org.psjava.util.Java1DArray;
import org.psjava.util.OrderFreeIterableHash;
import org.psjava.util.StrictEqualityTester;
import org.psjava.util.VarargsIterator;

public class OpenAddressingHashTableMap<K, V>
implements MutableMap<K, V> {
    private static final int MAX_LOAD_FACTOR2 = 2;
    private final HashProber prober;
    protected Entry<K, V>[] bucket;
    protected int load = 0;
    protected int lazyDeletedCount = 0;
    private Entry<K, V> findResult;

    public OpenAddressingHashTableMap(HashProber prober, int reserve) {
        this.prober = prober;
        this.bucket = (Entry[])Java1DArray.create(Entry.class, OpenAddressingHashTableMap.calcBucketSize(reserve));
    }

    protected static int calcBucketSize(int reserve) {
        int size = 1;
        while (size / 2 < reserve) {
            size <<= 1;
        }
        return size;
    }

    @Override
    public void clear() {
        this.bucket = (Entry[])Java1DArray.create(Entry.class, OpenAddressingHashTableMap.calcBucketSize(1));
        this.load = 0;
        this.lazyDeletedCount = 0;
    }

    @Override
    public void add(K key, V value) {
        this.ensureArraysCapacity(this.load + 1);
        this.addToCurrentArray(key, value);
    }

    protected void addToCurrentArray(final K key, final V value) {
        final int keyHash = key.hashCode();
        this.probe(keyHash, new BucketVisitor(){

            @Override
            public boolean visitAndGetContinuity(int pos) {
                if (OpenAddressingHashTableMap.this.bucket[pos] != null) {
                    AssertStatus.assertTrue(!OpenAddressingHashTableMap.this.isKeyInBucket(pos, key, keyHash), "already contains the key");
                    return true;
                }
                OpenAddressingHashTableMap.this.bucket[pos] = new Entry<Object, Object>(key, value, keyHash);
                ++OpenAddressingHashTableMap.this.load;
                return false;
            }
        });
    }

    @Override
    public void replace(K key, V value) {
        Entry<K, V> entry = this.findEntry(key, null);
        AssertStatus.assertNotNull(entry, "key is not exist");
        entry.value = value;
    }

    @Override
    public void addOrReplace(K key, V value) {
        this.ensureArraysCapacity(this.load + 1);
        this.putToCurrentArray(key, value);
    }

    protected void putToCurrentArray(final K key, final V value) {
        final int keyHash = key.hashCode();
        this.probe(keyHash, new BucketVisitor(){

            @Override
            public boolean visitAndGetContinuity(int pos) {
                if (OpenAddressingHashTableMap.this.bucket[pos] != null) {
                    if (OpenAddressingHashTableMap.this.isKeyInBucket(pos, key, keyHash)) {
                        OpenAddressingHashTableMap.this.bucket[pos].keyOrNull = key;
                        OpenAddressingHashTableMap.this.bucket[pos].value = value;
                        return false;
                    }
                    return true;
                }
                OpenAddressingHashTableMap.this.bucket[pos] = new Entry<Object, Object>(key, value, keyHash);
                ++OpenAddressingHashTableMap.this.load;
                return false;
            }
        });
    }

    private void probe(int keyHash, BucketVisitor visitor) {
        this.prober.probe(Math.abs(keyHash) % this.bucket.length, this.bucket.length, visitor);
    }

    protected void ensureArraysCapacity(int reserve) {
        if (reserve <= this.bucket.length / 2) {
            return;
        }
        Entry<K, V>[] oldBucket = this.bucket;
        this.bucket = (Entry[])Java1DArray.create(Entry.class, OpenAddressingHashTableMap.calcBucketSize(reserve));
        this.load = 0;
        this.lazyDeletedCount = 0;
        for (Entry<K, V> v : oldBucket) {
            if (v == null || v.keyOrNull == null) continue;
            this.putToCurrentArray(v.keyOrNull, v.value);
        }
    }

    @Override
    public V get(K key) {
        Entry<K, V> e = this.findEntry(key, null);
        AssertStatus.assertTrue(e != null, "key is not in the map");
        return e.value;
    }

    @Override
    public V getOrNull(K key) {
        Entry<K, V> e = this.findEntry(key, null);
        if (e == null) {
            return null;
        }
        return e.value;
    }

    @Override
    public boolean containsKey(K key) {
        return this.findEntry(key, null) != null;
    }

    @Override
    public void remove(K key) {
        Entry<K, V> e = this.findEntry(key, null);
        if (e != null) {
            e.keyOrNull = null;
            e.value = null;
            ++this.lazyDeletedCount;
        }
    }

    @Override
    public int size() {
        return this.load - this.lazyDeletedCount;
    }

    private Entry<K, V> findEntry(final K key, Entry<K, V> def) {
        final int keyHash = key.hashCode();
        this.findResult = def;
        this.probe(keyHash, new BucketVisitor(){

            @Override
            public boolean visitAndGetContinuity(int pos) {
                if (OpenAddressingHashTableMap.this.bucket[pos] != null) {
                    if (OpenAddressingHashTableMap.this.isKeyInBucket(pos, key, keyHash)) {
                        OpenAddressingHashTableMap.this.findResult = OpenAddressingHashTableMap.this.bucket[pos];
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        return this.findResult;
    }

    @Override
    public Iterator<KeyValuePair<K, V>> iterator() {
        return ConvertedDataIterator.create(FilteredIterator.create(VarargsIterator.create(this.bucket), new DataFilter<Entry<K, V>>(){

            @Override
            public boolean isAccepted(Entry<K, V> v) {
                return v != null && v.keyOrNull != null;
            }
        }), new DataConverter<Entry<K, V>, KeyValuePair<K, V>>(){

            @Override
            public KeyValuePair<K, V> convert(Entry<K, V> v) {
                return v;
            }
        });
    }

    private boolean isKeyInBucket(int pos, K key, int keyHash) {
        Entry<K, V> e = this.bucket[pos];
        return e.keyOrNull != null && e.keyHash == keyHash && e.keyOrNull.equals(key);
    }

    @Override
    public boolean isEmpty() {
        return this.load == 0;
    }

    public boolean equals(Object obj) {
        return StrictEqualityTester.areEqual(this, obj, new EqualityTester<Map<K, V>>(){

            @Override
            public boolean areEqual(Map<K, V> o1, Map<K, V> o2) {
                return MapEqualityTester.areEqual(o1, o2);
            }
        });
    }

    public int hashCode() {
        return OrderFreeIterableHash.hash(this);
    }

    static class Entry<K, V>
    implements KeyValuePair<K, V> {
        K keyOrNull;
        V value;
        int keyHash;

        Entry(K key, V value, int keyHash) {
            this.keyOrNull = key;
            this.value = value;
            this.keyHash = keyHash;
        }

        @Override
        public K getKey() {
            AssertStatus.assertTrue(this.keyOrNull != null);
            return this.keyOrNull;
        }

        @Override
        public V getValue() {
            AssertStatus.assertTrue(this.keyOrNull != null);
            return this.value;
        }

        public String toString() {
            if (this.keyOrNull == null) {
                return "<removed>";
            }
            return this.keyOrNull + "=" + this.value;
        }
    }
}

