/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.EventObject;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.apache.camel.api.management.JmxNotificationBroadcasterAware;
import org.apache.camel.support.EventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxNotificationEventNotifier
extends EventNotifierSupport
implements JmxNotificationBroadcasterAware {
    private static final Logger LOG = LoggerFactory.getLogger(JmxNotificationEventNotifier.class);
    private final AtomicLong counter = new AtomicLong();
    private NotificationBroadcasterSupport notificationBroadcaster;
    private String source = "Camel";

    @Override
    public void setNotificationBroadcaster(NotificationBroadcasterSupport broadcaster) {
        this.notificationBroadcaster = broadcaster;
    }

    @Override
    public void notify(EventObject event) throws Exception {
        if (this.notificationBroadcaster != null) {
            String type = event.getClass().getSimpleName();
            String message = event.toString();
            Notification notification = new Notification(type, (Object)this.source, this.counter.getAndIncrement(), message);
            LOG.trace("Broadcasting JMX notification: {}", (Object)notification);
            this.notificationBroadcaster.sendNotification(notification);
        }
    }

    @Override
    public boolean isEnabled(EventObject event) {
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        this.counter.set(0L);
    }

    @Override
    protected void doStop() throws Exception {
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

