/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiComponentResolver
implements ComponentResolver {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiComponentResolver.class);
    private final BundleContext bundleContext;

    public OsgiComponentResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Object bean = null;
        try {
            bean = context.getRegistry().lookupByName(name);
            if (bean != null) {
                LOG.debug("Found component: {} in registry: {}", (Object)name, bean);
            }
        }
        catch (Exception e) {
            LOG.debug("Ignored error looking up bean: " + name + ". Error: " + e);
        }
        if (bean != null) {
            if (bean instanceof Component) {
                return (Component)bean;
            }
            Component component = CamelContextHelper.convertTo(context, Component.class, bean);
            if (component != null) {
                return component;
            }
        }
        return this.getComponent(name, context);
    }

    protected Component getComponent(String name, CamelContext context) throws Exception {
        LOG.trace("Finding Component: {}", (Object)name);
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(ComponentResolver.class.getName(), "(component=" + name + ")");
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    Object service = this.bundleContext.getService(ref);
                    if (!ComponentResolver.class.isAssignableFrom(service.getClass())) continue;
                    ComponentResolver resolver = (ComponentResolver)service;
                    return resolver.resolveComponent(name, context);
                }
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

