/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.https;

import java.io.IOException;
import java.net.URI;
import javax.net.ssl.SSLSocketFactory;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.transport.http.HttpClientTransport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

public class HttpsClientTransport
extends HttpClientTransport {
    public HttpsClientTransport(TextWireFormat wireFormat, URI remoteUrl) {
        super(wireFormat, remoteUrl);
    }

    @Override
    protected ClientConnectionManager createClientConnectionManager() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(this.createSchemeRegistry());
        return connectionManager;
    }

    private SchemeRegistry createSchemeRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        try {
            org.apache.http.conn.ssl.SSLSocketFactory sslSocketFactory = new org.apache.http.conn.ssl.SSLSocketFactory(this.createSocketFactory(), org.apache.http.conn.ssl.SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            schemeRegistry.register(new Scheme("https", this.getRemoteUrl().getPort(), (SchemeSocketFactory)sslSocketFactory));
            return schemeRegistry;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure trying to create scheme registry", e);
        }
    }

    protected SSLSocketFactory createSocketFactory() throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            SslContext ctx = SslContext.getCurrentSslContext();
            try {
                return ctx.getSSLContext().getSocketFactory();
            }
            catch (Exception e) {
                throw IOExceptionSupport.create(e);
            }
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }
}

