/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.project;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.MSExportWizardPage;
import org.xmind.ui.internal.aspose.exports.project.PriorityMappingDialog;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class ProjectExportPageBase
extends MSExportWizardPage {
    private ResourceManager resources;

    public ProjectExportPageBase(String pageName, String title) {
        super(pageName, title);
    }

    protected Control createSettingsGroup(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Group group = new Group(parent, 0);
        group.setText(WizardMessages.DocumentExportPage_SettingsGroup_title);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 20;
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        group.setLayout((Layout)layout);
        Composite widgetContainer = new Composite((Composite)group, 0);
        widgetContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        containerLayout.verticalSpacing = 7;
        widgetContainer.setLayout((Layout)containerLayout);
        this.createPropertyWidgets(widgetContainer);
        return group;
    }

    protected void createPropertyWidgets(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 10;
        gridLayout.verticalSpacing = 7;
        gridLayout.horizontalSpacing = 7;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText(ExportMessages.ProjectExportPage_content);
        label.setFont(this.resources.createFont(FontDescriptor.createFrom((FontData[])FontUtils.bold((FontData[])parent.getFont().getFontData(), (boolean)true))));
        this.createBooleanContent(parent);
        this.createBooleanWidget(parent);
        this.createPriorityLink(parent);
    }

    private void createBooleanContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 37;
        gridLayout.verticalSpacing = 7;
        gridLayout.horizontalSpacing = 7;
        composite.setLayout((Layout)gridLayout);
        this.createRadio(composite, ProjectExportType.All);
        this.createRadio(composite, ProjectExportType.Hierarchical);
        final Widget flatWidget = this.createRadio(composite, ProjectExportType.Flat);
        Composite skipComposite = new Composite(composite, 0);
        skipComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout skipLayout = new GridLayout(1, false);
        skipLayout.marginWidth = 15;
        skipLayout.marginHeight = 0;
        skipLayout.verticalSpacing = 0;
        skipLayout.horizontalSpacing = 0;
        skipComposite.setLayout((Layout)skipLayout);
        final Widget skipWidget = this.createBooleanWidget(skipComposite, "skipthecompletedtasks", ExportMessages.ProjectExportPage_Skip);
        if (skipWidget instanceof Button) {
            ((Button)skipWidget).setEnabled(this.getProjectExportTypeSelection(ProjectExportType.Flat));
        }
        flatWidget.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (skipWidget instanceof Button) {
                    ((Button)skipWidget).setEnabled(((Button)flatWidget).getSelection());
                }
                if (!((Button)flatWidget).getSelection()) {
                    ((Button)skipWidget).setSelection(false);
                }
            }
        });
    }

    private Widget createRadio(Composite parent, final ProjectExportType type) {
        final Button widget = new Button(parent, 16);
        widget.setText(type.getDescription());
        widget.setData((Object)type);
        widget.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        widget.setSelection(this.getProjectExportTypeSelection(type));
        widget.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (widget.getSelection()) {
                    ProjectExportPageBase.this.getDialogSettings().put("projectType", type.toString());
                    ProjectExportPageBase.this.updateStatus();
                }
            }
        });
        return widget;
    }

    private boolean getProjectExportTypeSelection(ProjectExportType type) {
        boolean isSelection;
        String projectType = this.getDialogSettings().get("projectType");
        ProjectExportType selection = projectType == null ? ProjectExportType.All : ProjectExportType.valueOf(projectType);
        boolean bl = isSelection = type == selection;
        if (isSelection) {
            this.getDialogSettings().put("projectType", selection.toString());
        }
        return isSelection;
    }

    private void createBooleanWidget(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 20;
        gridLayout.verticalSpacing = 7;
        gridLayout.horizontalSpacing = 7;
        composite.setLayout((Layout)gridLayout);
        this.createBooleanWidget(composite, "includeHyperlink", ExportMessages.ProjectExportPage_IncludeHyperlinks);
        this.createBooleanWidget(composite, "includeNotes", ExportMessages.projectExportPage_IncludeNotes);
    }

    private void createPriorityLink(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginBottom = 5;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Hyperlink link = new Hyperlink(composite, 4);
        link.setText(ExportMessages.ProjectExportPage_Button);
        link.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                new PriorityMappingDialog(parent.getShell()).open();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectExportType {
        All(ExportMessages.ProjectExportPage_All_Topic),
        Hierarchical(ExportMessages.ProjectExportPage_Hierarchical),
        Flat(ExportMessages.ProjectExportPage_Flat);

        private String description;

        private ProjectExportType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

