/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.HashMap;
import java.util.Map;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.plain.NotesContent;
import org.xmind.core.plain.Topic;

public class Notes
implements INotes {
    private final Topic ownerTopic;
    private final Map<String, INotesContent> contentMap;

    public Notes(Topic ownerTopic) {
        this.ownerTopic = ownerTopic;
        this.contentMap = new HashMap<String, INotesContent>();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        if (ITopic.class.equals(adapter)) {
            return adapter.cast(this.getParent());
        }
        return null;
    }

    public ITopic getParent() {
        return this.ownerTopic;
    }

    public ISheet getOwnedSheet() {
        return this.ownerTopic.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerTopic.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.ownerTopic.isOrphan();
    }

    public boolean isEmpty() {
        return this.contentMap.isEmpty();
    }

    public void setContent(String format, INotesContent content) {
        if (format == null) {
            throw new IllegalArgumentException("'format' is null");
        }
        INotesContent oldContent = this.contentMap.get(format);
        if (content == oldContent || content != null && content.equals(oldContent)) {
            return;
        }
        if (!this.isOrphan() && oldContent != null && oldContent instanceof NotesContent) {
            ((NotesContent)oldContent).onOrphan();
        }
        if (content == null) {
            this.contentMap.remove(format);
        } else {
            this.contentMap.put(format, content);
        }
        if (!this.isOrphan() && content != null && content instanceof NotesContent) {
            ((NotesContent)content).onParented();
        }
        this.ownerTopic.getCoreEventSupport().dispatchTargetValueChange((ICoreEventSource)this.ownerTopic, "topicNotes", (Object)format, (Object)oldContent, (Object)content);
    }

    public INotesContent getContent(String format) {
        return this.contentMap.get(format);
    }

    protected void onParented() {
        for (INotesContent content : this.contentMap.values()) {
            if (!(content instanceof NotesContent)) continue;
            ((NotesContent)content).onParented();
        }
    }

    protected void onOrphan() {
        for (INotesContent content : this.contentMap.values()) {
            if (!(content instanceof NotesContent)) continue;
            ((NotesContent)content).onOrphan();
        }
    }
}

