/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.Comparator;
import java.util.regex.Pattern;
import org.xmind.core.IIdFactory;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbookBuilder;
import org.xmind.core.IWorkspace;
import org.xmind.core.internal.IDFactory;
import org.xmind.core.internal.TopicCompartor;
import org.xmind.core.internal.Workspace;
import org.xmind.core.internal.dom.MarkerSheetBuilderImpl;
import org.xmind.core.internal.dom.StyleSheetBuilderImpl;
import org.xmind.core.internal.dom.WorkbookBuilderImpl;
import org.xmind.core.marker.IMarkerSheetBuilder;
import org.xmind.core.style.IStyleSheetBuilder;
import org.xmind.core.util.ILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalCore {
    public static final boolean DEBUG_WORKBOOK_SAVE = Boolean.getBoolean("org.xmind.debug.core.workbookSave");
    private static InternalCore instance = null;
    private IWorkbookBuilder workbookBuilder = null;
    private IWorkspace workspace = null;
    private IMarkerSheetBuilder markerSheetBuilder = null;
    private Comparator<ITopic> topicComparator;
    private IIdFactory idFactory;
    private IStyleSheetBuilder styleSheetBuilder;
    private ILogger logger;
    private Pattern partiallyCompatibleVersionPattern = Pattern.compile("[012]\\.\\d+");

    private InternalCore() {
    }

    public String getCurrentVersion() {
        return "2.0";
    }

    public boolean isPartiallyCompatible(String version) {
        if (version == null) {
            return false;
        }
        if (this.getCurrentVersion().equals(version)) {
            return true;
        }
        return this.partiallyCompatibleVersionPattern.matcher(version).matches();
    }

    public synchronized IWorkbookBuilder getWorkbookBuilder() {
        if (this.workbookBuilder == null) {
            this.workbookBuilder = new WorkbookBuilderImpl();
        }
        return this.workbookBuilder;
    }

    public synchronized IWorkspace getWorkspace() {
        if (this.workspace == null) {
            this.workspace = new Workspace();
        }
        return this.workspace;
    }

    public synchronized IMarkerSheetBuilder getMarkerSheetBuilder() {
        if (this.markerSheetBuilder == null) {
            this.markerSheetBuilder = new MarkerSheetBuilderImpl();
        }
        return this.markerSheetBuilder;
    }

    public synchronized Comparator<ITopic> getTopicComparator() {
        if (this.topicComparator == null) {
            this.topicComparator = new TopicCompartor();
        }
        return this.topicComparator;
    }

    public synchronized IIdFactory getIdFactory() {
        if (this.idFactory == null) {
            this.idFactory = new IDFactory();
        }
        return this.idFactory;
    }

    public synchronized IStyleSheetBuilder getStyleSheetBuilder() {
        if (this.styleSheetBuilder == null) {
            this.styleSheetBuilder = new StyleSheetBuilderImpl();
        }
        return this.styleSheetBuilder;
    }

    public synchronized ILogger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger();
        }
        return this.logger;
    }

    public synchronized void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public static InternalCore getInstance() {
        if (instance == null) {
            instance = new InternalCore();
        }
        return instance;
    }

    private final class ConsoleLogger
    implements ILogger {
        private ConsoleLogger() {
        }

        public void log(Throwable e) {
            e.printStackTrace();
        }

        public void log(Throwable e, String message) {
            System.err.println(message);
            e.printStackTrace();
        }

        public void log(String message) {
            System.err.println(message);
        }
    }
}

