/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.animation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Control;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.gef.service.IAnimationService;
import org.xmind.gef.service.IPlaybackProvider;
import org.xmind.ui.animation.LayoutPlaybackProvider;
import org.xmind.ui.util.UITimer;

public class AnimationService
extends GraphicalViewerService
implements IAnimationService {
    private static boolean DEBUG = false;
    private static final int IDLE = 0;
    private static final int RECORDING_INITIAL = 1;
    private static final int RECORDING_FINAL = 2;
    private static final int PLAYBACK = 3;
    private static final IPlaybackProvider DEFAULT_PLAYBACK_PROVIDER = new LayoutPlaybackProvider();
    private UpdateManager updateManager;
    private int state = 0;
    private final LayoutCapturer layoutCapturer = new LayoutCapturer();
    private Map<IFigure, IGraphicalPart> registry = null;
    private IPlaybackProvider playbackProvider = DEFAULT_PLAYBACK_PROVIDER;
    private Set<IFigure> keyFigures = null;
    private Map<IFigure, Object> initialStates = null;
    private Map<IFigure, Object> finalStates = null;
    private Set<IFigure> toCapture = null;
    private float progress = 0.0f;
    private ISafeRunnable task = new PlaybackTask();
    private UITimer timer = null;

    public AnimationService(IGraphicalViewer viewer) {
        super(viewer);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.updateManager = control instanceof FigureCanvas ? ((FigureCanvas)control).getLightweightSystem().getUpdateManager() : null;
    }

    protected void activate() {
    }

    protected void deactivate() {
        this.stop();
    }

    public void registerFigure(IFigure figure, IGraphicalPart part) {
        figure.addLayoutListener((LayoutListener)this.layoutCapturer);
        if (this.registry == null) {
            this.registry = new HashMap<IFigure, IGraphicalPart>();
        }
        this.registry.put(figure, part);
    }

    public void unregisterFigure(IFigure figure) {
        figure.removeLayoutListener((LayoutListener)this.layoutCapturer);
        if (this.registry != null) {
            this.registry.remove(figure);
        }
    }

    public IGraphicalPart getRegisteredPart(IFigure figure) {
        return this.registry == null ? null : this.registry.get(figure);
    }

    public boolean isIdle() {
        return this.state == 0;
    }

    public boolean isAnimating() {
        return this.state == 3;
    }

    protected boolean isRecordingInitial() {
        return this.state == 1;
    }

    protected boolean isRecordingFinal() {
        return this.state == 2;
    }

    public IPlaybackProvider getPlaybackProvider() {
        return this.playbackProvider;
    }

    public void setPlaybackProvider(IPlaybackProvider playbackProvider) {
        if (playbackProvider == null) {
            playbackProvider = DEFAULT_PLAYBACK_PROVIDER;
        }
        this.playbackProvider = playbackProvider;
    }

    public void start(Runnable keyframeMaker, Runnable beforeEffect, Runnable afterEffect) {
        if (keyframeMaker == null || !this.isActive() || this.updateManager == null || this.getViewer().getControl().isDisposed()) {
            return;
        }
        this.stop();
        if (!this.markBegin()) {
            return;
        }
        try {
            keyframeMaker.run();
        }
        catch (Exception exception) {
            this.stop();
            return;
        }
        if (this.state == 0 || this.keyFigures == null || this.keyFigures.isEmpty() || this.getViewer().getControl().isDisposed()) {
            this.stop();
            return;
        }
        this.markEnd();
        this.runPlayback(beforeEffect, afterEffect);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.state = 0;
        SafeRunner.run((ISafeRunnable)this.task);
        this.initialStates = null;
        this.finalStates = null;
        this.keyFigures = null;
        this.toCapture = null;
        this.state = 0;
    }

    protected boolean markBegin() {
        if (this.state == 0) {
            this.state = 1;
            this.initialStates = new HashMap<IFigure, Object>();
            this.finalStates = new HashMap<IFigure, Object>();
            this.keyFigures = new HashSet<IFigure>();
            this.toCapture = new HashSet<IFigure>();
            return true;
        }
        return false;
    }

    protected void recordInitialState(IFigure figure) {
        if (this.initialStates != null) {
            this.initialStates.put(figure, this.getCurrentState(figure));
        }
    }

    protected void markEnd() {
        this.state = 2;
        if (this.updateManager != null) {
            this.updateManager.performValidation();
        }
        this.recordFinalStates();
    }

    protected Object getCurrentState(IFigure figure) {
        return this.playbackProvider.getState(figure, this.getRegisteredPart(figure));
    }

    private void recordFinalStates() {
        Iterator<IFigure> figureIterator = this.keyFigures.iterator();
        while (figureIterator.hasNext()) {
            IFigure fig = figureIterator.next();
            if (this.toCapture.contains(fig)) {
                this.recordFinalState(fig);
                continue;
            }
            figureIterator.remove();
        }
    }

    protected void recordFinalState(IFigure figure) {
        if (this.finalStates != null) {
            this.finalStates.put(figure, this.getCurrentState(figure));
        }
    }

    private void runPlayback(final Runnable beforeEffect, Runnable afterEffect) {
        if (beforeEffect != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Error running effect before animation."){

                public void run() throws Exception {
                    beforeEffect.run();
                }
            });
        }
        if (this.state == 0 || this.getViewer().getControl().isDisposed()) {
            return;
        }
        this.state = 3;
        this.progress = 0.0f;
        SafeRunner.run((ISafeRunnable)this.task);
        this.timer = new PlaybackTimer(afterEffect);
        this.timer.run();
    }

    protected boolean playback(IFigure figure) {
        if (this.toCapture != null && this.toCapture.contains(figure)) {
            return this.doPlayback(figure);
        }
        return false;
    }

    protected boolean doPlayback(IFigure figure) {
        Map initial = (Map)this.getInitialState(figure);
        Map ending = (Map)this.getFinalState(figure);
        if (initial == null || ending == null) {
            return false;
        }
        return this.playbackProvider.doPlayback(figure, this.getRegisteredPart(figure), (Object)initial, (Object)ending, this.progress);
    }

    protected Object getInitialState(IFigure figure) {
        return this.initialStates == null ? null : this.initialStates.get(figure);
    }

    protected Object getFinalState(IFigure figure) {
        return this.finalStates == null ? null : this.finalStates.get(figure);
    }

    protected void hookPlayback(IFigure figure) {
        if (this.keyFigures != null && this.keyFigures.add(figure)) {
            this.recordInitialState(figure);
        }
    }

    protected void hookCapture(IFigure container) {
        if (this.keyFigures != null && this.keyFigures.contains(container) && this.toCapture != null) {
            this.toCapture.add(container);
        }
    }

    public boolean isAnimating(IFigure figure) {
        if (this.isAnimating()) {
            return this.getInitialState(figure) != null && this.getFinalState(figure) != null;
        }
        if (this.isRecordingFinal()) {
            return this.getInitialState(figure) != null;
        }
        return false;
    }

    private class LayoutCapturer
    implements LayoutListener {
        private LayoutCapturer() {
        }

        public void invalidate(IFigure container) {
            if (AnimationService.this.isRecordingInitial()) {
                AnimationService.this.hookPlayback(container);
            }
        }

        public boolean layout(IFigure container) {
            if (AnimationService.this.isAnimating()) {
                return AnimationService.this.playback(container);
            }
            return false;
        }

        public void postLayout(IFigure container) {
            if (AnimationService.this.isRecordingFinal()) {
                AnimationService.this.hookCapture(container);
            }
        }

        public void remove(IFigure child) {
        }

        public void setConstraint(IFigure child, Object constraint) {
        }
    }

    private class PlaybackTask
    extends SafeRunnable {
        private PlaybackTask() {
        }

        public void run() throws Exception {
            if (AnimationService.this.getViewer().getControl().isDisposed()) {
                return;
            }
            if (AnimationService.this.initialStates != null) {
                for (IFigure figure : AnimationService.this.initialStates.keySet()) {
                    figure.revalidate();
                }
            }
            if (AnimationService.this.timer == null || AnimationService.this.timer.isCanceled()) {
                return;
            }
            AnimationService.this.progress = (float)AnimationService.this.timer.getCurrentLoop() * 1.0f / (float)(AnimationService.this.timer.getLoops() + 1);
        }
    }

    private class PlaybackTimer
    extends UITimer {
        private Runnable afterEffect;

        public PlaybackTimer(Runnable after) {
            super(0, DEBUG ? 300 : 10, DEBUG ? 10 : 3, AnimationService.this.task);
            this.afterEffect = after;
        }

        protected void onFinished() {
            super.onFinished();
            AnimationService.this.timer = null;
            AnimationService.this.stop();
            this.runAfterEffect();
        }

        private void runAfterEffect() {
            if (this.afterEffect != null && !AnimationService.this.getViewer().getControl().isDisposed()) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable("Error running effect after animation."){

                    public void run() throws Exception {
                        PlaybackTimer.this.afterEffect.run();
                    }
                });
            }
        }

        protected void onCanceled() {
            super.onCanceled();
            this.runAfterEffect();
            AnimationService.this.timer = null;
            AnimationService.this.stop();
        }
    }
}

