/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.views.CategorizedThemeViewer;
import org.xmind.ui.internal.views.ThemeLabelProvider;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;

public class ThemeChooserDialog
extends Dialog {
    private IStyle selectedTheme = null;
    private String structureClass;

    protected ThemeChooserDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected ThemeChooserDialog(Shell parentShell, String structureClass) {
        this(parentShell);
        this.structureClass = structureClass;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(WorkbenchMessages.DashboardThemeChoose_message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new FillLayout());
        GridData parentData = (GridData)composite.getLayoutData();
        parentData.widthHint = 940;
        parentData.heightHint = 500;
        this.doCreateViewer(composite);
        return composite;
    }

    private void doCreateViewer(Composite parent) {
        CategorizedThemeViewer viewer = this.doCreatePartControlViewer(parent);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ThemeChooserDialog.this.selectedTheme = (IStyle)((IStructuredSelection)event.getSelection()).getFirstElement();
                ThemeChooserDialog.this.setButtonEnabled(0, !event.getSelection().isEmpty());
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                ThemeChooserDialog.this.selectedTheme = selection.isEmpty() ? null : (IStyle)((IStructuredSelection)selection).getFirstElement();
                ThemeChooserDialog.this.setReturnCode(0);
                ThemeChooserDialog.this.close();
            }
        });
        IResourceManager rm = MindMapUI.getResourceManager();
        IStyle defaultTheme = rm.getDefaultTheme();
        viewer.setSelection((ISelection)new StructuredSelection((Object)defaultTheme));
    }

    private CategorizedThemeViewer doCreatePartControlViewer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        CategorizedThemeViewer viewer = new CategorizedThemeViewer(container){

            protected void postInit() {
            }

            protected void initGalleryViewer(GalleryViewer galleryViewerer) {
                galleryViewerer.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider(ThemeChooserDialog.this.structureClass));
                EditDomain editDomain = new EditDomain();
                editDomain.installTool("select tool", (ITool)new GallerySelectTool());
                galleryViewerer.setEditDomain(editDomain);
                Properties properties = galleryViewerer.getProperties();
                properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
                properties.set("org.xmind.ui.gallery.hideTitle", false);
                properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
                properties.set("org.xmind.ui.gallery.solidFrames", true);
                properties.set("org.xmind.ui.gallery.flatFrames", true);
                properties.set("constrained", true);
                properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
            }
        };
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return viewer;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = WorkbenchMessages.DashboardThemeCreate_label;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.selectedTheme = null;
    }

    public IStyle getSelectedTheme() {
        return this.selectedTheme;
    }

    private void setButtonEnabled(int id, boolean enabled) {
        Button button = this.getButton(id);
        if (button == null || button.isDisposed()) {
            return;
        }
        button.setEnabled(enabled);
    }
}

