/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.seawind.internal.core.SeawindFile;
import org.xmind.ui.internal.seawind.SeawindFolderManager;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;
import org.xmind.ui.internal.seawind.URIUtils;
import org.xmind.ui.internal.seawind.handlers.MoveToDialog;

public class MoveCloudMapHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ArrayList<SeawindFile> files = new ArrayList<SeawindFile>();
            SeawindFolderManager manager = SeawindUIPlugin.getSeawindLibrary().getSeawindFolderManager();
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof SeawindWorkbookRef)) continue;
                String workbookId = URIUtils.getWorkbookIdFromURI(((SeawindWorkbookRef)((Object)element)).getURI());
                SeawindFile file = manager.getSeawindFile(workbookId);
                files.add(file);
            }
            if (!files.isEmpty()) {
                this.moveCloudMap(files, shell);
            }
        }
        return null;
    }

    private void moveCloudMap(List<SeawindFile> sources, Shell shell) {
        MoveToDialog dialog = new MoveToDialog(shell, sources);
        if (dialog.open() == 0) {
            String targetFolderPath = dialog.getPath();
            if (sources.get(0).getOwnedParent().getPath().equals(targetFolderPath)) {
                return;
            }
            for (SeawindFile source : sources) {
                SeawindUIPlugin.getSeawindLibrary().moveFile(source, targetFolderPath);
            }
        }
    }
}

