/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.xmind.core.IComment;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.comments.CommentTextViewer;
import org.xmind.ui.internal.comments.CommentsPartActionBarContributor;
import org.xmind.ui.internal.comments.CommentsSelectionProvider;
import org.xmind.ui.internal.comments.ICommentTextViewerContainer;
import org.xmind.ui.internal.comments.ICommentsActionBarContributor;
import org.xmind.ui.internal.comments.SheetCommentsViewer;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ColorUtils;

public class CommentsView
extends ViewPart
implements IContributedContentsView,
IPartListener,
ISelectionChangedListener,
ICoreEventListener,
ICommentTextViewerContainer {
    public static final Color BG_COLOR = ColorUtils.getColor((String)"#ffffff");
    private static final String COMMENTS_EDIT_CONTEXT_ID = "org.xmind.ui.context.comments.edit";
    private static final Color INVALID_COLER = ColorUtils.getColor((String)"#f0f0f0");
    private CommentsPartActionBarContributor contributor;
    private ISelectionProvider selectionProvider = new CommentsSelectionProvider();
    private Map<String, ActionFactory.IWorkbenchAction> workbenchActions = new HashMap<String, ActionFactory.IWorkbenchAction>(7);
    private List<TextAction> textActions = new ArrayList<TextAction>(7);
    private IGraphicalEditor contributingEditor;
    private ITopicPart currentTopicPart;
    private ICoreEventRegister commentEventRegister;
    private ICoreEventRegister globalEventRegister;
    private ScrolledComposite sc;
    private Composite contentComposite;
    private SheetCommentsViewer contentViewer;
    private ISheet sheet;
    private Control control;
    private ControlListener controlListener;
    private IHandlerActivation commitHandlerActivation;
    private IComment latestCreatedComment;
    private IComment selectedComment;

    public void createPartControl(Composite parent) {
        this.contributor = new CommentsPartActionBarContributor(null, this.contributingEditor);
        this.control = this.createControl(parent);
        this.setInitialInput();
        this.activateHandlers();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.createActions(actionBars);
        new ContextActivator();
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    private void activateHandlers() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (handlerService != null) {
            this.commitHandlerActivation = handlerService.activateHandler("org.xmind.ui.command.commitComments", (IHandler)new CommitCommentHandler());
        }
    }

    private void deactivateHandlers() {
        if (this.commitHandlerActivation != null) {
            this.commitHandlerActivation.getHandlerService().deactivateHandler(this.commitHandlerActivation);
            this.commitHandlerActivation = null;
        }
    }

    private void saveComment() {
        if (this.contentViewer != null) {
            this.contentViewer.save();
        }
    }

    private void setInitialInput() {
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor) {
            this.setContributingEditor((IGraphicalEditor)activeEditor);
        } else {
            this.setInput(null);
        }
    }

    private Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(BG_COLOR);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.contentComposite = this.createContentComposite(composite);
        return composite;
    }

    private Composite createContentComposite(Composite parent) {
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.setBackground(parent.getBackground());
        this.sc.setLayoutData((Object)new GridData(1808));
        this.sc.setExpandHorizontal(true);
        Composite composite = new Composite((Composite)this.sc, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 29;
        composite.setLayout((Layout)gridLayout);
        this.sc.setContent((Control)composite);
        this.sc.getVerticalBar().setIncrement(17);
        this.sc.addControlListener(this.getControlListener());
        return composite;
    }

    private ControlListener getControlListener() {
        if (this.controlListener == null) {
            this.controlListener = new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    e.widget.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CommentsView.this.contentComposite != null && !CommentsView.this.contentComposite.isDisposed()) {
                                CommentsView.this.contentComposite.pack();
                            }
                        }
                    });
                }
            };
        }
        return this.controlListener;
    }

    private void setInput(ISheet sheet) {
        if (this.sheet == sheet) {
            return;
        }
        this.sheet = sheet;
        this.unhookSheet();
        this.update();
        this.hookSheet();
    }

    private void hookSheet() {
        if (this.sheet != null) {
            if (this.commentEventRegister == null) {
                this.commentEventRegister = new CoreEventRegister((ICoreEventSupport)this.sheet.getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
            }
            this.commentEventRegister.register("commentAdd");
            this.commentEventRegister.register("commentRemove");
            this.registerGlobalEvent();
        }
    }

    private void unhookSheet() {
        if (this.commentEventRegister != null) {
            this.commentEventRegister.unregisterAll();
            this.commentEventRegister = null;
        }
        this.unRegisterGlobalEvent();
    }

    private void registerGlobalEvent() {
        this.globalEventRegister = new CoreEventRegister((ICoreEventSupport)this.sheet.getOwnedWorkbook().getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
        this.globalEventRegister.register("commentContent");
    }

    private void unRegisterGlobalEvent() {
        if (this.globalEventRegister != null) {
            this.globalEventRegister.unregisterAll();
            this.globalEventRegister = null;
        }
    }

    private void update() {
        this.resetSelectedComment();
        this.updateCompositeEnabled();
        this.updateComments();
    }

    private void resetSelectedComment() {
        this.contributor.selectedCommentChanged(null);
    }

    private void updateCompositeEnabled() {
        this.sc.setEnabled(this.sheet != null);
        if (this.sheet == null) {
            this.contentComposite.getParent().setBackground(INVALID_COLER);
            this.contentComposite.setBackground(INVALID_COLER);
        } else {
            this.contentComposite.getParent().setBackground(this.control.getBackground());
            this.contentComposite.setBackground(this.control.getBackground());
        }
    }

    private void updateComments() {
        this.contentComposite.setRedraw(false);
        this.clearContent();
        this.selectionProvider.setSelection(null);
        if (this.sheet != null) {
            this.contentViewer = new SheetCommentsViewer(this.sheet, this.contributor, this.selectionProvider, this, this.contributingEditor);
            this.contentViewer.create(this.contentComposite);
        }
        this.contentComposite.pack();
        this.contentComposite.setRedraw(true);
    }

    private void clearContent() {
        Control[] controls = this.contentComposite.getChildren();
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control != null && !control.isDisposed()) {
                    control.dispose();
                    Object var2_5 = null;
                }
                ++n2;
            }
        }
    }

    private void createActions(IActionBars actionBars) {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        this.addGlobalTextAction(actionBars, window, ActionFactory.UNDO, 1);
        this.addGlobalTextAction(actionBars, window, ActionFactory.REDO, 2);
        this.addGlobalTextAction(actionBars, window, ActionFactory.CUT, 3);
        this.addGlobalTextAction(actionBars, window, ActionFactory.COPY, 4);
        this.addGlobalTextAction(actionBars, window, ActionFactory.PASTE, 5);
        this.addGlobalTextAction(actionBars, window, ActionFactory.SELECT_ALL, 7);
    }

    private void addGlobalTextAction(IActionBars actionBars, IWorkbenchWindow window, ActionFactory actionFactory, int textOp) {
        ActionFactory.IWorkbenchAction action = actionFactory.create(window);
        this.workbenchActions.put(action.getId(), action);
        TextAction textAction = new TextAction(textOp);
        this.textActions.add(textAction);
        actionBars.setGlobalActionHandler(action.getId(), (IAction)textAction);
    }

    public ActionFactory.IWorkbenchAction getGlobalAction(String actionId) {
        return this.workbenchActions == null ? null : this.workbenchActions.get(actionId);
    }

    public void updateTextActions(TextViewer textViewer) {
        if (textViewer != null) {
            for (TextAction action : this.textActions) {
                action.update(textViewer);
            }
        }
    }

    public void dispose() {
        this.unhookSheet();
        this.deactivateHandlers();
        if (this.contributor != null) {
            this.contributor.dispose();
        }
        if (this.sc != null && !this.sc.isDisposed()) {
            this.sc.removeControlListener(this.getControlListener());
        }
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.setContributingEditor(null);
        super.dispose();
        if (this.workbenchActions != null) {
            for (ActionFactory.IWorkbenchAction action : this.workbenchActions.values()) {
                action.dispose();
            }
            this.workbenchActions = null;
        }
        this.textActions = null;
    }

    public void setFocus() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        if (adapter == ITextViewer.class) {
            return this.getImplementation() == null ? null : this.getImplementation().getTextViewer();
        }
        if (adapter == ITopicPart.class) {
            return this.currentTopicPart;
        }
        if (adapter == ITopic.class) {
            return this.currentTopicPart == null ? null : this.currentTopicPart.getTopic();
        }
        return super.getAdapter(adapter);
    }

    private CommentTextViewer getImplementation() {
        if (this.selectionProvider instanceof CommentsSelectionProvider) {
            Object obj;
            Object obj2;
            ISelection selection = this.selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection && (obj2 = ((IStructuredSelection)selection).getFirstElement()) instanceof CommentTextViewer) {
                return (CommentTextViewer)obj2;
            }
            ISelection oldSelection = ((CommentsSelectionProvider)this.selectionProvider).getOldSelection();
            if (oldSelection instanceof IStructuredSelection && (obj = ((IStructuredSelection)oldSelection).getFirstElement()) instanceof CommentTextViewer) {
                return (CommentTextViewer)obj;
            }
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IGraphicalEditor) {
            this.setContributingEditor((IGraphicalEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.contributingEditor) {
            this.setContributingEditor(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private void setContributingEditor(IGraphicalEditor editor) {
        ISelectionProvider selectionProvider;
        if (editor == this.contributingEditor) {
            return;
        }
        if (this.contributingEditor != null && (selectionProvider = this.contributingEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.contributingEditor = editor;
        if (this.contributingEditor != null && (selectionProvider = this.contributingEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.contentViewer != null) {
            this.contentViewer.setTargetEditor(this.contributingEditor);
        }
        if (this.contributor != null) {
            this.contributor.setTargetEditor(this.contributingEditor);
        }
        ISheet sheet = this.getSheet(this.contributingEditor);
        this.setInput(sheet);
    }

    public IWorkbenchPart getContributingPart() {
        return this.contributingEditor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISheet sheet = this.getSheet(this.contributingEditor);
        this.setInput(sheet);
    }

    private ISheet getSheet(IGraphicalEditor editor) {
        if (editor != null && editor.getActivePageInstance() != null) {
            return (ISheet)editor.getActivePageInstance().getAdapter(ISheet.class);
        }
        return null;
    }

    public void handleCoreEvent(final CoreEvent event) {
        final String type = event.getType();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!CommentsView.this.contentComposite.isDisposed()) {
                    IComment comment;
                    Object source;
                    if ("commentAdd".equals(type) || "commentRemove".equals(type)) {
                        CommentsView.this.update();
                    } else if ("commentContent".equals(type) && ((source = (comment = (IComment)event.getSource()).getOwnedWorkbook().getElementById(comment.getObjectId())) instanceof ITopic && ((ITopic)source).getOwnedSheet() == CommentsView.this.sheet || source instanceof ISheet && source == CommentsView.this.sheet)) {
                        CommentsView.this.update();
                    }
                }
            }
        });
    }

    @Override
    public void moveToPreviousTextViewer(CommentTextViewer implementation) {
        List<CommentTextViewer> implementations = this.contentViewer.getImplementations();
        int index = implementations.indexOf(implementation);
        if (index <= 0 || index > implementations.size() - 1) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection((Object)implementations.get(index - 1)));
    }

    @Override
    public void moveToNextTextViewer(CommentTextViewer implementation) {
        List<CommentTextViewer> implementations = this.contentViewer.getImplementations();
        int index = implementations.indexOf(implementation);
        if (index < 0 || index >= implementations.size() - 1) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection((Object)implementations.get(index + 1)));
    }

    private void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    @Override
    public Composite getContentComposite() {
        return this.contentComposite;
    }

    @Override
    public ScrolledComposite getScrolledComposite() {
        return this.sc;
    }

    public ICommentsActionBarContributor getContributor() {
        return this.contributor;
    }

    @Override
    public void setLatestCreatedComment(IComment latestCreatedComment) {
        this.latestCreatedComment = latestCreatedComment;
    }

    @Override
    public IComment getLatestCreatedComment() {
        return this.latestCreatedComment;
    }

    @Override
    public void setSelectedComment(IComment selectedComment) {
        this.selectedComment = selectedComment;
    }

    @Override
    public IComment getSelectedComment() {
        return this.selectedComment;
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public void createComment(String objectId) {
        this.contentViewer.createNewComment(objectId);
    }

    @Override
    public void cancelCreateComment() {
        this.contentViewer.cancelCreateNewComment();
    }

    @Override
    public void setEditingComment(IComment comment) {
    }

    @Override
    public IComment getEditingComment() {
        return null;
    }

    @Override
    public void setModified(boolean modified) {
    }

    @Override
    public boolean isModified() {
        return false;
    }

    private class CommitCommentHandler
    extends AbstractHandler {
        private CommitCommentHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            CommentsView.this.saveComment();
            return null;
        }
    }

    private class ContextActivator
    implements IPartListener {
        IContextActivation context;
        IContextService service;

        public ContextActivator() {
            CommentsView.this.getSite().getPage().addPartListener((IPartListener)this);
        }

        private void activateContext() {
            if (this.service == null) {
                this.service = (IContextService)CommentsView.this.getSite().getService(IContextService.class);
            }
            if (this.service != null) {
                this.context = this.service.activateContext(CommentsView.COMMENTS_EDIT_CONTEXT_ID);
            }
        }

        private void deactivateContext() {
            if (this.service != null && this.context != null) {
                this.service.deactivateContext(this.context);
            }
            this.context = null;
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof CommentsView) {
                this.activateContext();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            CommentsView.this.getSite().getPage().removePartListener((IPartListener)this);
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part instanceof CommentsView) {
                this.deactivateContext();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class TextAction
    extends Action {
        private TextViewer textViewer;
        private int op;

        public TextAction(int op) {
            this.op = op;
        }

        public void run() {
            if (this.textViewer != null && this.textViewer.canDoOperation(this.op)) {
                this.textViewer.doOperation(this.op);
                CommentsView.this.contentComposite.pack();
            }
        }

        public void update(TextViewer textViewer) {
            this.textViewer = textViewer;
            this.setEnabled(textViewer != null && textViewer.canDoOperation(this.op));
        }
    }
}

