/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.util.Logger;

public class ToolExtensionRegistry
extends RegistryReader {
    private static final ToolExtensionRegistry instance = new ToolExtensionRegistry();
    private Map<String, ToolFactory> factories = null;

    private ToolExtensionRegistry() {
    }

    public ITool createTool(String id) {
        this.ensureLoaded();
        ToolFactory factory = this.factories.get(id);
        if (factory == null) {
            return null;
        }
        return factory.createInstance();
    }

    private void ensureLoaded() {
        if (this.factories != null) {
            return;
        }
        this.lazyLoad();
        if (this.factories == null) {
            this.factories = Collections.emptyMap();
        }
    }

    private void lazyLoad() {
        if (Platform.isRunning()) {
            this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "tools");
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("tool".equals(name)) {
            this.readToolFactory(element);
            this.readElementChildren(element);
            return true;
        }
        return false;
    }

    private void readToolFactory(IConfigurationElement element) {
        try {
            this.register(new ToolFactory(element));
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to create tool factory");
        }
    }

    private void register(ToolFactory factory) {
        if (this.factories == null) {
            this.factories = new HashMap<String, ToolFactory>();
        }
        this.factories.put(factory.getId(), factory);
    }

    public static ToolExtensionRegistry getInstance() {
        return instance;
    }

    private static class ToolFactory {
        private IConfigurationElement element;
        private String id;
        private boolean failed = false;

        public ToolFactory(IConfigurationElement element) throws CoreException {
            this.element = element;
            this.id = element.getAttribute("id");
            if (ToolExtensionRegistry.getClassValue((IConfigurationElement)element, (String)"class") == null) {
                throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid extension (missing class value)"));
            }
        }

        public String getId() {
            return this.id;
        }

        public ITool createInstance() {
            if (this.failed) {
                return null;
            }
            try {
                return (ITool)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                this.failed = true;
                Logger.log(e, "Failed to create tool instance (id=" + this.id + ")");
                return null;
            }
        }
    }
}

