/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.RandomAccess;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.io.Files;
import phelps.io.PrintStreams;

public class Undo {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.1 of $Date: 2003/08/09 08:25:46 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Undo [-inplace] <PDF-file>";
    private boolean finplace_;
    private boolean fverbose_;
    private boolean fquiet_;
    private PrintStream out_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Undo() {
        this.defaults();
    }

    public void defaults() {
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public boolean undo(File file, File file2) throws IOException, ParseException {
        Object object;
        if (this.fverbose_) {
            System.out.println(file);
        }
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        if (file2 == null) {
            object = file.getPath();
            String string = (String)(((String)object).toLowerCase().endsWith(".pdf") ? ((String)object).substring(0, ((String)object).length() - ".pdf".length()) : object) + "-undo.pdf";
            file2 = new File(string);
        }
        object = null;
        try {
            object = new PDFReader(file);
        }
        catch (ParseException parseException) {
            System.err.println("Can't open " + file);
            throw parseException;
        }
        catch (IOException iOException) {
            System.err.println("Can't open " + file);
            throw iOException;
        }
        ((PDFReader)object).setExact(true);
        long l = ((PDFReader)object).getStartXRef();
        Dict dict = ((PDFReader)object).getTrailer();
        Object object2 = dict.get("Prev");
        if (object2 == null) {
            if (this.fverbose_) {
                System.out.println("no incremental update");
            }
            return false;
        }
        RandomAccess randomAccess = ((PDFReader)object).getRA();
        long l2 = ((Number)object2).longValue();
        long l3 = 0L;
        long l4 = 0L;
        while (object2 != null) {
            l3 = ((Number)object2).longValue();
            if (l3 > l4) {
                l4 = l3;
            }
            randomAccess.seek(l3);
            dict = ((PDFReader)object).readXref(false);
            object2 = dict.get("Prev");
        }
        if (l < l4) {
            if (this.fverbose_) {
                System.out.println("no incremental update (Linearized)");
            }
            return false;
        }
        if (l3 != l4) {
            randomAccess.seek(l4);
            ((PDFReader)object).readXref(false);
        }
        long l5 = randomAccess.getFilePointer();
        ((PDFReader)object).close();
        if (!file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            Files.copy(file, file2);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        randomAccessFile.setLength(l5);
        randomAccessFile.seek(l5);
        randomAccessFile.writeBytes("startxref\n" + l2 + "\n" + "%%EOF" + "\n");
        randomAccessFile.close();
        if (this.fverbose_) {
            this.out_.println("truncated @ " + l5);
        }
        return true;
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.equals("-inplace")) {
                this.finplace_ = true;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int n;
        Undo undo = new Undo();
        int n2 = undo.commandLine(stringArray);
        if (n2 + 1 != (n = stringArray.length)) {
            System.err.println(USAGE);
            System.exit(0);
        }
        File file = new File(stringArray[n2]);
        if (System.getSecurityManager() == null) {
            try {
                undo.undo(file, undo.finplace_ ? file : null);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    static {
        $assertionsDisabled = !Undo.class.desiredAssertionStatus();
    }
}

