/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import com.pt.io.OutputUni;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.io.PrintStreams;

public class Embed {
    static final boolean DEBUG = true;
    public static final String VERSION = "0.2 of $Date: 2003/12/07 03:49:26 $";
    public static final String COPYRIGHT = "Copyright (c) 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Embed [<options>] <PDF-file...>\n\t[-fonts] [-images] [-streams]\n\t[-pool <directory>] [-max <size>]\n\t[-password <password>] [-verbose] [-quiet]";
    private boolean ffont_ = false;
    private boolean fimage_ = false;
    private boolean fstream_ = false;
    private String range_ = null;
    private File pool_ = new File(".");
    private long max_ = Long.MAX_VALUE;
    private String password_ = null;
    private boolean fverbose_ = false;
    private boolean fquiet_ = false;
    private boolean fmonitor_ = false;
    private PrintStream out_ = PrintStreams.DEVNULL;
    private PDFReader pdfr_;

    public Embed(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Embed(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Embed(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Embed(PDFReader pDFReader) {
    }

    public void setFont(boolean bl) {
        this.ffont_ = bl;
    }

    public void setImage(boolean bl) {
        this.fimage_ = bl;
    }

    public void setStream(boolean bl) {
        this.fstream_ = bl;
    }

    public void setMax(int n) {
        this.max_ = n;
    }

    public void setPool(File file) {
        this.pool_ = file;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void writeFile(File file) throws IOException, ParseException {
        this.writeUni(OutputUni.getInstance(file, null));
    }

    public byte[] writeBytes() throws IOException, ParseException {
        OutputUni outputUni = OutputUni.getInstance(new byte[this.pdfr_.getObjCnt() * 100], null);
        this.writeUni(outputUni);
        return outputUni.toByteArray();
    }

    public void writeUni(OutputUni outputUni) throws IOException, ParseException {
        this.embed(new PDFWriter(outputUni, this.pdfr_));
    }

    public PDFReader writePipe() throws IOException, ParseException {
        return null;
    }

    public Object embed(PDFWriter pDFWriter) throws IOException, ParseException {
        this.pdfr_.setPassword(this.password_);
        if (!this.pdfr_.isAuthorized()) {
            throw new ParseException("invalid password");
        }
        pDFWriter.setPassword(this.password_);
        Object object = pDFWriter.writePDF();
        this.pdfr_.close();
        pDFWriter.close();
        return object;
    }

    public void embed2(PDFWriter pDFWriter) throws IOException, ParseException {
        pDFWriter.setCompress(false);
    }

    private int commandLine(String[] stringArray) throws UnsupportedOperationException, NumberFormatException {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-max")) {
                this.setMax(Integer.parseInt(stringArray[++n]));
                continue;
            }
            if (string.startsWith("-pool") || string.startsWith("-cache")) {
                this.setPool(new File(stringArray[++n]));
                continue;
            }
            if (string.startsWith("-page") || string.startsWith("-range")) {
                this.setRange(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Embed embed = new Embed((PDFReader)null);
        int n = 0;
        try {
            n = embed.commandLine(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                embed.pdfr_ = new PDFReader(file);
                String string = file.getPath();
                if (file.getName().toLowerCase().endsWith(".pdf")) {
                    string = string.substring(0, string.length() - 4);
                }
                embed.writeFile(new File(string + "-em.pdf"));
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }
}

