/*
 * Decompiled with CFR 0.152.
 */
package tool.file;

import com.pt.io.FileLog;
import com.pt.io.FileLogRecord;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import phelps.io.FileFilterPattern;
import phelps.io.Files;
import phelps.io.PrintStreams;
import phelps.util.Arrayss;
import phelps.util.Dates;

public class Log
implements Observer {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2004/01/23 08:17:19 $";
    public static final String USAGE = "java tool.file.Log [<options>] <directory...>\n\t[-write <file>]\n\t[-filter <regex>]";
    static final int DATA_VERSION = 1;
    private File log_;
    private String[] paths_;
    private FileFilter ff_;
    private long now_;
    private PrintStream out_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;

    public Log() {
        this.defaults();
    }

    public void defaults() {
        this.log_ = null;
        this.paths_ = null;
        this.ff_ = null;
        this.now_ = System.currentTimeMillis();
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setLog(File file) {
        this.log_ = file;
    }

    public void log() throws IOException {
        String[] stringArray = new String[this.paths_.length];
        int n = this.paths_.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Files.relative(null, new File(this.paths_[i]).getCanonicalFile());
        }
        FileLog fileLog = new FileLog(this.log_, stringArray, true, 1);
        fileLog.update(this, this.ff_);
        if (fileLog != null) {
            fileLog.write();
        }
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray = (Object[])object;
        Object object2 = objectArray[0];
        FileLogRecord fileLogRecord = (FileLogRecord)objectArray[1];
        FileLogRecord fileLogRecord2 = objectArray.length >= 3 ? (FileLogRecord)objectArray[2] : null;
        File file = new File(fileLogRecord.path);
        if (!file.isDirectory() && "same" != object2) {
            if ("new" == object2) {
                this.out_.println("NEW " + this.flm(fileLogRecord));
            } else if ("changed" == object2) {
                if (!new File(fileLogRecord.path).isDirectory()) {
                    this.out_.println("CHANGED " + this.flm(fileLogRecord) + " => " + this.flm(fileLogRecord2));
                }
            } else if ("deleted" == object2) {
                this.out_.println("X " + this.flm(fileLogRecord));
            } else if ("moved" == object2) {
                this.out_.println("MOVED " + this.flm(fileLogRecord) + " => " + this.flm(fileLogRecord2));
            } else if ("duplicate" == object2 && fileLogRecord.length > 10L) {
                this.out_.println("DUPLICATE " + this.flm(fileLogRecord) + "  and  " + this.flm(fileLogRecord2));
            }
        }
    }

    private String flm(FileLogRecord fileLogRecord) {
        return Files.relative(null, new File(fileLogRecord.path)) + " / " + fileLogRecord.length + " / " + Dates.relative(fileLogRecord.mod, this.now_);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        this.fverbose_ = true;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-write")) {
                this.setLog(new File(stringArray[++n]));
                continue;
            }
            if (string.startsWith("-filter")) {
                this.ff_ = new FileFilterPattern(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        this.paths_ = Arrayss.subset(stringArray, n, n2 - n);
        return n;
    }

    public static void main(String[] stringArray) {
        Log log = new Log();
        int n = log.commandLine(stringArray);
        try {
            log.log();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }
}

