/*
 * Decompiled with CFR 0.152.
 */
package tool.file;

import com.pt.io.FileList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import phelps.io.InputStreams;
import phelps.io.PrintStreams;

public class CRC {
    public static final String USAGE = "java tool.file.CRC <file-or-directory...>";
    public static final String VERSION = "1.0 of $Date: 2004/03/19 05:35:01 $";
    private boolean fverbose_ = false;
    private PrintStream out_ = PrintStreams.DEVNULL;

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void crc(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = InputStreams.crc32(fileInputStream);
        fileInputStream.close();
        this.out_.println(l + " " + file.length() + " " + file);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.setOut(System.out);
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) continue;
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.equals("-help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        CRC cRC = new CRC();
        int n2 = cRC.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n2, null).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                cRC.crc(file);
            }
            catch (IOException iOException) {
                System.err.println(file + ": " + iOException);
            }
        }
    }
}

