/*
 * Decompiled with CFR 0.152.
 */
package tool.doc;

import com.pt.io.InputUni;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import multivalent.Behavior;
import multivalent.Context;
import multivalent.Document;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.MediaAdaptor;
import multivalent.Multivalent;
import multivalent.Node;
import multivalent.Span;
import multivalent.node.INodeZero;
import multivalent.node.LeafImage;
import multivalent.node.LeafText;
import multivalent.node.LeafZero;
import multivalent.std.adaptor.CSS;
import phelps.lang.Integers;
import tool.doc.DocWalkerObserver;

public class DocWalker {
    private URI uri_;
    private int hints_;
    private MediaAdaptor ma_;
    private List<DocWalkerObserver> obs_ = new ArrayList<DocWalkerObserver>(5);
    private Document doc_;
    private int pagecnt_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DocWalker(InputUni inputUni, int n) throws Exception {
        this.uri_ = inputUni.getURI();
        this.hints_ = n;
        String string = Multivalent.getInstance().getGenre(inputUni.getContentType(), this.uri_.getSchemeSpecificPart());
        this.ma_ = (MediaAdaptor)Behavior.getInstance(string, string, null, null, null);
        this.ma_.setInput(inputUni);
        this.ma_.setHints(n);
        this.init(inputUni);
        this.doc_.uri = inputUni.getURI();
    }

    private void init(InputUni inputUni) throws Exception {
        Document document = this.doc_ = new Document("top", null, null);
        this.ma_.parse(this.doc_);
        this.pagecnt_ = Integers.parseInt(document.getAttr("pages"), -1);
        String string = inputUni.getContentType();
        String string2 = Multivalent.getInstance().getGenre(string, inputUni.getURI().getPath());
        URL uRL = this.getClass().getResource("/sys/stylesheet/" + string2 + ".css");
        if (uRL != null) {
            try {
                CSS cSS = new CSS();
                cSS.parse(uRL);
                cSS.setCascade(document);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPassword(String string) {
    }

    public void addObserver(DocWalkerObserver docWalkerObserver) {
        if (!this.obs_.contains(docWalkerObserver)) {
            this.obs_.add(docWalkerObserver);
        }
    }

    public int getPageCount() {
        return this.pagecnt_;
    }

    public void setPage(int n) {
    }

    public void extractAll() throws Exception {
        this.emit(1, this.doc_);
        if (this.pagecnt_ == -1) {
            this.extract();
        } else {
            int n = this.getPageCount();
            for (int i = 1; i <= n; ++i) {
                this.emit(3, Integers.getInteger(i));
                this.extract(i);
                this.emit(4, Integers.getInteger(i));
            }
        }
        this.emit(2, this.doc_);
    }

    public void extract() throws Exception {
        this.extract(-1);
    }

    public void extract(int n) throws Exception {
        Document document = this.doc_;
        if (n > 0) {
            document.clear();
            document.putAttr("page", Integer.toString(n));
            this.ma_.parse(document);
        }
        if ((0x400 & this.hints_) == 0) {
            document.formatBeforeAfter(850, 1100, new Context());
        }
        this.walk(document.childAt(0));
    }

    public Iterator iterator() throws Exception {
        List<DocWalkerObserver> list = this.obs_;
        TreeCollect treeCollect = new TreeCollect();
        this.obs_ = new ArrayList<DocWalkerObserver>(1);
        this.obs_.add(treeCollect);
        this.extract();
        this.obs_ = list;
        return treeCollect.list.iterator();
    }

    public void walk(Node node) {
        String string = node.getName();
        if (string != null && !(node instanceof INodeZero) && !(node instanceof LeafZero)) {
            if (node instanceof INode) {
                INode iNode = (INode)node;
                boolean bl = "line".equals(string);
                this.emit(bl ? 17 : 10, iNode);
                int n = iNode.size();
                for (int i = 0; i < n; ++i) {
                    this.walk(iNode.childAt(i));
                }
                this.emit(bl ? 18 : 11, iNode);
            } else {
                if (!$assertionsDisabled && !(node instanceof Leaf)) {
                    throw new AssertionError();
                }
                this.emit(15, node);
                this.emitSpans(node, 0);
                if (node instanceof LeafText) {
                    String string2 = node.getName();
                    int n = 0;
                    int n2 = string2.length();
                    int n3 = node.sizeSticky();
                    for (int i = 0; i < n3; ++i) {
                        Mark mark = node.getSticky(i);
                        int n4 = mark.offset;
                        if (n4 == n2) break;
                        if (n4 <= n) continue;
                        this.emit(21, string2.substring(n, n4));
                        this.emitSpans(node, n4);
                        n = n4;
                    }
                    this.emit(21, string2.substring(n, n2));
                } else if (!(node instanceof LeafImage)) {
                    this.emit(12, node);
                }
                this.emitSpans(node, node.size());
                this.emit(16, node);
            }
        }
    }

    private void emit(int n, Object object) {
        int n2 = this.obs_.size();
        for (int i = 0; i < n2; ++i) {
            this.obs_.get(i).feature(n, object);
        }
    }

    private void emitSpans(Node node, int n) {
        int n2 = node.sizeSticky();
        for (int i = 0; i < n2; ++i) {
            Object object;
            Mark mark = node.getSticky(i);
            if (mark.offset > n) break;
            if (mark.offset != n || !((object = mark.getOwner()) instanceof Span)) continue;
            this.emit(((Span)object).getStart() == mark ? 13 : 14, object);
        }
    }

    public void close() throws IOException {
        if (this.ma_ != null) {
            this.ma_.close();
            this.ma_ = null;
        }
    }

    static {
        $assertionsDisabled = !DocWalker.class.desiredAssertionStatus();
    }

    class TreeCollect
    implements DocWalkerObserver {
        List<Object> list = new ArrayList<Object>(1000);

        TreeCollect() {
        }

        public void feature(int n, Object object) {
            this.list.add(Integers.getInteger(n));
            this.list.add(object);
        }
    }
}

