/*
 * Decompiled with CFR 0.152.
 */
package tool;

import com.pt.awt.NFont;
import com.pt.awt.font.NFontManager;
import com.pt.awt.font.NFontRec;
import com.pt.io.FileList;
import com.pt.io.FileLog;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import multivalent.Multivalent;
import phelps.io.PrintStreams;

public class Info {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.1 of $Date: 2005/04/29 03:49:48 $";
    public static final String USAGE = "java tool.Info [options]\n\t[-verbose]";
    private boolean fverbose_;
    private boolean fquiet_;
    private PrintStream out_;

    public Info() {
        this.defaults();
    }

    public void defaults() {
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void info() {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        this.out_.println("System info " + new Date());
        this.out_.println();
        this.out_.println("Multivalent v" + Multivalent.VERSION);
        this.out_.println();
        this.out_.println("*** Filesystem Roots ***");
        Object object4 = File.listRoots();
        int n3 = ((File[])object4).length;
        for (int i = 0; i < n3; ++i) {
            object3 = object4[i];
            this.out_.println(object3);
        }
        this.out_.println();
        this.out_.println("*** Properties ***");
        object4 = System.getProperties();
        Object object5 = ((Properties)object4).keys();
        while (object5.hasMoreElements()) {
            Object object6 = object5.nextElement();
            this.out_.println(object6 + ": " + ((Properties)object4).get(object6));
        }
        this.out_.println();
        this.out_.println("*** Hardware ***");
        object5 = Runtime.getRuntime();
        this.out_.println(((Runtime)object5).availableProcessors() + " processors");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        object3 = Toolkit.getDefaultToolkit();
        this.out_.println("graphics environment");
        this.out_.println("\tisHeadless() = " + GraphicsEnvironment.isHeadless() + ", " + ((Toolkit)object3).getScreenResolution() + " ppi");
        this.out_.println("\tcenter = " + graphicsEnvironment.getCenterPoint() + ", window bounds = " + graphicsEnvironment.getMaximumWindowBounds());
        String[] stringArray = new String[]{"raster", "printer", "image"};
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        Object object7 = graphicsEnvironment.getScreenDevices();
        int n4 = ((GraphicsDevice[])object7).length;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            object2 = object7[n2];
            this.out_.println("*** device " + ((GraphicsDevice)object2).getIDstring() + ", type=" + stringArray[((GraphicsDevice)object2).getType()] + (graphicsDevice == object2 ? " [default]" : ""));
            this.out_.println("\tfull available? " + ((GraphicsDevice)object2).isFullScreenSupported() + ", display change? " + ((GraphicsDevice)object2).isDisplayChangeSupported());
            this.out_.println("\taccelerated " + ((GraphicsDevice)object2).getAvailableAcceleratedMemory() + " bytes");
            GraphicsConfiguration graphicsConfiguration = ((GraphicsDevice)object2).getDefaultConfiguration();
            Object object8 = ((GraphicsDevice)object2).getConfigurations();
            int n6 = ((GraphicsConfiguration[])object8).length;
            for (n5 = 0; n5 < n6; ++n5) {
                GraphicsConfiguration graphicsConfiguration2 = object8[n5];
                this.out_.println("graphics config" + (graphicsConfiguration == graphicsConfiguration2 ? " [default]" : ""));
                this.out_.println("\tcompatible = " + graphicsConfiguration2.createCompatibleImage(100, 100));
                this.out_.println("\tcolor model = " + graphicsConfiguration2.getColorModel());
                this.out_.println("\tnorm = " + graphicsConfiguration2.getNormalizingTransform() + ", default = " + graphicsConfiguration2.getDefaultTransform());
                this.out_.println("\tbounds = " + graphicsConfiguration2.getBounds());
                this.out_.println("\tbuf cap = " + graphicsConfiguration2.getBufferCapabilities() + ", img cap = " + graphicsConfiguration2.getImageCapabilities());
            }
            object8 = ((GraphicsDevice)object2).getDisplayMode();
            this.out_.println("display modes");
            object = ((GraphicsDevice)object2).getDisplayModes();
            n5 = ((DisplayMode[])object).length;
            for (int i = 0; i < n5; ++i) {
                DisplayMode displayMode = object[i];
                this.out_.println("\t" + displayMode.getWidth() + "x" + displayMode.getHeight() + " x " + displayMode.getBitDepth() + ", " + displayMode.getRefreshRate() + " Hz" + (((DisplayMode)object8).equals(displayMode) ? " [default]" : ""));
            }
        }
        this.out_.println();
        this.out_.println("*** ImageIO ***");
        object7 = ImageIO.getReaderMIMETypes();
        n4 = ((Object[])object7).length;
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = object7[n2];
            this.out_.println((String)object2);
        }
        object7 = ImageIO.getReaderFormatNames();
        n4 = ((Object[])object7).length;
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = object7[n2];
            this.out_.println((String)object2);
        }
        this.out_.println();
        this.out_.println("*** NFonts ***");
        object7 = new File(System.getProperty("java.io.tmpdir"));
        File file = new File((File)object7, "fonts.fl");
        if (!file.exists()) {
            file = new File((File)object7, "fonts.fl.gz");
        }
        FileLog fileLog = new FileLog(file, null, false, -1);
        object2 = new String[]{"time-full", "time-update", "time-spot-check"};
        int n7 = ((String[])object2).length;
        for (n = 0; n < n7; ++n) {
            object = object2[n];
            System.out.println((String)object + ": " + fileLog.getAttr((String)object));
        }
        object2 = NFontManager.getDefault().getDatabase().iterator();
        while (object2.hasNext()) {
            NFontRec nFontRec = (NFontRec)object2.next();
            this.out_.println(nFontRec.getName() + ", " + nFontRec.getFormat() + ", " + nFontRec.getSubformat() + ", " + nFontRec.getWeight() + ", " + NFont.strFlags(nFontRec.getFlags()) + ", " + nFontRec.getNumGlyphs() + "#, " + nFontRec.getStatus() + ", " + nFontRec.getMessage() + ".  " + nFontRec.getSourceShort() + "#" + nFontRec.getNum());
        }
        this.out_.println();
        this.out_.println("*** AWT Fonts ***");
        object2 = graphicsEnvironment.getAvailableFontFamilyNames();
        int n8 = ((Object)object2).length;
        for (n = 0; n < n8; ++n) {
            object = object2[n];
            this.out_.println((String)object);
        }
        Object object9 = object2 = new String[]{"Dialog", "DialogInput", "Serif", "SansSerif", "Monospaced"};
        n = ((Object)object9).length;
        for (int i = 0; i < n; ++i) {
            Object object10 = object9[i];
            Font font = new Font((String)object10, 0, 1);
            System.out.println("logical " + (String)object10 + " => logical = " + font.getName() + ", face = " + font.getFontName() + ", PS = " + font.getPSName() + ", family = " + font.getFamily());
        }
        this.out_.println();
        this.out_.println("*** Font Files ***");
        object9 = new FileList(File.listRoots(), NFontManager.getFilter()).iterator();
        while (object9.hasNext()) {
            this.out_.println(object9.next());
        }
        this.out_.println("*** Charsets ***");
        object9 = Charset.availableCharsets();
        Iterator iterator = object9.keySet().iterator();
        while (iterator.hasNext()) {
            this.out_.println((String)iterator.next());
        }
        this.out_.println();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.equals("-help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Info info = new Info();
        int n = info.commandLine(stringArray);
        try {
            info.info();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }
}

