/*
 * Decompiled with CFR 0.152.
 */
package phelps.imageio.plugins;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class XWindowImageReader
extends ImageReader {
    private static int[] HEX;
    private BufferedImage img_ = null;
    private static final IndexColorModel INDEX_BLACK_WHITE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XWindowImageReader(ImageReaderSpi imageReaderSpi, Object object) {
        super(imageReaderSpi);
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.check(n);
        return null;
    }

    public int getNumImages(boolean bl) throws IOException {
        this.check(0);
        return 1;
    }

    public int getHeight(int n) throws IOException {
        this.check(n);
        return this.img_.getHeight();
    }

    public int getWidth(int n) throws IOException {
        this.check(n);
        return this.img_.getWidth();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        this.check(0);
        return null;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.check(n);
        return null;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.check(n);
        return this.img_;
    }

    private void check(int n) throws IOException {
        if (n < 0 || n >= 1) {
            throw new IndexOutOfBoundsException("only one image in XBM, at index 0");
        }
        if (this.input == null) {
            throw new IllegalStateException("input not set");
        }
        if (this.img_ == null) {
            this.img_ = XWindowImageReader.read((ImageInputStream)this.input);
        }
    }

    private static BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        String string;
        int n = 0;
        int n2 = 0;
        while ((string = imageInputStream.readLine()) != null) {
            int n3;
            if (string.length() == 0) continue;
            if (string.startsWith("#define")) {
                try {
                    n3 = string.indexOf("_width");
                    if (n3 > 0) {
                        n = Integer.parseInt(string.substring(n3 + "_width".length() + 1).trim());
                        continue;
                    }
                    n3 = string.indexOf("_height");
                    if (n3 <= 0) continue;
                    n2 = Integer.parseInt(string.substring(n3 + "_height".length() + 1).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("parse error on \"" + string + "\"");
                }
                continue;
            }
            n3 = string.indexOf("_bits");
            if (n3 < 0) continue;
            if (!$assertionsDisabled && string.indexOf("0x") != -1) {
                throw new AssertionError((Object)string);
            }
            if (!($assertionsDisabled || n > 0 && n2 > 0)) {
                throw new AssertionError();
            }
            byte[] byArray = new byte[n * n2];
            int n4 = 0;
            int n5 = byArray.length;
            while (n4 < n5) {
                int n6 = imageInputStream.read();
                if (Character.isWhitespace((char)n6) || n6 == 44) continue;
                if (!$assertionsDisabled && n6 != 48) {
                    throw new AssertionError(n6);
                }
                n6 = imageInputStream.read();
                if (!$assertionsDisabled && n6 != 120 && n6 != 88) {
                    throw new AssertionError();
                }
                int n7 = HEX[imageInputStream.read()] << 4 | HEX[imageInputStream.read()];
                for (int i = 0; i < 8; ++i) {
                    byArray[n4++] = (byte)(n7 >> i & 1);
                }
            }
            WritableRaster writableRaster = WritableRaster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n, 1, new int[]{0}, null);
            return new BufferedImage(INDEX_BLACK_WHITE, writableRaster, false, new Hashtable());
        }
        return null;
    }

    static {
        $assertionsDisabled = !XWindowImageReader.class.desiredAssertionStatus();
        HEX = new int[128];
        Arrays.fill(HEX, -1);
        int n = 0;
        int n2 = 48;
        while (n < 10) {
            XWindowImageReader.HEX[n2] = n++;
            ++n2;
        }
        n = 10;
        n2 = 97;
        int n3 = 65;
        while (n < 16) {
            XWindowImageReader.HEX[n2] = XWindowImageReader.HEX[n3] = n++;
            ++n2;
            ++n3;
        }
        INDEX_BLACK_WHITE = new IndexColorModel(1, 2, new int[]{0, Color.BLACK.getRGB()}, 0, true, 0, 0);
    }
}

