/*
 * Decompiled with CFR 0.152.
 */
package phelps.awt.color;

import java.awt.color.ColorSpace;
import phelps.lang.Maths;

public class ColorSpaceLab
extends ColorSpace {
    static final ColorSpace CIEXYZ;
    float wx_;
    float wy_;
    float wz_;
    float bx_ = 0.0f;
    float by_ = 0.0f;
    float bz_ = 0.0f;
    float amin_ = -100.0f;
    float amax_ = 100.0f;
    float bmin_ = -100.0f;
    float bmax_ = 100.0f;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColorSpaceLab(float f, float f2, float f3) {
        super(1, 3);
        if (!($assertionsDisabled || f > 0.0f && f3 > 0.0f && f2 == 1.0f)) {
            throw new AssertionError();
        }
        this.wx_ = f;
        this.wy_ = f2;
        this.wz_ = f3;
    }

    public void setBlackPoint(float f, float f2, float f3) {
        if (!($assertionsDisabled || f >= 0.0f && f2 >= 0.0f && f3 >= 0.0f)) {
            throw new AssertionError();
        }
        this.bx_ = f;
        this.by_ = f2;
        this.bz_ = f3;
    }

    public void setRange(float f, float f2, float f3, float f4) {
        if (!($assertionsDisabled || f <= f2 && f3 <= f4)) {
            throw new AssertionError();
        }
        this.amin_ = f;
        this.amax_ = f2;
        this.bmin_ = f3;
        this.bmax_ = f4;
    }

    public float getMinValue(int n) {
        return n == 0 ? 0.0f : (n == 1 ? this.amin_ : this.bmin_);
    }

    public float getMaxValue(int n) {
        return n == 0 ? 100.0f : (n == 1 ? this.amax_ : this.bmax_);
    }

    public float[] fromCIEXYZ(float[] fArray) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private final float g(float f) {
        return f >= 0.20689656f ? f * f * f : 0.12841855f * (f - 0.13793103f);
    }

    public float[] toCIEXYZ(float[] fArray) {
        float f = fArray[0];
        float f2 = Maths.minmax(this.amin_, fArray[1], this.amax_);
        float f3 = Maths.minmax(this.bmin_, fArray[2], this.bmax_);
        float f4 = (f + 16.0f) / 116.0f;
        float f5 = f4 + f2 / 500.0f;
        float f6 = f4;
        float f7 = f4 - f3 / 200.0f;
        float[] fArray2 = new float[]{this.wx_ * this.g(f5), this.wy_ * this.g(f6), this.wz_ * this.g(f7)};
        return fArray2;
    }

    public float[] fromRGB(float[] fArray) {
        return this.fromCIEXYZ(CIEXYZ.fromRGB(fArray));
    }

    public float[] toRGB(float[] fArray) {
        return CIEXYZ.toRGB(this.toCIEXYZ(fArray));
    }

    static {
        $assertionsDisabled = !ColorSpaceLab.class.desiredAssertionStatus();
        CIEXYZ = ColorSpaceLab.getInstance(1001);
    }
}

