/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import javax.swing.JFileChooser;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.SemanticEvent;

public class SaveAnnoAs
extends Behavior {
    public static final String MSG_SAVE_AS = "saveAnnosAs";
    static JFileChooser jc_ = null;

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/File" == string) {
            Browser browser = this.getBrowser();
            Document document = browser.getCurDocument();
            Layer layer = document.getLayer("personal");
            INode iNode = (INode)semanticEvent.getOut();
            boolean bl = layer.size() == 0 && layer.auxSize() == 0;
            this.createUI("button", "Save Annos As...", "event saveAnnosAs", iNode, "save", bl);
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_SAVE_AS == string) {
            Browser browser = this.getBrowser();
            Document document = browser.getCurDocument();
            if (jc_ == null) {
                jc_ = new JFileChooser();
            }
            jc_.setDialogType(1);
            jc_.setDialogTitle("Save Personal Annotations to File");
            File file = jc_.getCurrentDirectory();
            URI uRI = document.getURI();
            Object object = this.getRoot();
            while (uRI == null && document.getParentNode() != object) {
                document = document.getParentNode().getDocument();
                uRI = document.getURI();
            }
            object = this.computeFilename(uRI);
            File file2 = new File(file, (String)object);
            jc_.setSelectedFile(file2);
            if (jc_.showSaveDialog(browser) == 0) {
                Layer layer = document.getLayer("personal");
                ESISNode eSISNode = layer.save();
                eSISNode.setGI("saved");
                if (eSISNode.getAttr("uri") == null) {
                    eSISNode.putAttr("uri", document.getURI().toString());
                }
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(jc_.getSelectedFile()));
                    bufferedWriter.write(eSISNode.writeXML());
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    System.err.println("couldn't save annos: " + iOException);
                }
            }
            return true;
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    String computeFilename(URI uRI) {
        String string = uRI.getPath();
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if (string.length() == 0) {
            string = "index.html";
            String string2 = uRI.getAuthority();
            if (string2 != null) {
                string = string2;
                n = string.lastIndexOf(46);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if ((n = string.lastIndexOf(46)) != -1) {
                    string = string.substring(n + 1);
                }
            }
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        string = string + ".mvd";
        return string;
    }
}

