/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.awt.Point;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Forms;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;

public class Action
extends Behavior {
    static final boolean DEBUG = false;
    public static final String MSG_EXECUTE = "pdfAction";
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if (string == MSG_EXECUTE && object != null && object.getClass() == COS.CLASS_DICTIONARY && semanticEvent.getIn() instanceof PDF && semanticEvent.getOut() instanceof Node) {
            this.executeAction((Dict)object, (PDF)semanticEvent.getIn(), (Node)semanticEvent.getOut());
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    void executeAction(Dict dict, PDF pDF, Node node) {
        Object object;
        PDFReader pDFReader = pDF.getReader();
        try {
            object = (String)pDFReader.getObject(dict.get("S"));
            if ("GoTo".equals(object)) {
                this.gotol(dict, pDF, node);
            } else if (object == null && dict.get("D") != null) {
                this.gotol(dict, pDF, node);
            } else if ("GoToR".equals(object)) {
                this.gotor(dict, pDF, node);
            } else if ("Launch".equals(object)) {
                this.launch(dict, pDF, node);
            } else if ("Thread".equals(object)) {
                this.thread(dict, pDF, node);
            } else if ("URI".equals(object)) {
                this.uri(dict, pDF, node);
            } else if ("Sound".equals(object)) {
                this.sound(dict, pDF, node);
            } else if ("Movie".equals(object)) {
                this.movie(dict, pDF, node);
            } else if ("Hide".equals(object)) {
                this.hide(dict, pDF, node);
            } else if ("Named".equals(object)) {
                this.named(dict, pDF, node);
            } else if ("SubmitForm".equals(object)) {
                this.submitform(dict, pDF, node);
            } else if ("ResetForm".equals(object)) {
                this.resetform(dict, pDF);
            } else if ("ImportData".equals(object)) {
                this.importdata(dict, pDF);
            } else if ("JavaScript".equals(object)) {
                this.javascript(dict, pDF, node);
            } else if ("SetOCGState".equals(object)) {
                this.setOCGState(dict, pDF, node);
            } else if ("Rendition".equals(object)) {
                this.rendition(dict, pDF, node);
            } else if (!"NOP".equals(object) && !"SetState".equals(object)) {
                System.err.println("unknown action: " + (String)object + " -- ignored");
            }
        }
        catch (IOException iOException) {
            System.out.println(dict.get("S") + " failed: " + iOException);
        }
        object = dict.get("Next");
        if (object != null) {
            try {
                if (COS.CLASS_DICTIONARY == object.getClass()) {
                    this.executeAction((Dict)object, pDF, node);
                } else if (COS.CLASS_ARRAY == object.getClass()) {
                    Object[] objectArray = (Object[])object;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object object2 = objectArray[i];
                        Object object3 = pDFReader.getObject(object2);
                        if (COS.CLASS_DICTIONARY != object3.getClass()) continue;
                        this.executeAction((Dict)object3, pDF, node);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void gotol(Dict dict, PDF pDF, Node node) throws IOException {
        Object[] objectArray;
        Object object;
        PDFReader pDFReader = pDF.getReader();
        Object object2 = pDFReader.getObject(dict.get("D"));
        Object object3 = Action.resolveNamedDest(object2, pDFReader);
        if (object3 != null && object3.getClass() == COS.CLASS_DICTIONARY) {
            object3 = pDFReader.getObject(((Dict)object3).get("D"));
        }
        if (object3 != null && object3.getClass() == COS.CLASS_ARRAY && (object = pDFReader.getObject((objectArray = (Object[])object3)[0])).getClass() == COS.CLASS_DICTIONARY) {
            Browser browser = this.getBrowser();
            browser.eventq("goPageNum", String.valueOf(pDFReader.getPageNum((Dict)object)));
        }
    }

    public static Object resolveNamedDest(Object object, PDFReader pDFReader) throws IOException {
        Object object2;
        if (object == null || object.getClass() == COS.CLASS_ARRAY || object.getClass() == COS.CLASS_DICTIONARY) {
            object2 = object;
        } else if (object.getClass() == COS.CLASS_NAME) {
            Dict dict = (Dict)pDFReader.getObject(pDFReader.getCatalog().get("Dests"));
            object2 = dict != null ? pDFReader.getObject(dict.get(object)) : null;
        } else {
            if (!$assertionsDisabled && object.getClass() != COS.CLASS_STRING) {
                throw new AssertionError();
            }
            Dict dict = (Dict)pDFReader.getObject(pDFReader.getCatalog().get("Names"));
            Dict dict2 = (Dict)(dict != null ? pDFReader.getObject(dict.get("Dests")) : null);
            object2 = pDFReader.getObject(pDFReader.findNameTree(dict2, (StringBuffer)object));
        }
        return object2;
    }

    void gotor(Dict dict, PDF pDF, Node node) throws IOException {
        PDFReader pDFReader = pDF.getReader();
        Object object = pDFReader.getObject(dict.get("D"));
        if (object instanceof Object[]) {
            object = "page=" + ((Object[])object)[0];
        }
        Object object2 = pDFReader.getObject(dict.get("F"));
        Object object3 = pDFReader.getObject(dict.get("NewWindow"));
        this.getBrowser().eventq("openDocument", object2);
    }

    void launch(Dict dict, PDF pDF, Node node) throws IOException {
    }

    void thread(Dict dict, PDF pDF, Node node) throws IOException {
    }

    void uri(Dict dict, PDF pDF, Node node) throws IOException {
        StringBuffer stringBuffer;
        Cloneable cloneable;
        PDFReader pDFReader = pDF.getReader();
        Browser browser = this.getBrowser();
        String string = pDFReader.getObject(dict.get("URI")).toString();
        Boolean bl = (Boolean)pDFReader.getObject(dict.get("IsMap"));
        if (bl != null && bl.booleanValue()) {
            cloneable = browser.getCurScrn();
            string = string + "?" + ((Point)cloneable).x + "," + ((Point)cloneable).y;
        }
        if ((stringBuffer = (StringBuffer)((cloneable = (Dict)pDFReader.getObject(pDFReader.getCatalog().get("URI"))) != null ? pDFReader.getObject(((Dict)cloneable).get("Base")) : null)) != null) {
            try {
                string = new URI(stringBuffer.toString()).resolve(string).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        browser.eventq("openDocument", string);
    }

    void sound(Dict dict, PDF pDF, Node node) throws IOException {
    }

    void movie(Dict dict, PDF pDF, Node node) throws IOException {
    }

    void named(Dict dict, PDF pDF, Node node) throws IOException {
        String string = null;
        PDFReader pDFReader = pDF.getReader();
        Object object = pDFReader.getObject(dict.get("N"));
        if ("NextPage".equals(object)) {
            string = "nextPage";
        } else if ("PrevPage".equals(object)) {
            string = "previousPage";
        } else if ("FirstPage".equals(object)) {
            string = "firstDocumentPage";
        } else if ("LastPage".equals(object)) {
            string = "lastDocumentPage";
        }
        if (string != null) {
            this.getBrowser().eventq(string, null);
        }
    }

    void hide(Dict dict, PDF pDF, Node node) throws IOException {
    }

    void submitform(Dict dict, PDF pDF, Node node) throws IOException {
    }

    void resetform(Dict dict, PDF pDF) throws IOException {
        Map<String, Object> map = pDF.getForm();
        Map<String, Object> map2 = Forms.exportDefaults(pDF.getReader());
    }

    void importdata(Dict dict, PDF pDF) throws IOException {
        Map<String, Object> map = pDF.getForm();
        Map<String, Object> map2 = Forms.exportDefaults(pDF.getReader());
    }

    void javascript(Dict dict, PDF pDF, Node node) throws IOException {
    }

    void setOCGState(Dict dict, PDF pDF, Node node) throws IOException {
    }

    void rendition(Dict dict, PDF pDF, Node node) throws IOException {
    }

    static {
        $assertionsDisabled = !Action.class.desiredAssertionStatus();
    }
}

