/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import com.pt.io.InputStreamTee;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import multivalent.Browser;
import multivalent.INode;
import multivalent.MediaAdaptor;
import multivalent.SemanticEvent;
import multivalent.gui.VRadiobox;
import multivalent.gui.VRadiogroup;

public class HexDump
extends MediaAdaptor {
    public static final String PREF_DISPLAY = "HexDump/DisplayAs";
    public static final String VALUE_HEX = "Hex";
    public static final String VALUE_STRINGS = "Strings";
    public static final String VALUE_MIXED = "Hex/Ascii";
    static final String[] HEX2FF = new String[256];

    public Object parse(INode iNode) throws Exception {
        return HexDump.parseHelper(this.toHTML(), "HTML", this.getLayer(), iNode);
    }

    public String toHTML() {
        URI uRI = this.getURI();
        String string = this.getPreference(PREF_DISPLAY, VALUE_MIXED);
        if (!(VALUE_STRINGS.equals(string) || VALUE_HEX.equals(string) || VALUE_MIXED.equals(string))) {
            string = VALUE_MIXED;
        }
        StringBuffer stringBuffer = new StringBuffer(20000);
        stringBuffer.append("<html>\n<head>");
        int n = stringBuffer.length();
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        try {
            if (VALUE_STRINGS.equals(string)) {
                int n2 = stringBuffer.length();
                int n3 = this.showStrings(stringBuffer);
                if (n3 == 0) {
                    stringBuffer.insert(n2, "No strings found.");
                } else if (n3 > 10) {
                    stringBuffer.insert(n2, n3 + " strings found.");
                }
            } else {
                stringBuffer.insert(n, "<style>body { font-family: monospace; font-size: 10pts; }</style>");
                this.showMixed(stringBuffer, VALUE_MIXED.equals(string));
            }
        }
        catch (IOException iOException) {
            stringBuffer.append("Trouble reading ").append(uRI).append(": ").append(iOException);
        }
        stringBuffer.append("</body></html>\n");
        return stringBuffer.toString();
    }

    int showStrings(StringBuffer stringBuffer) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 5;
        int n4 = 0;
        int[] nArray = new int[n3];
        InputStreamTee inputStreamTee = this.getInputUni().getInputStream();
        int n5 = 0;
        while ((n = ((InputStream)inputStreamTee).read()) != -1) {
            if (n == 32 || n >= 65 && n <= 90 || n >= 97 && n <= 122) {
                nArray[n2++] = n;
            } else {
                n5 += n2 + 1;
                n2 = 0;
            }
            if (n2 < n3) continue;
            ++n4;
            stringBuffer.append("<p><tt>").append(Integer.toHexString(n5)).append("</tt> ");
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append((char)nArray[i]);
            }
            n5 += n2 + 1;
            n2 = 0;
            while ((n = ((InputStream)inputStreamTee).read()) != -1 && n >= 32 && n <= 126) {
                if (n == 60) {
                    stringBuffer.append("&lt;");
                } else if (n == 38) {
                    stringBuffer.append("&amp;");
                } else {
                    stringBuffer.append((char)n);
                }
                ++n5;
            }
        }
        return n4;
    }

    void showMixed(StringBuffer stringBuffer, boolean bl) throws IOException {
        int n = bl ? 16 : 32;
        int[] nArray = new int[n];
        stringBuffer.append("<table width='95%'><tr><td>0<td>");
        int n2 = stringBuffer.length();
        boolean bl2 = false;
        boolean bl3 = false;
        InputStreamTee inputStreamTee = this.getInputUni().getInputStream();
        int n3 = ((InputStream)inputStreamTee).read();
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (n3 == -1 || n5 == n) {
                if (bl2) {
                    stringBuffer.setLength(n2);
                    if (!bl3) {
                        stringBuffer.append("<tr><td>*</tr>\n");
                        bl3 = true;
                    }
                } else if (n4 > 0) {
                    bl3 = false;
                    if (bl) {
                        stringBuffer.append("<td>");
                        for (int i = 0; i < n5; ++i) {
                            char c = (char)nArray[i];
                            if (c <= '\u001a') {
                                stringBuffer.append("&oslash;");
                                continue;
                            }
                            if (c == '<') {
                                stringBuffer.append("&lt;");
                                continue;
                            }
                            if (c == '&') {
                                stringBuffer.append("&amp;");
                                continue;
                            }
                            stringBuffer.append(c);
                        }
                    }
                    stringBuffer.append("</tr>\n");
                }
                if (n3 == -1) {
                    if (n5 == 0) {
                        stringBuffer.setLength(n2);
                    }
                    break;
                }
                stringBuffer.append("\n<tr><td>").append(n4 % (n * 4) == 0 ? Integer.toHexString(n4) : "").append("<td>");
                n2 = stringBuffer.length();
                n5 = 0;
            }
            nArray[n5] = n3;
            boolean bl4 = bl2 = bl2 && n3 == 0;
            if (n3 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(HEX2FF[n3]).append(' ');
            ++n4;
            ++n5;
            n3 = ((InputStream)inputStreamTee).read();
            bl2 = false;
        }
        stringBuffer.append("</table>\n");
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventAfter(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            String string2 = this.getPreference(PREF_DISPLAY, VALUE_MIXED);
            String[] stringArray = new String[]{"Mixed Hex/ASCII", "ASCII strings only", "Hex dump only"};
            String[] stringArray2 = new String[]{VALUE_MIXED, VALUE_STRINGS, VALUE_HEX};
            VRadiogroup vRadiogroup = new VRadiogroup();
            Browser browser = this.getBrowser();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                VRadiobox vRadiobox = (VRadiobox)this.createUI("radiobox", stringArray[i], new SemanticEvent(browser, PREF_DISPLAY, stringArray2[i]), (INode)semanticEvent.getOut(), "medium", false);
                vRadiobox.setRadiogroup(vRadiogroup);
                if (!string2.equals(stringArray2[i])) continue;
                vRadiogroup.setActive(vRadiobox);
            }
        } else if (PREF_DISPLAY == string) {
            String string3;
            String string4 = this.getPreference(PREF_DISPLAY, VALUE_MIXED);
            Object object = semanticEvent.getArg();
            if (object instanceof String && (string3 = ((String)object).intern()) != string4 && (string3 == VALUE_HEX || string3 == VALUE_STRINGS || string3 == VALUE_MIXED)) {
                this.putPreference(PREF_DISPLAY, string3);
                this.getBrowser().eventq("reloadDocument", null);
            }
        }
        return false;
    }

    static {
        int n = HEX2FF.length;
        for (int i = 0; i < n; ++i) {
            HexDump.HEX2FF[i] = Integer.toHexString(i);
        }
    }
}

