/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import multivalent.Behavior;
import multivalent.Document;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.gui.VCheckbox;
import multivalent.std.span.HyperlinkSpan;
import phelps.lang.Booleans;

public class LinkMarkup
extends Behavior {
    public static final String MSG_LINKSCAN = "linkScan";
    public static final String MSG_SET_ACTIVE = "linkScanSetActive";
    public static final String PREF_AUTO = "LinkMarkup/Scan";
    public static final Pattern PATTERN = Pattern.compile("(http:|ftp:|file|www\\.|ftp\\.|://)[a-z0-9/~_:#?&\\.-]*[a-z0-9/]", 2);
    static final String URLVALID = "/~-._:#?&";
    List<HyperlinkSpan> links = new ArrayList<HyperlinkSpan>(20);

    public boolean isActive() {
        return Booleans.parseBoolean(this.getPreference(PREF_AUTO, "true"), true);
    }

    public void scan() {
        this.links.clear();
        Document document = this.getDocument();
        Layer layer = document.getLayer("<scratch>");
        if (document.getFirstLeaf() != null) {
            Leaf leaf = document.getLastLeaf().getNextLeaf();
            for (Leaf leaf2 = document.getFirstLeaf(); leaf2 != leaf && leaf2 != null; leaf2 = leaf2.getNextLeaf()) {
                char c;
                int n;
                String string = leaf2.getName();
                if (string == null) continue;
                int n2 = n = string.length();
                if (n < 5) continue;
                String string2 = null;
                int n3 = 0;
                if (n2 >= 5) {
                    int n4 = string.indexOf("://");
                    if (n4 > 0 && n2 >= n4 + 5 && string.indexOf(46, n4 + 3) != -1) {
                        n3 = n4 - 1;
                        n = n4 + 3;
                        string2 = "";
                    } else {
                        n4 = string.indexOf("file:/");
                        if (n4 >= 0 && n2 >= n4 + 7) {
                            n3 = n4;
                            n = n4 + 6;
                            string2 = "";
                        } else {
                            n4 = string.indexOf("www.");
                            if (n4 >= 0 && n2 >= n4 + 9) {
                                n3 = n4;
                                n = n4 + 4;
                                string2 = "http://";
                            } else {
                                n4 = string.indexOf("ftp.");
                                if (n4 >= 0 && n2 >= n4 + 9) {
                                    n3 = n4;
                                    n = n4 + 4;
                                    string2 = "ftp://";
                                } else {
                                    n4 = string.indexOf("@");
                                    if (n4 > 0 && n2 >= n4 + 7 && string.indexOf(46, n4 + 1) != -1) {
                                        n3 = n4 - 1;
                                        n = n4 + 1;
                                        string2 = "mailto:";
                                    }
                                }
                            }
                        }
                    }
                }
                if (string2 == null) continue;
                while (n3 > 0 && (Character.isLetterOrDigit(c = string.charAt(n3 - 1)) || URLVALID.indexOf(c) != -1)) {
                    --n3;
                }
                while (n < n2 && (Character.isLetterOrDigit(c = string.charAt(n)) || URLVALID.indexOf(c) != -1)) {
                    ++n;
                }
                string2 = string2 + string.substring(n3, n);
                boolean bl = false;
                int n5 = leaf2.sizeSticky();
                for (int i = 0; i < n5; ++i) {
                    Mark mark = leaf2.getSticky(i);
                    if (!(mark.getOwner() instanceof HyperlinkSpan)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                HyperlinkSpan hyperlinkSpan = (HyperlinkSpan)Behavior.getInstance("computed", "HyperlinkSpan", null, layer);
                hyperlinkSpan.setTarget(string2);
                hyperlinkSpan.moveq(leaf2, n3, leaf2, n);
                this.links.add(hyperlinkSpan);
            }
        }
        if (this.links.size() > 0) {
            document.repaint(100L);
        }
    }

    public void setActive(boolean bl) {
        if (bl != this.isActive()) {
            this.putPreference(PREF_AUTO, bl ? "true" : "false");
        }
        if (bl) {
            this.scan();
        } else {
            int n = this.links.size();
            for (int i = 0; i < n; ++i) {
                ((Span)this.links.get(i)).destroy();
            }
            this.links.clear();
        }
    }

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Auto Scan for Links", "event linkScanSetActive", (INode)semanticEvent.getOut(), "AuxSelect", false);
            vCheckbox.setState(this.isActive());
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_LINKSCAN == string && this.isActive()) {
            this.scan();
        } else if (MSG_SET_ACTIVE == string) {
            this.setActive(Booleans.parseBoolean(semanticEvent.getArg(), !this.isActive()));
        } else if ("closeDocument" == string && this.getDocument() == semanticEvent.getArg()) {
            this.links.clear();
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public void buildAfter(Document document) {
        super.buildAfter(document);
        this.getBrowser().eventq(MSG_LINKSCAN, document);
    }
}

