/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import multivalent.Behavior;
import multivalent.Document;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.gui.VCheckbox;
import multivalent.node.LeafText;
import multivalent.std.adaptor.XML;
import phelps.lang.Booleans;

public class ClipMarkup
extends Behavior {
    public static final String MSG_SET = "setMarkup";
    boolean active_ = false;

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/Edit" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Paste as Markup", "event setMarkup", iNode, "AuxSelect", false);
            vCheckbox.setState(this.active_);
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_SET == string) {
            this.active_ = Booleans.parseBoolean(semanticEvent.getArg(), !this.active_);
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public void buildAfter(Document document) {
        super.buildAfter(document);
        document.addObserver(this);
    }

    void selectSubtree(StringBuffer stringBuffer, Node node, Span span) {
        if (node.isStruct()) {
            stringBuffer.append("<" + node.getName() + ">");
            INode iNode = (INode)node;
            int n = iNode.size();
            for (int i = 0; i < n; ++i) {
                this.selectSubtree(stringBuffer, iNode.childAt(i), span);
            }
            stringBuffer.append("</" + node.getName() + ">\n");
        } else if (node instanceof LeafText && ((Leaf)node).sizeSticky() > 0) {
            LeafText leafText = (LeafText)node;
            String string = leafText.getName();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            int n = 0;
            int n2 = leafText.sizeSticky();
            for (int i = 0; i < n2; ++i) {
                Span span2;
                Mark mark = leafText.getSticky(i);
                int n3 = mark.offset;
                if (n < n3) {
                    stringBuffer.append(string.substring(n, n3));
                }
                if (mark.getOwner() instanceof Span && (span2 = (Span)mark.getOwner()) != span) {
                    if (span2.getStart() == mark) {
                        XML.write(span2.getName(), span2.getAttributes(), stringBuffer, 0);
                        stringBuffer.append(">");
                    } else {
                        stringBuffer.append("</").append(span2.getName()).append(">");
                    }
                }
                n = n3;
            }
            if (n < string.length()) {
                stringBuffer.append(string.substring(n));
            }
        } else {
            node.clipboardBeforeAfter(stringBuffer);
            stringBuffer.append(' ');
        }
    }

    public boolean clipboardBefore(StringBuffer stringBuffer, Node node) {
        if (!this.active_) {
            return false;
        }
        Span span = this.getBrowser().getSelectionSpan();
        if (span.isSet()) {
            stringBuffer.setLength(0);
            Node[] nodeArray = Node.spanChunky(span.getStart(), span.getEnd());
            for (int i = 0; i < nodeArray.length; ++i) {
                this.selectSubtree(stringBuffer, nodeArray[i], span);
            }
            return true;
        }
        return false;
    }
}

