/*
 * Decompiled with CFR 0.152.
 */
package multivalent.net;

import com.pt.io.Cache;
import com.pt.io.InputUni;
import com.pt.net.HTTP;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import multivalent.Behavior;
import multivalent.DocInfo;
import multivalent.SemanticEvent;

public class Cookies
extends Behavior {
    public static final String FILENAME = "Cookies.txt";
    private static List<Cookie> Cookies_ = null;

    private void read() {
        if (Cookies_ != null) {
            return;
        }
        Cookies.getLogger().fine("reading cookies");
        Cookies_ = new ArrayList<Cookie>(100);
        try {
            InputUni inputUni = this.getGlobal().getCache().getInputUni(null, FILENAME, "personal");
            if (inputUni != null) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(inputUni.getReader());
                while ((string = bufferedReader.readLine()) != null) {
                    Cookies_.add(new Cookie(null, string));
                }
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write() {
        this.read();
        Cache cache = this.getGlobal().getCache();
        Cookies.getLogger().fine("writing cookies");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(cache.getOutputStream(null, FILENAME, "personal")));
            long l = System.currentTimeMillis();
            int n = Cookies_.size();
            for (int i = 0; i < n; ++i) {
                Cookie cookie = Cookies_.get(i);
                if (cookie.expires <= l) continue;
                bufferedWriter.write(cookie.in);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void put(String string, String string2) {
        if (string2 == null || string2.indexOf(61) == -1) {
            return;
        }
        this.read();
        Cookie cookie = new Cookie(string, string2);
        String string3 = cookie.domain;
        String string4 = cookie.path;
        if (cookie.namevals == null || cookie.expires < System.currentTimeMillis() || string.endsWith(".doubleclick.net")) {
            return;
        }
        boolean bl = false;
        int n = 0;
        int n2 = Cookies_.size();
        for (int i = 0; i < n2; ++i) {
            Cookie cookie2 = Cookies_.get(i);
            if (!string3.equals(cookie2.domain) || !string4.equals(cookie2.path)) continue;
            Cookies_.set(n, cookie2);
            bl = true;
            break;
        }
        if (!bl) {
            Cookies_.add(cookie);
        }
    }

    private String getAll(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        this.read();
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = Cookies_.size();
        for (int i = 0; i < n; ++i) {
            Cookie cookie = Cookies_.get(i);
            if (!string.endsWith(cookie.domain) || !string2.startsWith(cookie.path) || cookie.expires != -1L && cookie.expires <= l || cookie.secure) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(cookie.namevals);
        }
        return stringBuffer.length() > 0 ? stringBuffer.substring(0) : null;
    }

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        Object object = semanticEvent.getArg();
        if ("openDocument" == string && object instanceof DocInfo) {
            DocInfo docInfo = (DocInfo)object;
            String string2 = this.getAll(docInfo.uri.getScheme(), docInfo.uri.getPath());
            if (string2 != null) {
                docInfo.headers.put("Cookie", string2);
            }
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if ("openedDocument" == string && object instanceof DocInfo) {
            DocInfo docInfo = (DocInfo)object;
            String string2 = "set-cookie";
            String string3 = docInfo.uri.getAuthority();
            String string4 = docInfo.headers.remove(string2);
            if (string4 != null) {
                this.put(string3, string4);
            }
            if (string4 != null) {
                String string5;
                int n = 1;
                while ((string4 = docInfo.headers.remove(string5 = string2 + (48 + n))) != null) {
                    this.put(string3, string4);
                    ++n;
                }
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public void destroy() {
        this.write();
        super.destroy();
    }

    static class Cookie {
        long expires = -1L;
        String in = null;
        String domain = null;
        String path = "/";
        String namevals = null;
        boolean secure = false;

        Cookie(String string, String string2) {
            this.in = string2;
            if (string2 != null && string2.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer(string2.length());
                String[] stringArray = string2.split("\\s;\\s");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string3 = stringArray[i];
                    int n2 = string3.indexOf(61);
                    if (n2 <= 0 || n2 + 1 == string3.length()) continue;
                    String string4 = string3.substring(0, n2).toLowerCase().trim();
                    String string5 = string3.substring(n2 + 1).trim();
                    if ("expires".equals(string4)) {
                        try {
                            this.expires = HTTP.parseDate(string5);
                        }
                        catch (ParseException parseException) {}
                        continue;
                    }
                    if ("max-age".equals(string4)) {
                        this.expires = System.currentTimeMillis();
                        try {
                            this.expires += (long)(1000 * Integer.parseInt(string5));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("domain".equals(string4)) {
                        this.domain = string5;
                        continue;
                    }
                    if ("path".equals(string4)) {
                        this.path = string5;
                        continue;
                    }
                    if ("secure".equals(string4)) {
                        this.secure = true;
                        continue;
                    }
                    if ("comment".equals(string4) || "version".equals(string4)) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("; ");
                    }
                    stringBuffer.append(string3);
                }
                if (stringBuffer.length() > 0) {
                    this.namevals = stringBuffer.substring(0);
                }
                if (this.domain == null) {
                    this.domain = string;
                    this.in = this.in + "; domain=" + this.domain;
                }
            }
        }

        public String toString() {
            return this.namevals + " in " + this.domain + this.path;
        }
    }
}

