/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.RandomAccess;
import com.pt.io.RandomAccessByteArray;
import com.pt.io.RandomAccessFileBuffered;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RandomAccessMultiplex {
    private final int max_;
    private final int bufsiz_;
    private final List<Rec> inuse_;
    private final List<Rec> avail_;
    private final Map<URL, SoftReference<RandomAccess>> expensive_ = new HashMap<URL, SoftReference<RandomAccess>>(13);
    private int s_fast = 0;
    private int s_force = 0;
    private int s_ex = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RandomAccessMultiplex(int n) {
        this(n, 8192L);
    }

    public RandomAccessMultiplex(int n, long l) {
        this.max_ = Math.max(1, n);
        this.bufsiz_ = Math.max(1, (int)l);
        this.inuse_ = new ArrayList<Rec>(this.max_);
        this.avail_ = new ArrayList<Rec>(this.max_);
    }

    public synchronized RandomAccess getRA(Object object, URL uRL) throws IOException {
        SoftReference<RandomAccess> softReference;
        if (!$assertionsDisabled && uRL == null) {
            throw new AssertionError();
        }
        for (int i = this.avail_.size() - 1; i >= 0; --i) {
            Rec rec = this.avail_.get(i);
            if (rec.owner != object || !rec.source.equals(uRL)) continue;
            this.avail_.remove(i);
            this.inuse_.add(rec);
            ++this.s_fast;
            return rec.ra;
        }
        Object object2 = null;
        if (this.avail_.size() + this.inuse_.size() < this.max_) {
            object2 = new Rec();
        }
        if (object2 == null) {
            for (int i = this.avail_.size() - 1; i >= 0; --i) {
                softReference = this.avail_.get(i);
                if (!uRL.equals(((Rec)((Object)softReference)).source)) continue;
                this.avail_.remove(i);
                object2 = softReference;
                break;
            }
        }
        while (object2 == null) {
            if (this.avail_.size() > 0) {
                object2 = this.avail_.remove(0);
                if (!$assertionsDisabled && ((Rec)object2).ra == null) {
                    throw new AssertionError();
                }
                ((Rec)object2).ra.close();
                ((Rec)object2).ra = null;
                ++this.s_force;
                continue;
            }
            System.err.println("*** OUT OF SLOTS ***");
            System.exit(1);
        }
        if (((Rec)object2).ra == null) {
            RandomAccess randomAccess;
            softReference = this.expensive_.get(uRL);
            if (softReference != null && (randomAccess = (RandomAccess)softReference.get()) != null) {
                ++this.s_ex;
            } else if ("file".equals(uRL.getProtocol())) {
                File file = new File(uRL.toString().substring("file:".length()));
                randomAccess = new RandomAccessFileBuffered(file, "r", this.bufsiz_);
            } else {
                randomAccess = new RandomAccessByteArray(uRL.openStream(), "r");
                this.expensive_.put(uRL, new SoftReference<RandomAccess>(randomAccess));
            }
            ((Rec)object2).ra = randomAccess;
        }
        ((Rec)object2).owner = object;
        ((Rec)object2).source = uRL;
        this.inuse_.add((Rec)object2);
        return ((Rec)object2).ra;
    }

    public synchronized void releaseRA(RandomAccess randomAccess) {
        for (int i = this.inuse_.size() - 1; i >= 0; --i) {
            Rec rec = this.inuse_.get(i);
            if (rec.ra != randomAccess) continue;
            this.inuse_.remove(i);
            this.avail_.add(rec);
            break;
        }
    }

    public void close() {
        if (!$assertionsDisabled && this.inuse_.size() != 0) {
            throw new AssertionError((Object)(this.inuse_.size() + " file descriptors still in use"));
        }
        int n = this.avail_.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.avail_.get((int)i).ra.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        $assertionsDisabled = !RandomAccessMultiplex.class.desiredAssertionStatus();
    }

    static class Rec {
        RandomAccess ra = null;
        Object owner;
        URL source;

        Rec() {
        }

        public String toString() {
            return this.owner != null ? this.owner.toString() : "null";
        }
    }
}

