/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.FSFile;
import com.pt.io.InputUni;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import phelps.io.Files;

public abstract class FileSystem {
    private static final Class[] SIG_FILESYSTEM;
    private static final Map<String, String> fsmap_;
    private URI logical_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void registerFileSystem(String string, String string2) {
        if (!($assertionsDisabled || string != null && string2 != null)) {
            throw new AssertionError();
        }
        fsmap_.put(string.toLowerCase(), string2);
    }

    public static FileSystem getInstance(InputUni inputUni) throws Exception {
        String string = fsmap_.get(Files.getSuffix(inputUni.getURI().getPath()));
        Class<?> clazz = Class.forName(string);
        Object obj = clazz.getConstructor(SIG_FILESYSTEM).newInstance(inputUni);
        return (FileSystem)obj;
    }

    public static boolean isFileSystem(String string) {
        boolean bl = false;
        int n = string.length();
        Iterator<String> iterator = fsmap_.keySet().iterator();
        while (!bl && iterator.hasNext()) {
            String string2 = iterator.next();
            int n2 = string2.length();
            bl = n2 + 1 < n && string.charAt(n - n2 - 1) == '.' && string.regionMatches(true, n - n2, string2, 0, n2);
        }
        return bl;
    }

    public FileSystem(URI uRI) {
        this.logical_ = uRI;
    }

    public URI getURI() {
        return this.logical_;
    }

    public abstract Iterator iterator() throws IOException;

    public FSFile getFile(String string) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FSFile fSFile = (FSFile)iterator.next();
            if (!fSFile.getPath().equals(string)) continue;
            return fSFile;
        }
        return null;
    }

    public FSFile[] list() throws IOException {
        ArrayList<FSFile> arrayList = new ArrayList<FSFile>(200);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add((FSFile)iterator.next());
        }
        return arrayList.toArray(new FSFile[arrayList.size()]);
    }

    public void close() throws IOException {
    }

    static {
        $assertionsDisabled = !FileSystem.class.desiredAssertionStatus();
        SIG_FILESYSTEM = new Class[]{InputUni.class};
        fsmap_ = new HashMap<String, String>(13);
        FileSystem.registerFileSystem("zip", "com.pt.io.FileSystemZip");
        FileSystem.registerFileSystem("tar", "com.pt.io.FileSystemTar");
        FileSystem.registerFileSystem("rpm", "com.pt.io.FileSystemRPM");
    }
}

