/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.font.CMap;
import com.pt.awt.font.EncodingUnicode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import phelps.lang.Strings;

public class Encoding {
    public static final Encoding UNICODE;
    public static final Encoding ADOBE_STANDARD;
    public static final Encoding MAC_ROMAN;
    public static final Encoding MAC_EXPERT;
    public static final Encoding WIN_ANSI;
    public static final Encoding PDF_DOC;
    public static final Encoding ZAPF_DINGBATS;
    public static final Encoding SYMBOL;
    public static final Encoding IDENTITY;
    private String name_;
    private String[] map_;
    private CMap toUni_ = null;
    private boolean fullUni_;
    private Encoding base_ = IDENTITY;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    private static void readEncodings(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Encoding.class.getResourceAsStream("/com/adobe/Encoding" + string + ".txt")));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (!string2.startsWith("#")) {
                char c;
                int n;
                int n2 = 0;
                int n3 = string2.length();
                while (string2.charAt(n2) != ' ') {
                    ++n2;
                }
                String string3 = Strings.valueOf(string2.substring(0, n2));
                ++n2;
                if (stringArray != null) {
                    n = 0;
                    while ((c = string2.charAt(n2++)) != ' ') {
                        if (c == '-') continue;
                        n = n * 8 + c - 48;
                    }
                    stringArray[n] = string3;
                    n = 0;
                    while ((c = string2.charAt(n2++)) != ' ') {
                        if (c == '-') continue;
                        n = n * 8 + c - 48;
                    }
                    stringArray2[n] = string3;
                    n = 0;
                    while ((c = string2.charAt(n2++)) != ' ') {
                        if (c == '-') continue;
                        n = n * 8 + c - 48;
                    }
                    stringArray3[n] = string3;
                }
                n = 0;
                while (n2 < n3) {
                    if ((c = string2.charAt(n2++)) == '-') continue;
                    n = n * 8 + c - 48;
                }
                stringArray4[n] = string3;
            }
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        if (stringArray != null) {
            stringArray3[0] = ".notdef";
            stringArray2[0] = ".notdef";
            stringArray[0] = ".notdef";
        }
        stringArray4[0] = ".notdef";
    }

    public Encoding(String string, String[] stringArray) {
        if (!$assertionsDisabled && stringArray == null) {
            throw new AssertionError((Object)string);
        }
        this.name_ = string;
        this.map_ = stringArray;
        boolean bl = true;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            if (".notdef".equals(string2)) {
                stringArray[i] = ".notdef";
                continue;
            }
            if (!bl || UNICODE.getChar(string2) != '\u0000') continue;
            bl = false;
        }
        this.fullUni_ = bl;
    }

    public Encoding(Encoding encoding, Object[] objectArray) {
        if (encoding == null) {
            encoding = IDENTITY;
        }
        this.base_ = encoding;
        String[] stringArray = encoding.map_;
        boolean bl = encoding.fullUni_;
        if (objectArray != null) {
            stringArray = (String[])stringArray.clone();
            int n = objectArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (object instanceof Number) {
                    n2 = ((Number)object).intValue();
                    continue;
                }
                if (!$assertionsDisabled && (class$java$lang$String == null ? Encoding.class$("java.lang.String") : class$java$lang$String) != object.getClass()) {
                    throw new AssertionError();
                }
                if (".notdef".equals(object)) {
                    stringArray[n2] = ".notdef";
                } else {
                    String string;
                    stringArray[n2] = string = (String)object;
                    if (bl && UNICODE.getChar(string) == '\u0000') {
                        bl = false;
                    }
                }
                ++n2;
            }
        }
        this.name_ = encoding.name_ + "+diffs";
        this.map_ = stringArray;
        this.fullUni_ = bl;
    }

    public static Encoding getInstance(String string) {
        Encoding encoding = string == null || "Identity".equals(string) ? IDENTITY : ("StandardEncoding".equals(string) ? ADOBE_STANDARD : ("MacRomanEncoding".equals(string) ? MAC_ROMAN : ("MacExpertEncoding".equals(string) ? MAC_EXPERT : ("WinAnsiEncoding".equals(string) ? WIN_ANSI : ("PDFDocEncoding".equals(string) ? PDF_DOC : ("ZapfDingbatsEncoding".equals(string) ? ZAPF_DINGBATS : ("SymbolEncoding".equals(string) ? SYMBOL : ("Unicode".equals(string) ? UNICODE : null))))))));
        return encoding;
    }

    public String getName() {
        return this.name_;
    }

    public Encoding getBase() {
        return this.base_;
    }

    public String getName(int n) {
        String string = 0 <= n && n < this.map_.length ? this.map_[n] : null;
        return string != null ? string : ".notdef";
    }

    public char getChar(String string) {
        char c = '\u0000';
        int n = this.map_.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.map_[i])) continue;
            c = (char)i;
            break;
        }
        return c;
    }

    public CMap mapTo(Encoding encoding) {
        CMap cMap;
        if (encoding == this || IDENTITY == this || IDENTITY == encoding) {
            cMap = CMap.IDENTITY;
        } else {
            char[] cArray = new char[this.map_.length];
            int n = 57344;
            int n2 = this.map_.length;
            for (int i = 0; i < n2; ++i) {
                char c = (char)i;
                String string = this.map_[i];
                if (string == null) continue;
                if (string.equals(encoding.getName(c))) {
                    cArray[i] = c;
                    continue;
                }
                cArray[i] = encoding.getChar(string);
                if ('\u0000' != cArray[i] || UNICODE != encoding || n >= 63744) continue;
                while (cArray[i] != '\u0000') {
                    n = (char)(n + 1);
                }
                int n3 = n;
                n = (char)(n + 1);
                cArray[i] = n3;
            }
            cMap = new CMap(cArray);
        }
        return cMap;
    }

    public CMap guessToUnicode() {
        if (this.toUni_ == null) {
            int n;
            int n2 = this.map_.length;
            char[] cArray = new char[Math.max(256, n2)];
            for (n = 0; n < n2; ++n) {
                cArray[n] = UNICODE.getChar(this.getName((char)n));
            }
            n = 1;
            for (int i = 0; i < n2; ++i) {
                if (cArray[i] == i || this.map_[i] == null || this.map_[i] == ".notdef") continue;
                n = 0;
                break;
            }
            this.toUni_ = n != 0 ? CMap.IDENTITY : new CMap(cArray);
        }
        return this.toUni_;
    }

    public boolean fullUnicode() {
        return this.fullUni_;
    }

    public String toString() {
        return this.name_;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Encoding)) {
            return false;
        }
        if (object == IDENTITY || object == UNICODE) {
            return false;
        }
        return Arrays.equals(this.map_, ((Encoding)object).map_);
    }

    static {
        $assertionsDisabled = !Encoding.class.desiredAssertionStatus();
        UNICODE = new EncodingUnicode();
        Encoding.UNICODE.toUni_ = CMap.IDENTITY;
        Encoding.UNICODE.fullUni_ = true;
        String[] stringArray = new String[256];
        String[] stringArray2 = new String[256];
        String[] stringArray3 = new String[256];
        String[] stringArray4 = new String[256];
        try {
            Encoding.readEncodings("Latin", stringArray, stringArray2, stringArray3, stringArray4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ADOBE_STANDARD = new Encoding("Standard", stringArray);
        MAC_ROMAN = new Encoding("MacRoman", stringArray2);
        stringArray3[127] = "bullet";
        WIN_ANSI = new Encoding("WinAnsi", stringArray3);
        PDF_DOC = new Encoding("PDFDoc", stringArray4);
        String[] stringArray5 = new String[256];
        try {
            Encoding.readEncodings("Expert", null, null, null, stringArray5);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MAC_EXPERT = new Encoding("MacExpert", stringArray5);
        String[] stringArray6 = new String[256];
        try {
            Encoding.readEncodings("Symbol", null, null, null, stringArray6);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SYMBOL = new Encoding("Symbol", stringArray6);
        String[] stringArray7 = new String[256];
        try {
            Encoding.readEncodings("Zapf", null, null, null, stringArray7);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ZAPF_DINGBATS = new Encoding("ZapfDingbats", stringArray7);
        IDENTITY = new Encoding("Identity", new String[256]);
        Encoding.IDENTITY.toUni_ = CMap.IDENTITY;
        Encoding.IDENTITY.fullUni_ = false;
    }
}

