/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.NFont;
import com.pt.awt.font.CacheBitmap;
import com.pt.awt.font.GlyphRec;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CacheGlyph {
    private String name_;
    private AffineTransform m_;
    private GlyphRec[][] segs_;
    private static final int GLYPH_MAX = 1000;
    private int glyphuse_ = 0;
    private int glyphzapi_ = 0;
    private int statNew_ = 0;
    private int statUse_ = 0;
    private int statZap_ = 0;
    private int statBitNew_ = 0;
    private int statBitUse_ = 0;
    private int statBitReject_ = 0;
    private List<SoftReference<CacheBitmap>> bm_ = new ArrayList<SoftReference<CacheBitmap>>(30);
    static final /* synthetic */ boolean $assertionsDisabled;

    public CacheGlyph(NFont nFont, AffineTransform affineTransform) {
        this.name_ = nFont.getName();
        this.m_ = affineTransform;
        this.segs_ = new GlyphRec[nFont.getMaxGlyphNum() / 256 + 1][];
    }

    public String getName() {
        return this.name_;
    }

    public GlyphRec getGlyphRec(int n) {
        GlyphRec glyphRec;
        if (!($assertionsDisabled || 0 <= n && n <= 65535)) {
            throw new AssertionError();
        }
        GlyphRec[] glyphRecArray = this.segs_[n >> 8];
        GlyphRec glyphRec2 = glyphRec = glyphRecArray != null ? glyphRecArray[n & 0xFF] : null;
        if (glyphRec != null) {
            ++this.statUse_;
        }
        return glyphRec;
    }

    public void setGlyph(int n, GlyphRec glyphRec) {
        GlyphRec[] glyphRecArray;
        ++this.glyphuse_;
        if (1000 == this.glyphuse_) {
            int n2 = this.glyphzapi_;
            int n3 = this.segs_.length;
            while (n2 < n3) {
                if (this.segs_[n2] != null) {
                    int n4 = 0;
                    GlyphRec[] glyphRecArray2 = this.segs_[n2];
                    int n5 = glyphRecArray2.length;
                    for (int i = 0; i < n5; ++i) {
                        GlyphRec glyphRec2 = glyphRecArray2[i];
                        if (glyphRec2 == null) continue;
                        ++n4;
                    }
                    this.segs_[n2] = null;
                    this.glyphzapi_ = n2;
                    this.glyphuse_ -= n4;
                    this.statZap_ += n4;
                    break;
                }
                n2 = n2 + 1 < n3 ? n2 + 1 : 0;
            }
        }
        if ((glyphRecArray = this.segs_[n >> 8]) == null) {
            GlyphRec[] glyphRecArray3 = new GlyphRec[256];
            this.segs_[n >> 8] = glyphRecArray3;
            glyphRecArray = glyphRecArray3;
        }
        glyphRecArray[n & 0xFF] = glyphRec;
        ++this.statNew_;
    }

    public CacheBitmap getCacheBitmap(NFont nFont, AffineTransform affineTransform, AffineTransform affineTransform2, int[] nArray, int n, Color color) {
        float f = (float)((double)nFont.getSize() * affineTransform.getScaleX());
        CacheBitmap cacheBitmap = null;
        if (!NFont.isUseBitmaps() || f > CacheBitmap.getPixelsMax() || 0 != n || affineTransform.getScaleX() != affineTransform.getScaleY() || affineTransform.getScaleX() <= 0.0 || affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0 || affineTransform.getTranslateX() != 0.0 || affineTransform.getTranslateY() != 0.0 || affineTransform2.getScaleX() != 1.0 || affineTransform2.getScaleY() != 1.0 || affineTransform2.getShearX() != 0.0 || affineTransform2.getShearY() != 0.0 || color == null || color.getAlpha() == 0) {
            cacheBitmap = CacheBitmap.NONE;
            ++this.statBitReject_;
        }
        CacheBitmap cacheBitmap2 = null;
        if (cacheBitmap == null) {
            for (int i = this.bm_.size() - 1; i >= 0; --i) {
                CacheBitmap cacheBitmap3 = this.bm_.get(i).get();
                if (cacheBitmap3 == null) {
                    this.bm_.remove(i);
                    continue;
                }
                if (!(Math.abs(f - cacheBitmap3.getSize()) < 0.01f) || !Arrays.equals(nArray, cacheBitmap3.widths)) continue;
                if (!$assertionsDisabled && !nFont.getName().equals(cacheBitmap3.getName())) {
                    throw new AssertionError((Object)(nFont.getName() + " vs " + cacheBitmap3.getName()));
                }
                if (color.equals(cacheBitmap3.getColor())) {
                    cacheBitmap = cacheBitmap3;
                    break;
                }
                cacheBitmap2 = cacheBitmap3;
            }
        }
        if (cacheBitmap == null && cacheBitmap2 != null && !CacheBitmap.osx_ && this.bm_.size() > 10) {
            cacheBitmap = cacheBitmap2;
        }
        if (cacheBitmap == null) {
            if ((nFont = nFont.deriveFont(f)).isTransformed()) {
                nFont = nFont.deriveFont(new AffineTransform());
            }
            cacheBitmap = new CacheBitmap(nFont, this.m_, nArray);
            this.bm_.add(new SoftReference<CacheBitmap>(cacheBitmap));
            ++this.statBitNew_;
        }
        if (!$assertionsDisabled && cacheBitmap == null) {
            throw new AssertionError();
        }
        cacheBitmap.setColor(color);
        ++this.statBitUse_;
        return cacheBitmap;
    }

    static {
        $assertionsDisabled = !CacheGlyph.class.desiredAssertionStatus();
    }
}

