/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

public class TextTokens {
    private byte[] content;
    private int length = 0;
    private int currentCharPointer;

    public TextTokens(byte[] byArray) {
        this.content = byArray;
        this.length = byArray.length;
        this.currentCharPointer = 0;
    }

    public boolean hasMoreTokens() {
        return this.currentCharPointer < this.length;
    }

    public char nextUnicodeToken() {
        char c = '\u0000';
        char c2 = this.nextToken();
        if (c2 == '\r' & this.hasMoreTokens()) {
            c2 = this.nextToken();
        }
        if (this.hasMoreTokens() && (c = this.nextToken()) == '\r' & this.hasMoreTokens()) {
            c = this.nextToken();
        }
        return (char)((c2 << 8) + c);
    }

    private char getChar(int n) {
        int n2 = this.content[n] & 0xFF;
        return (char)n2;
    }

    public char nextToken() {
        char c = this.getChar(this.currentCharPointer);
        ++this.currentCharPointer;
        return c;
    }

    public boolean isUnicode() {
        if (this.length >= 2 && this.nextToken() == '\u00fe' && this.nextToken() == '\u00ff') {
            return true;
        }
        this.currentCharPointer = 0;
        return false;
    }
}

