/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.mousedraggabletree;

import it.flavianopetrocchi.mousedraggabletree.MoveType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoableMoveNodes
extends AbstractUndoableEdit {
    private JTree tree;
    private DefaultTreeModel treeModel;
    private MutableTreeNode newParent;
    private MutableTreeNode sibling;
    private MoveType type;
    private ArrayList<DefaultMutableTreeNode> nodesMoved;
    private ArrayList<NodePositionInfo> nodesOldPositions;

    public UndoableMoveNodes(JTree tree, MutableTreeNode newParent, MutableTreeNode sibling, MoveType type) {
        this.newParent = newParent;
        this.sibling = sibling;
        this.tree = tree;
        this.treeModel = (DefaultTreeModel)tree.getModel();
        this.type = type;
        this.nodesMoved = this.getSelectedNodes();
        this.nodesOldPositions = new ArrayList(this.nodesMoved.size());
        for (DefaultMutableTreeNode node : this.nodesMoved) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            this.nodesOldPositions.add(new NodePositionInfo(parent, parent.getIndex(node)));
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.removeFromParents();
        for (int i = 0; i < this.nodesMoved.size(); ++i) {
            DefaultMutableTreeNode node = this.nodesMoved.get(i);
            NodePositionInfo position = this.nodesOldPositions.get(i);
            position.parent.insert(node, position.index);
        }
        this.treeModel.nodeStructureChanged((TreeNode)this.treeModel.getRoot());
        this.setSelected();
    }

    private void removeFromParents() {
        for (DefaultMutableTreeNode node : this.nodesMoved) {
            node.removeFromParent();
        }
        this.treeModel.nodeStructureChanged((TreeNode)this.treeModel.getRoot());
    }

    private void setSelected() {
        TreePath[] paths = new TreePath[this.nodesMoved.size()];
        int i = 0;
        for (DefaultMutableTreeNode node : this.nodesMoved) {
            TreePath path;
            paths[i] = path = new TreePath(node.getPath());
            ++i;
        }
        this.tree.setSelectionPaths(paths);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doEdit();
    }

    public void doEdit() {
        this.removeFromParents();
        int index = this.newParent.getIndex(this.sibling);
        switch (this.type) {
            case MOVE_AS_CHILD: {
                index = 0;
                break;
            }
            case MOVE_AS_SIBLING_AFTER: {
                ++index;
                break;
            }
        }
        for (DefaultMutableTreeNode node : this.nodesMoved) {
            this.newParent.insert(node, index);
            ++index;
        }
        this.treeModel.nodeStructureChanged(this.newParent);
        this.setSelected();
    }

    private ArrayList<DefaultMutableTreeNode> getSelectedNodes() {
        TreePath[] paths;
        ArrayList<DefaultMutableTreeNode> nodesList = new ArrayList<DefaultMutableTreeNode>();
        for (TreePath path : paths = this.tree.getSelectionPaths()) {
            nodesList.add((DefaultMutableTreeNode)path.getLastPathComponent());
        }
        Collections.sort(nodesList, new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
                int i_o2;
                int i_o1 = UndoableMoveNodes.this.tree.getRowForPath(new TreePath(o1.getPath()));
                if (i_o1 < (i_o2 = UndoableMoveNodes.this.tree.getRowForPath(new TreePath(o2.getPath())))) {
                    return -1;
                }
                if (i_o1 > i_o2) {
                    return 1;
                }
                return 0;
            }
        });
        return nodesList;
    }

    private class NodePositionInfo {
        private DefaultMutableTreeNode parent;
        private int index;

        public NodePositionInfo(DefaultMutableTreeNode parent, int index) {
            this.parent = parent;
            this.index = index;
        }
    }
}

