/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.linklabel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URI;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class LinkLabel
extends JTextField
implements MouseListener,
FocusListener,
ActionListener {
    private URI target;
    public Color standardColor = new Color(0, 0, 255);
    public Color hoverColor = new Color(255, 0, 0);
    public Color activeColor = new Color(128, 0, 128);
    public Color transparent = new Color(0, 0, 0, 0);
    public boolean underlineVisible = true;
    private Border activeBorder;
    private Border hoverBorder;
    private Border standardBorder;

    public LinkLabel(URI target) {
        this(target, target.toString());
    }

    public LinkLabel(URI target, String text) {
        super(text);
        this.target = target;
    }

    public void setActiveColor(Color active) {
        this.activeColor = active;
    }

    public void setHoverColor(Color hover) {
        this.hoverColor = hover;
    }

    public void setStandardColor(Color standard) {
        this.standardColor = standard;
    }

    public void setUnderlineVisible(boolean underlineVisible) {
        this.underlineVisible = underlineVisible;
    }

    public void init() {
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addActionListener(this);
        this.setToolTipText(this.target.toString());
        if (this.underlineVisible) {
            this.activeBorder = new MatteBorder(0, 0, 1, 0, this.activeColor);
            this.hoverBorder = new MatteBorder(0, 0, 1, 0, this.hoverColor);
            this.standardBorder = new MatteBorder(0, 0, 1, 0, this.transparent);
        } else {
            this.activeBorder = new MatteBorder(0, 0, 0, 0, this.activeColor);
            this.hoverBorder = new MatteBorder(0, 0, 0, 0, this.hoverColor);
            this.standardBorder = new MatteBorder(0, 0, 0, 0, this.transparent);
        }
        this.setEditable(false);
        this.setForeground(this.standardColor);
        this.setBorder(this.standardBorder);
        this.setCursor(new Cursor(12));
    }

    public void browse() {
        this.setForeground(this.activeColor);
        this.setBorder(this.activeBorder);
        try {
            Desktop.getDesktop().browse(this.target);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setForeground(this.standardColor);
        this.setBorder(this.standardBorder);
    }

    public void actionPerformed(ActionEvent ae) {
        this.browse();
    }

    public void mouseClicked(MouseEvent me) {
        this.browse();
    }

    public void mouseEntered(MouseEvent me) {
        this.setForeground(this.hoverColor);
        this.setBorder(this.hoverBorder);
    }

    public void mouseExited(MouseEvent me) {
        this.setForeground(this.standardColor);
        this.setBorder(this.standardBorder);
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void focusLost(FocusEvent fe) {
        this.setForeground(this.standardColor);
        this.setBorder(this.standardBorder);
    }

    public void focusGained(FocusEvent fe) {
        this.setForeground(this.hoverColor);
        this.setBorder(this.hoverBorder);
    }

    public static void main(String[] args) throws Exception {
        JPanel p = new JPanel(new GridLayout(0, 1));
        File f = new File(".", "LinkLabel.java");
        f = new File(f.getCanonicalPath());
        URI uriFile = f.toURI();
        LinkLabel linkLabelFile = new LinkLabel(uriFile);
        linkLabelFile.init();
        p.add(linkLabelFile);
        LinkLabel linkLabelWeb = new LinkLabel(new URI("http://pscode.org/sscce.html"), "SSCCE");
        linkLabelWeb.setStandardColor(new Color(0, 128, 0));
        linkLabelWeb.setHoverColor(new Color(222, 128, 0));
        linkLabelWeb.init();
        p.add(linkLabelWeb);
        LinkLabel linkLabelConstrain = new LinkLabel(new URI("http://sdnshare.sun.com/"), "SDN Share");
        linkLabelConstrain.init();
        JPanel labelConstrain = new JPanel(new BorderLayout());
        labelConstrain.add((Component)linkLabelConstrain, "East");
        p.add(labelConstrain);
        LinkLabel linkLabelNoUnderline = new LinkLabel(new URI("http://java.net/"), "java.net");
        linkLabelNoUnderline.setUnderlineVisible(false);
        linkLabelNoUnderline.setHorizontalAlignment(0);
        linkLabelNoUnderline.init();
        p.add(linkLabelNoUnderline);
        JOptionPane.showMessageDialog(null, p);
    }
}

