/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.utilities.Ut;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;

public class PasswordDialog
extends JDialog {
    private byte[] password = null;
    private boolean okPressed = false;
    private String message = "";
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPasswordField passwordField;

    public PasswordDialog(Frame frame, boolean bl, String string) {
        super(frame, bl);
        if (string != null) {
            this.message = string;
        }
        this.initComponents();
    }

    private void initComponents() {
        this.passwordField = new JPasswordField();
        this.btnCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.btnOk = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("JPdfBookmarks");
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                PasswordDialog.this.passwordFieldKeyPressed(keyEvent);
            }
        });
        ResourceBundle resourceBundle = ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText");
        this.btnCancel.setText(resourceBundle.getString("CANCEL"));
        this.btnCancel.setDefaultCapable(false);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasswordDialog.this.btnCancelActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText(resourceBundle.getString("INPUT_PASSWORD"));
        this.btnOk.setText(resourceBundle.getString("OK"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasswordDialog.this.btnOkActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setText(this.message);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, 380, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordField, -1, 326, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addContainerGap()));
        groupLayout.linkSize(0, this.btnCancel, this.btnOk);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.passwordField, -2, -1, -2)).addGap(18, 24, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap()));
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent actionEvent) {
        char[] cArray = this.passwordField.getPassword();
        this.password = Ut.arrayOfCharsToArrayOfBytes((char[])cArray);
        Arrays.fill(cArray, '0');
        this.okPressed = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent actionEvent) {
        this.okPressed = false;
        this.dispose();
    }

    private void passwordFieldKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.btnOkActionPerformed(null);
        } else if (keyEvent.getKeyCode() == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    public byte[] getPassword() {
        return this.password;
    }

    public boolean okPressed() {
        return this.okPressed;
    }
}

