/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.CursorToolkit;
import it.flavianopetrocchi.jpdfbookmarks.FitType;
import it.flavianopetrocchi.jpdfbookmarks.IPdfView;
import it.flavianopetrocchi.jpdfbookmarks.JPdfBookmarks;
import it.flavianopetrocchi.jpdfbookmarks.PageChangedEvent;
import it.flavianopetrocchi.jpdfbookmarks.PageChangedListener;
import it.flavianopetrocchi.jpdfbookmarks.RenderingStartEvent;
import it.flavianopetrocchi.jpdfbookmarks.RenderingStartListener;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import it.flavianopetrocchi.jpdfbookmarks.TextCopiedEvent;
import it.flavianopetrocchi.jpdfbookmarks.TextCopiedListener;
import it.flavianopetrocchi.jpdfbookmarks.ThumbnailsPanel;
import it.flavianopetrocchi.jpdfbookmarks.ViewChangedEvent;
import it.flavianopetrocchi.jpdfbookmarks.ViewChangedListener;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;

public class JPedalViewPanel
extends JScrollPane
implements IPdfView {
    private static final int MIN_RECT_WIDTH = 100;
    private static final int MIN_RECT_HEIGHT = 100;
    private static final float MIN_SCALE = 0.001f;
    private static final float MAX_SCALE = 4.0f;
    private final Font textFont = new Font("Serif", 0, 12);
    private ArrayList<PageChangedListener> pageChangedListeners = new ArrayList();
    private ArrayList<ViewChangedListener> viewChangedListeners = new ArrayList();
    private ArrayList<RenderingStartListener> renderingStartListeners = new ArrayList();
    private ArrayList<TextCopiedListener> textCopiedListeners = new ArrayList();
    private int top = -1;
    private int left = -1;
    private int bottom = -1;
    private int right = -1;
    private float scale = 1.0f;
    private int currentPage;
    private int oldPage = -2;
    private PdfRenderPanel rendererPanel;
    private FitType fitType = FitType.FitPage;
    private int numberOfPages;
    private PdfPageData pdfPageData;
    private boolean drawingComplete = true;
    private Rectangle drawingRect;
    private Rectangle rectInCropBox;
    private BufferedImage img;
    private BufferedImage cloneImg;
    private float oldScale;
    volatile boolean painting = false;
    private PdfDecoder decoder;
    private int cropBoxX;
    private int cropBoxY;
    private int cropBoxWidth;
    private int cropBoxHeight;
    private int mediaBoxWidth;
    private int mediaBoxHeight;
    private Cursor rectRedCur;
    private Cursor rectBlueCur;
    private Boolean textSelectionActive = false;
    private String copiedText;
    private Boolean connectToClipboard = false;
    private Values commonValues = new Values();
    private ThumbnailsPanel thumbnails;
    private JScrollBar vbar = this.getVerticalScrollBar();

    @Override
    public void open(File file) throws Exception {
        this.open(file, null);
    }

    @Override
    public void open(File file, String string) throws Exception {
        if (this.decoder == null) {
            this.decoder = new PdfDecoder();
            this.decoder.setExtractionMode(1);
            PdfDecoder.init((boolean)true);
        }
        if (this.thumbnails == null) {
            this.thumbnails = new ThumbnailsPanel(this.commonValues, this.decoder);
            this.addPageChangedListener(this.thumbnails);
        }
        if (string != null) {
            this.decoder.setEncryptionPassword(string);
        }
        this.decoder.openPdfFile(file.getCanonicalPath());
        this.pdfPageData = this.decoder.getPdfPageData();
        this.numberOfPages = this.decoder.getPageCount();
        this.updateCurrentPageBoxes();
        this.thumbnails.setupThumbnails(this.numberOfPages, this.textFont, Res.getString("PAGE"), this.pdfPageData);
        this.thumbnails.addComponentListener();
        Object[] objectArray = this.thumbnails.getButtons();
        for (int i = 0; i < objectArray.length; ++i) {
            ((JButton)objectArray[i]).addActionListener(new ThumbnailListener(i));
        }
    }

    @Override
    public JScrollPane getThumbnails() {
        return this.thumbnails;
    }

    @Override
    public void reopen(File file) throws Exception {
        int n = this.currentPage;
        this.close();
        this.currentPage = n;
        this.open(file);
    }

    @Override
    public void close() {
        if (this.decoder != null) {
            this.decoder.closePdfFile();
            this.decoder = null;
        }
        if (this.thumbnails != null) {
            this.thumbnails.dispose();
            this.thumbnails = null;
        }
        this.img = null;
        this.currentPage = 0;
        this.setCopiedText(null);
        this.rendererPanel.repaint();
    }

    public JPedalViewPanel() {
        this.rendererPanel = new PdfRenderPanel();
        this.viewport.setBackground(Color.gray);
        this.setViewportView(this.rendererPanel);
        this.rendererPanel.addKeyListener(new PdfViewKeyListener());
        this.addMouseWheelListener(new PdfViewMouseWheelListener());
        this.addComponentListener(new ResizeListener());
        PdfDecoder.useTextExtraction();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point point = new Point(8, 7);
        Image image = Res.getIcon(this.getClass(), "gfx32/rect-red.png").getImage();
        this.rectRedCur = toolkit.createCustomCursor(image, point, "rect-red");
        image = Res.getIcon(this.getClass(), "gfx32/rect-blue.png").getImage();
        this.rectBlueCur = toolkit.createCustomCursor(image, point, "rect-blue");
    }

    private void scrollToAnotherPage(int n) {
        int n2;
        int n3;
        if (this.fitType.equals((Object)FitType.FitHeight)) {
            return;
        }
        if (this.fitType.equals((Object)FitType.FitPage)) {
            if (n < 0 && this.currentPage > 0) {
                this.goToPreviousPage();
            } else if (n > 0 && this.currentPage < this.numberOfPages - 1) {
                this.goToNextPage();
            }
            return;
        }
        Point point = this.rendererPanel.getLocation();
        int n4 = Math.abs(point.y);
        if (n4 == (n3 = this.rendererPanel.getSize().height) - (n2 = this.viewport.getSize().height) && this.currentPage < this.numberOfPages - 1) {
            this.goToNextPage();
            this.vbar.setValue(this.vbar.getMinimum());
        } else if (n4 == 0 && this.currentPage > 0) {
            this.goToPreviousPage();
            this.vbar.setValue(this.vbar.getMaximum());
        }
    }

    public JPedalViewPanel(FitType fitType) {
        this();
        this.fitType = fitType;
    }

    @Override
    public void goToFirstPage() {
        this.goToPage(1);
    }

    @Override
    public void goToPreviousPage() {
        this.goToPage(this.currentPage);
    }

    @Override
    public void goToPage(int n) {
        boolean bl = true;
        boolean bl2 = true;
        if (this.numberOfPages == 1) {
            this.currentPage = 0;
            bl2 = false;
            bl = false;
        } else if (n <= 1) {
            this.currentPage = 0;
            bl2 = false;
        } else if (n >= this.numberOfPages) {
            this.currentPage = this.numberOfPages - 1;
            bl = false;
        } else {
            this.currentPage = n - 1;
        }
        this.updateCurrentPageBoxes();
        this.rendererPanel.repaint();
        this.firePageChangedEvent(new PageChangedEvent(this, this.currentPage + 1, bl, bl2));
    }

    private void updateCurrentPageBoxes() {
        if (this.pdfPageData == null) {
            return;
        }
        int n = this.currentPage + 1;
        this.cropBoxX = this.pdfPageData.getCropBoxX(n);
        this.cropBoxY = this.pdfPageData.getCropBoxY(n);
        this.cropBoxWidth = this.pdfPageData.getCropBoxWidth(n);
        this.cropBoxHeight = this.pdfPageData.getCropBoxHeight(n);
        this.mediaBoxWidth = this.pdfPageData.getMediaBoxWidth(n);
        this.mediaBoxHeight = this.pdfPageData.getMediaBoxHeight(n);
    }

    @Override
    public void goToNextPage() {
        this.goToPage(this.currentPage + 2);
    }

    @Override
    public void goToLastPage() {
        this.goToPage(this.numberOfPages);
    }

    @Override
    public void setFitWidth(int n) {
        this.top = n;
        this.setFit(FitType.FitWidth);
    }

    @Override
    public void setFitHeight(int n) {
        this.left = n;
        this.setFit(FitType.FitHeight);
    }

    @Override
    public void setFitPage() {
        this.setFit(FitType.FitPage);
    }

    @Override
    public void setFitRect(Rectangle rectangle) {
        this.rectInCropBox = rectangle == null ? new Rectangle(0, 0, this.cropBoxWidth, this.cropBoxHeight) : rectangle;
        this.drawingComplete = true;
        this.setFit(FitType.FitRect);
    }

    @Override
    public void setFitRect(int n, int n2, int n3, int n4) {
        this.drawingComplete = true;
        this.rectInCropBox = new Rectangle(n2 - this.cropBoxX, this.mediaBoxHeight - n - this.cropBoxY, Math.abs(n4 - n2), Math.abs(n3 - n));
        this.setFit(FitType.FitRect);
    }

    @Override
    public void setTopLeftZoom(int n, int n2, float f) {
        this.left = n2;
        this.top = n;
        if (f > 0.001f) {
            this.scale = f;
        }
        this.setFit(FitType.TopLeftZoom);
    }

    public void setScale(float f) {
        this.scale = f;
    }

    @Override
    public int getNumPages() {
        return this.numberOfPages;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage + 1;
    }

    @Override
    public FitType getFitType() {
        return this.fitType;
    }

    @Override
    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.pageChangedListeners.add(pageChangedListener);
    }

    @Override
    public void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.pageChangedListeners.remove(pageChangedListener);
    }

    @Override
    public void setFitNative() {
        this.setFit(FitType.FitNative);
    }

    public void setFit(FitType fitType) {
        this.fitType = fitType;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JPedalViewPanel.this.fitType == FitType.FitRect) {
                    if (!JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                        JPedalViewPanel.this.viewport.setCursor(JPedalViewPanel.this.rectRedCur);
                    }
                } else if (!JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                    JPedalViewPanel.this.viewport.setCursor(Cursor.getDefaultCursor());
                }
                JPedalViewPanel.this.calcScaleFactor();
                JPedalViewPanel.this.adjustPreferredSize();
                JPedalViewPanel.this.adjustViewportPosition();
            }
        });
        this.rendererPanel.repaint();
    }

    @Override
    public void setTextSelectionMode(boolean bl) {
        if (bl) {
            this.viewport.setCursor(this.rectBlueCur);
        } else {
            this.copiedText = null;
            if (this.fitType == FitType.FitRect) {
                this.viewport.setCursor(this.rectRedCur);
            } else {
                this.viewport.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.textSelectionActive = bl;
    }

    @Override
    public void setConnectToClipboard(Boolean bl) {
        this.connectToClipboard = bl;
    }

    private void movePanel(int n, int n2) {
        Point point = this.viewport.getViewPosition();
        point.x = n;
        point.y = n2;
        point.x = Math.max(0, point.x);
        point.x = Math.min(this.getMaxXExtent(), point.x);
        point.y = Math.max(0, point.y);
        point.y = Math.min(this.getMaxYExtent(), point.y);
        this.viewport.setViewPosition(point);
    }

    private int getMaxXExtent() {
        return this.viewport.getView().getWidth() - this.viewport.getWidth();
    }

    private int getMaxYExtent() {
        return this.viewport.getView().getHeight() - this.viewport.getHeight();
    }

    private void calcScaleFactor() {
        switch (this.fitType) {
            case FitWidth: {
                this.scale = (float)this.viewport.getWidth() / (float)this.cropBoxWidth;
                break;
            }
            case FitHeight: {
                this.scale = (float)this.viewport.getHeight() / (float)this.cropBoxHeight;
                break;
            }
            case FitNative: {
                this.scale = 1.0f;
                break;
            }
            case FitRect: {
                if (this.rectInCropBox == null || !this.drawingComplete || this.textSelectionActive.booleanValue()) break;
                float f = (float)this.viewport.getWidth() / (float)this.rectInCropBox.width;
                float f2 = (float)this.viewport.getHeight() / (float)this.rectInCropBox.height;
                this.scale = Math.min(f, f2);
                break;
            }
            case FitPage: {
                float f = (float)this.viewport.getWidth() / (float)this.cropBoxWidth;
                float f3 = (float)this.viewport.getHeight() / (float)this.cropBoxHeight;
                this.scale = Math.min(f, f3);
            }
        }
        if (Double.isNaN(this.scale) || Double.isInfinite(this.scale)) {
            this.scale = 1.0f;
        }
    }

    private void adjustPreferredSize() {
        this.rendererPanel.setSize(this.calcViewSize());
    }

    private static String getTextFromClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Bookmark getBookmarkFromView() {
        Object object;
        Bookmark bookmark = new Bookmark();
        if (this.connectToClipboard.booleanValue()) {
            object = JPedalViewPanel.getTextFromClipboard();
            if (object != null) {
                bookmark.setTitle((String)object);
            }
        } else if (this.copiedText != null) {
            bookmark.setTitle(this.copiedText);
        }
        bookmark.setPageNumber(this.getCurrentPage());
        bookmark.setType(this.getFitType().convertToBookmarkType());
        object = this.viewport.getViewPosition();
        switch (bookmark.getType()) {
            case FitWidth: {
                bookmark.setTop(Math.round((float)this.cropBoxHeight - (float)((Point)object).y / this.scale + (float)this.cropBoxY));
                bookmark.setThousandthsTop(Bookmark.thousandthsVertical((int)bookmark.getTop(), (float)this.mediaBoxHeight));
                break;
            }
            case FitHeight: {
                bookmark.setLeft(Math.round((float)((Point)object).x / this.scale + (float)this.cropBoxX));
                bookmark.setThousandthsLeft(Bookmark.thousandthsHorizontal((int)bookmark.getLeft(), (float)this.mediaBoxWidth));
                break;
            }
            case TopLeftZoom: {
                bookmark.setTop(Math.round((float)this.cropBoxHeight - (float)((Point)object).y / this.scale + (float)this.cropBoxY));
                bookmark.setThousandthsTop(Bookmark.thousandthsVertical((int)bookmark.getTop(), (float)this.mediaBoxHeight));
                bookmark.setLeft(Math.round((float)((Point)object).x / this.scale + (float)this.cropBoxX));
                bookmark.setThousandthsLeft(Bookmark.thousandthsHorizontal((int)bookmark.getLeft(), (float)this.mediaBoxWidth));
                bookmark.setZoom(this.scale);
                break;
            }
            case FitRect: {
                if (this.rectInCropBox == null) break;
                Point point = this.rectInCropBox.getLocation();
                Dimension dimension = this.rectInCropBox.getSize();
                bookmark.setLeft(point.x + this.cropBoxX);
                bookmark.setThousandthsLeft(Bookmark.thousandthsHorizontal((int)bookmark.getLeft(), (float)this.mediaBoxWidth));
                bookmark.setTop(this.mediaBoxHeight - (point.y + this.cropBoxY));
                bookmark.setThousandthsTop(Bookmark.thousandthsVertical((int)bookmark.getTop(), (float)this.mediaBoxHeight));
                bookmark.setRight(point.x + dimension.width + this.cropBoxX);
                bookmark.setThousandthsRight(Bookmark.thousandthsHorizontal((int)bookmark.getRight(), (float)this.mediaBoxWidth));
                bookmark.setBottom(this.mediaBoxHeight - (point.y + dimension.height + this.cropBoxY));
                bookmark.setThousandthsBottom(Bookmark.thousandthsVertical((int)bookmark.getBottom(), (float)this.mediaBoxHeight));
            }
        }
        return bookmark;
    }

    private Dimension calcViewSize() {
        float f = (float)this.cropBoxWidth * this.scale;
        float f2 = (float)this.cropBoxHeight * this.scale;
        int n = Math.max(Math.round(f), this.viewport.getWidth());
        int n2 = Math.max(Math.round(f2), this.viewport.getHeight());
        switch (this.fitType) {
            case FitWidth: {
                n2 = Math.round(f2 + (float)this.viewport.getHeight());
                break;
            }
            case FitHeight: {
                n = Math.round(f) + this.viewport.getWidth();
                break;
            }
            case FitPage: {
                break;
            }
            case FitNative: 
            case FitRect: 
            case TopLeftZoom: {
                n = this.viewport.getWidth() + Math.round(f);
                n2 = this.viewport.getHeight() + Math.round(f2);
            }
        }
        return new Dimension(n, n2);
    }

    private void adjustViewportPosition() {
        float f = (float)this.mediaBoxHeight * this.scale;
        float f2 = (float)this.cropBoxY * this.scale;
        float f3 = (float)this.cropBoxX * this.scale;
        switch (this.fitType) {
            case FitPage: {
                this.movePanel(0, 0);
                break;
            }
            case FitWidth: {
                if (this.top == -1) break;
                float f4 = f - (float)this.top * this.scale - f2;
                this.movePanel(0, Math.round(f4));
                break;
            }
            case FitHeight: {
                if (this.left == -1) break;
                float f5 = (float)this.left * this.scale - f3;
                this.movePanel(Math.round(f5), 0);
                break;
            }
            case FitRect: {
                if (this.rectInCropBox == null || !this.drawingComplete) break;
                this.movePanel(Math.round((float)this.rectInCropBox.x * this.scale), Math.round((float)this.rectInCropBox.y * this.scale));
                break;
            }
            case TopLeftZoom: {
                Point point = this.viewport.getViewPosition();
                int n = this.top != -1 ? Math.round(f - (float)this.top * this.scale - f2) : point.y;
                int n2 = this.left != -1 ? Math.round((float)this.left * this.scale - f3) : point.x;
                this.movePanel(n2, n);
            }
        }
    }

    private void firePageChangedEvent(PageChangedEvent pageChangedEvent) {
        for (PageChangedListener pageChangedListener : this.pageChangedListeners) {
            pageChangedListener.pageChanged(pageChangedEvent);
        }
    }

    private void fireViewChangedEvent(ViewChangedEvent viewChangedEvent) {
        for (ViewChangedListener viewChangedListener : this.viewChangedListeners) {
            viewChangedListener.viewChanged(viewChangedEvent);
        }
    }

    private void fireTextCopiedEvent(TextCopiedEvent textCopiedEvent) {
        for (TextCopiedListener textCopiedListener : this.textCopiedListeners) {
            textCopiedListener.textCopied(textCopiedEvent);
        }
    }

    private void fireRenderingStartEvent(RenderingStartEvent renderingStartEvent) {
        for (RenderingStartListener renderingStartListener : this.renderingStartListeners) {
            renderingStartListener.renderingStart(renderingStartEvent);
        }
    }

    @Override
    public void addViewChangedListener(ViewChangedListener viewChangedListener) {
        this.viewChangedListeners.add(viewChangedListener);
    }

    @Override
    public void removeViewChangedListener(ViewChangedListener viewChangedListener) {
        this.viewChangedListeners.remove(viewChangedListener);
    }

    @Override
    public void addRenderingStartListener(RenderingStartListener renderingStartListener) {
        this.renderingStartListeners.add(renderingStartListener);
    }

    @Override
    public void removeRenderingStartListener(RenderingStartListener renderingStartListener) {
        this.renderingStartListeners.remove(renderingStartListener);
    }

    private void setCopiedText(String string) {
        this.copiedText = string;
        if (string != null && this.connectToClipboard.booleanValue()) {
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
        this.fireTextCopiedEvent(new TextCopiedEvent(this, string));
    }

    @Override
    public void addTextCopiedListener(TextCopiedListener textCopiedListener) {
        this.textCopiedListeners.add(textCopiedListener);
    }

    @Override
    public void removeTextCopiedListener(TextCopiedListener textCopiedListener) {
        this.textCopiedListeners.remove(textCopiedListener);
    }

    @Override
    public String extractText(Rectangle rectangle) {
        String string = null;
        try {
            int n = this.currentPage + 1;
            this.decoder.decodePage(n);
            PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decoder.getGroupingObject();
            int n2 = rectangle.x + this.cropBoxX;
            int n3 = rectangle.x + rectangle.width + this.cropBoxX;
            int n4 = this.mediaBoxHeight - this.cropBoxY - rectangle.y;
            int n5 = this.mediaBoxHeight - this.cropBoxY - rectangle.y - rectangle.height;
            string = pdfGroupingAlgorithms.extractTextInRectangle(n2, n4, n3, n5, n, false, true);
            for (int i = 0; string == null && i < 10; ++i) {
                string = pdfGroupingAlgorithms.extractTextInRectangle(--n2, ++n4, ++n3, --n5, n, false, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String extractTextInRect(int n, int n2, int n3, int n4) {
        String string = null;
        try {
            int n5 = this.currentPage + 1;
            this.decoder.decodePage(n5);
            PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decoder.getGroupingObject();
            string = pdfGroupingAlgorithms.extractTextInRectangle(n, n2, n3, n4, n5, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private class PdfRenderPanel
    extends JPanel
    implements Scrollable {
        public PdfRenderPanel() {
            this.setFocusable(true);
            PdfPanelMouseListener pdfPanelMouseListener = new PdfPanelMouseListener();
            this.addMouseListener(pdfPanelMouseListener);
            this.addMouseMotionListener(pdfPanelMouseListener);
            this.setBackground(Color.gray);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            Object object;
            super.paintComponent(graphics);
            if (JPedalViewPanel.this.decoder == null || JPedalViewPanel.this.pdfPageData == null) {
                this.setPreferredSize(JPedalViewPanel.this.viewport.getSize());
                this.revalidate();
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            JPedalViewPanel.this.calcScaleFactor();
            if (JPedalViewPanel.this.oldScale != JPedalViewPanel.this.scale || JPedalViewPanel.this.currentPage != JPedalViewPanel.this.oldPage || JPedalViewPanel.this.img == null) {
                CursorToolkit.startWaitCursor(JPedalViewPanel.this);
                try {
                    JPedalViewPanel.this.decoder.setPageParameters(JPedalViewPanel.this.scale, JPedalViewPanel.this.currentPage + 1);
                    JPedalViewPanel.this.img = JPedalViewPanel.this.decoder.getPageAsImage(JPedalViewPanel.this.currentPage + 1);
                    JPedalViewPanel.this.oldScale = JPedalViewPanel.this.scale;
                    JPedalViewPanel.this.oldPage = JPedalViewPanel.this.currentPage;
                }
                catch (Exception exception) {
                    JPdfBookmarks.printErrorForDebug(exception);
                }
                finally {
                    CursorToolkit.stopWaitCursor(JPedalViewPanel.this);
                }
                if (JPedalViewPanel.this.fitType == FitType.FitRect || JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                    JPedalViewPanel.this.cloneImg = new BufferedImage(JPedalViewPanel.this.img.getWidth(), JPedalViewPanel.this.img.getHeight(), JPedalViewPanel.this.img.getType());
                }
            }
            this.setPreferredSize(JPedalViewPanel.this.calcViewSize());
            this.revalidate();
            if (JPedalViewPanel.this.img != null) {
                if (JPedalViewPanel.this.fitType == FitType.FitRect || JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                    if (JPedalViewPanel.this.cloneImg == null) {
                        JPedalViewPanel.this.cloneImg = new BufferedImage(JPedalViewPanel.this.img.getWidth(), JPedalViewPanel.this.img.getHeight(), JPedalViewPanel.this.img.getType());
                    }
                    object = (Graphics2D)JPedalViewPanel.this.cloneImg.getGraphics();
                    ((Graphics)object).drawImage(JPedalViewPanel.this.img, 0, 0, null);
                    ((Graphics2D)object).setStroke(new BasicStroke());
                    if (JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                        ((Graphics)object).setColor(Color.blue);
                    } else {
                        ((Graphics)object).setColor(Color.red);
                    }
                    if (!JPedalViewPanel.this.drawingComplete) {
                        ((Graphics)object).drawRect(((JPedalViewPanel)JPedalViewPanel.this).drawingRect.x, ((JPedalViewPanel)JPedalViewPanel.this).drawingRect.y, ((JPedalViewPanel)JPedalViewPanel.this).drawingRect.width, ((JPedalViewPanel)JPedalViewPanel.this).drawingRect.height);
                        if (JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                            ((Graphics)object).setColor(new Color(0, 0, 255, 50));
                            ((Graphics)object).fillRect(((JPedalViewPanel)JPedalViewPanel.this).drawingRect.x, ((JPedalViewPanel)JPedalViewPanel.this).drawingRect.y, ((JPedalViewPanel)JPedalViewPanel.this).drawingRect.width, ((JPedalViewPanel)JPedalViewPanel.this).drawingRect.height);
                        }
                    } else if (!JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                        ((Graphics)object).drawRect(Math.round((float)((JPedalViewPanel)JPedalViewPanel.this).rectInCropBox.x * JPedalViewPanel.this.scale), Math.round((float)((JPedalViewPanel)JPedalViewPanel.this).rectInCropBox.y * JPedalViewPanel.this.scale), Math.round(JPedalViewPanel.this.scale * (float)((JPedalViewPanel)JPedalViewPanel.this).rectInCropBox.width), Math.round(JPedalViewPanel.this.scale * (float)((JPedalViewPanel)JPedalViewPanel.this).rectInCropBox.height));
                    } else {
                        ((Graphics)object).drawImage(JPedalViewPanel.this.img, 0, 0, this);
                    }
                    graphics2D.drawImage((Image)JPedalViewPanel.this.cloneImg, 0, 0, this);
                } else {
                    graphics2D.drawImage((Image)JPedalViewPanel.this.img, 0, 0, this);
                }
            }
            object = JPedalViewPanel.this.getBookmarkFromView();
            JPedalViewPanel.this.fireViewChangedEvent(new ViewChangedEvent(this, JPedalViewPanel.this.fitType, JPedalViewPanel.this.scale, (Bookmark)object));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        private class PdfPanelMouseListener
        extends MouseAdapter {
            private int xDiff;
            private int yDiff;

            private PdfPanelMouseListener() {
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (JPedalViewPanel.this.fitType == FitType.FitRect || JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                    if (mouseEvent.getX() < this.xDiff) {
                        JPedalViewPanel.this.drawingRect.setLocation(mouseEvent.getX(), ((JPedalViewPanel)JPedalViewPanel.this).drawingRect.y);
                    }
                    if (mouseEvent.getY() < this.yDiff) {
                        JPedalViewPanel.this.drawingRect.setLocation(((JPedalViewPanel)JPedalViewPanel.this).drawingRect.x, mouseEvent.getY());
                    }
                    int n = Math.abs(mouseEvent.getX() - this.xDiff);
                    int n2 = Math.abs(mouseEvent.getY() - this.yDiff);
                    JPedalViewPanel.this.drawingRect.setSize(n, n2);
                    PdfRenderPanel.this.repaint();
                } else {
                    Point point = JPedalViewPanel.this.viewport.getViewPosition();
                    int n = point.x - (mouseEvent.getX() - this.xDiff);
                    int n3 = point.y - (mouseEvent.getY() - this.yDiff);
                    Dimension dimension = JPedalViewPanel.this.viewport.getPreferredSize();
                    int n4 = dimension.width - JPedalViewPanel.this.viewport.getWidth();
                    int n5 = dimension.height - JPedalViewPanel.this.viewport.getHeight();
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > n4) {
                        n = n4;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n3 > n5) {
                        n3 = n5;
                    }
                    JPedalViewPanel.this.viewport.setViewPosition(new Point(n, n3));
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                PdfRenderPanel.this.requestFocusInWindow();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.xDiff = mouseEvent.getX();
                this.yDiff = mouseEvent.getY();
                if (JPedalViewPanel.this.fitType != FitType.FitRect && !JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                    PdfRenderPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    JPedalViewPanel.this.drawingRect = new Rectangle();
                    JPedalViewPanel.this.drawingRect.setLocation(this.xDiff, this.yDiff);
                    JPedalViewPanel.this.drawingComplete = false;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (JPedalViewPanel.this.fitType == FitType.FitRect || JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                    JPedalViewPanel.this.drawingComplete = true;
                    JPedalViewPanel.this.rectInCropBox = new Rectangle(JPedalViewPanel.this.cropBoxX, JPedalViewPanel.this.cropBoxY, JPedalViewPanel.this.cropBoxWidth, JPedalViewPanel.this.cropBoxHeight);
                    JPedalViewPanel.this.rectInCropBox.setLocation(Math.round((float)((JPedalViewPanel)JPedalViewPanel.this).drawingRect.x / JPedalViewPanel.this.scale), Math.round((float)((JPedalViewPanel)JPedalViewPanel.this).drawingRect.y / JPedalViewPanel.this.scale));
                    if (JPedalViewPanel.this.textSelectionActive.booleanValue()) {
                        JPedalViewPanel.this.rectInCropBox.setSize(Math.round((float)((JPedalViewPanel)JPedalViewPanel.this).drawingRect.width / JPedalViewPanel.this.scale), Math.round((float)((JPedalViewPanel)JPedalViewPanel.this).drawingRect.height / JPedalViewPanel.this.scale));
                        JPedalViewPanel.this.setCopiedText(JPedalViewPanel.this.extractText(JPedalViewPanel.this.rectInCropBox));
                    } else {
                        JPedalViewPanel.this.rectInCropBox.setSize(Math.round((float)((JPedalViewPanel)JPedalViewPanel.this).drawingRect.width / JPedalViewPanel.this.scale), Math.round((float)((JPedalViewPanel)JPedalViewPanel.this).drawingRect.height / JPedalViewPanel.this.scale));
                        JPedalViewPanel.this.setFitRect(JPedalViewPanel.this.rectInCropBox);
                    }
                } else {
                    PdfRenderPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            super.componentResized(componentEvent);
        }
    }

    class PdfViewKeyListener
    implements KeyListener {
        PdfViewKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 34: 
                case 40: {
                    Point point = JPedalViewPanel.this.rendererPanel.getLocation();
                    int n2 = Math.abs(point.y);
                    int n3 = ((JPedalViewPanel)JPedalViewPanel.this).rendererPanel.getSize().height;
                    int n4 = ((JPedalViewPanel)JPedalViewPanel.this).viewport.getSize().height;
                    if (n2 != n3 - n4 || JPedalViewPanel.this.currentPage >= JPedalViewPanel.this.numberOfPages - 1) break;
                    JPedalViewPanel.this.goToNextPage();
                    JPedalViewPanel.this.vbar.setValue(JPedalViewPanel.this.vbar.getMinimum());
                    break;
                }
                case 33: 
                case 38: {
                    Point point = JPedalViewPanel.this.rendererPanel.getLocation();
                    int n5 = Math.abs(point.y);
                    if (n5 != 0 || JPedalViewPanel.this.currentPage <= 0) break;
                    JPedalViewPanel.this.goToPreviousPage();
                    JPedalViewPanel.this.vbar.setValue(JPedalViewPanel.this.vbar.getMaximum());
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    class PdfViewMouseWheelListener
    implements MouseWheelListener {
        int oldValue = -1;

        PdfViewMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation();
            int n2 = JPedalViewPanel.this.vbar.getValue();
            if (n2 == this.oldValue) {
                JPedalViewPanel.this.scrollToAnotherPage(n);
                this.oldValue = -1;
            } else {
                this.oldValue = n2;
            }
        }
    }

    private class ThumbnailListener
    implements ActionListener {
        private int page = 1;

        public ThumbnailListener(int n) {
            this.page = n + 1;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JPedalViewPanel.this.goToPage(this.page);
        }
    }
}

