/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.io.BEBufferedRandomAccessFile;
import jj2000.j2k.io.BufferedRandomAccessFile;

public class CodestreamManipulator {
    private boolean ppmUsed;
    private boolean pptUsed;
    private boolean tempSop;
    private boolean tempEph;
    private int nt;
    private int pptp;
    private File file;
    private static int TP_HEAD_LEN = 14;
    private static int MAX_TPSOT = 16;
    private int maxtp;
    private int[] ppt;
    private Integer[] positions;
    private byte[] mainHeader;
    private byte[][][] tileParts;
    private byte[][] tileHeaders;
    private byte[][][] packetHeaders;
    private byte[][][] packetData;
    private byte[][][] sopMarkSeg;

    public CodestreamManipulator(File file, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.ppt = new int[this.nt];
        this.file = file;
        this.nt = n;
        this.pptp = n2;
        this.ppmUsed = bl;
        this.pptUsed = bl2;
        this.tempSop = bl3;
        this.tempEph = bl4;
    }

    public int doCodestreamManipulation() throws IOException {
        int n = 0;
        this.ppt = new int[this.nt];
        this.tileParts = new byte[this.nt][][];
        this.tileHeaders = new byte[this.nt][];
        this.packetHeaders = new byte[this.nt][][];
        this.packetData = new byte[this.nt][][];
        this.sopMarkSeg = new byte[this.nt][][];
        if (!this.ppmUsed && !this.pptUsed && this.pptp == 0) {
            return 0;
        }
        BEBufferedRandomAccessFile bEBufferedRandomAccessFile = new BEBufferedRandomAccessFile(this.file, "rw+");
        n -= bEBufferedRandomAccessFile.length();
        this.parseAndFind(bEBufferedRandomAccessFile);
        this.readAndBuffer(bEBufferedRandomAccessFile);
        bEBufferedRandomAccessFile.close();
        bEBufferedRandomAccessFile = new BEBufferedRandomAccessFile(this.file, "rw");
        this.createTileParts();
        this.writeNewCodestream(bEBufferedRandomAccessFile);
        bEBufferedRandomAccessFile.flush();
        bEBufferedRandomAccessFile.close();
        return n += bEBufferedRandomAccessFile.length();
    }

    private void parseAndFind(BufferedRandomAccessFile bufferedRandomAccessFile) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        short s = (short)bufferedRandomAccessFile.readUnsignedShort();
        s = (short)bufferedRandomAccessFile.readUnsignedShort();
        while (s != -112) {
            n3 = bufferedRandomAccessFile.getPos();
            n2 = bufferedRandomAccessFile.readUnsignedShort();
            if (s == -174) {
                n = bufferedRandomAccessFile.readUnsignedByte();
                if (this.tempSop) {
                    n &= 0xFD;
                }
                if (this.tempEph) {
                    n &= 0xFB;
                }
                bufferedRandomAccessFile.seek(n3 + 2);
                bufferedRandomAccessFile.write(n);
            }
            bufferedRandomAccessFile.seek(n3 + n2);
            s = (short)bufferedRandomAccessFile.readUnsignedShort();
        }
        n3 = bufferedRandomAccessFile.getPos();
        bufferedRandomAccessFile.seek(n3 - 2);
        for (int i = 0; i < this.nt; ++i) {
            bufferedRandomAccessFile.readUnsignedShort();
            n3 = bufferedRandomAccessFile.getPos();
            vector.addElement(new Integer(bufferedRandomAccessFile.getPos()));
            bufferedRandomAccessFile.readInt();
            n2 = bufferedRandomAccessFile.readInt();
            bufferedRandomAccessFile.readUnsignedShort();
            int n6 = n3 + n2 - 2;
            s = (short)bufferedRandomAccessFile.readUnsignedShort();
            while (s != -109) {
                n3 = bufferedRandomAccessFile.getPos();
                n2 = bufferedRandomAccessFile.readUnsignedShort();
                if (s == -174) {
                    n = bufferedRandomAccessFile.readUnsignedByte();
                    if (this.tempSop) {
                        n &= 0xFD;
                    }
                    if (this.tempEph) {
                        n &= 0xFB;
                    }
                    bufferedRandomAccessFile.seek(n3 + 2);
                    bufferedRandomAccessFile.write(n);
                }
                bufferedRandomAccessFile.seek(n3 + n2);
                s = (short)bufferedRandomAccessFile.readUnsignedShort();
            }
            n4 = 0;
            n5 = 0;
            for (int j = bufferedRandomAccessFile.getPos(); j < n6; ++j) {
                short s2 = (short)bufferedRandomAccessFile.readUnsignedByte();
                if (s2 != 255) continue;
                s = (short)((s2 << 8) + bufferedRandomAccessFile.readUnsignedByte());
                ++j;
                if (s == -111) {
                    vector.addElement(new Integer(bufferedRandomAccessFile.getPos()));
                    int n7 = i;
                    this.ppt[n7] = this.ppt[n7] + 1;
                    ++n4;
                    bufferedRandomAccessFile.skipBytes(4);
                    j += 4;
                }
                if (s != -110) continue;
                vector.addElement(new Integer(bufferedRandomAccessFile.getPos()));
                ++n5;
            }
        }
        vector.addElement(new Integer(bufferedRandomAccessFile.getPos() + 2));
        this.positions = new Integer[vector.size()];
        vector.copyInto(this.positions);
    }

    private void readAndBuffer(BufferedRandomAccessFile bufferedRandomAccessFile) throws IOException {
        bufferedRandomAccessFile.seek(0);
        int n = this.positions[0] - 2;
        this.mainHeader = new byte[n];
        bufferedRandomAccessFile.readFully(this.mainHeader, 0, n);
        int n2 = 0;
        for (int i = 0; i < this.nt; ++i) {
            int n3 = this.ppt[i];
            this.packetHeaders[i] = new byte[n3][];
            this.packetData[i] = new byte[n3][];
            this.sopMarkSeg[i] = new byte[n3][];
            n = this.positions[n2 + 1] - this.positions[n2];
            this.tileHeaders[i] = new byte[n];
            bufferedRandomAccessFile.readFully(this.tileHeaders[i], 0, n);
            ++n2;
            for (int j = 0; j < n3; ++j) {
                n = this.positions[n2 + 1] - this.positions[n2];
                if (this.tempSop) {
                    n -= 6;
                    bufferedRandomAccessFile.skipBytes(6);
                } else {
                    n -= 6;
                    this.sopMarkSeg[i][j] = new byte[6];
                    bufferedRandomAccessFile.readFully(this.sopMarkSeg[i][j], 0, 6);
                }
                if (!this.tempEph) {
                    n += 2;
                }
                this.packetHeaders[i][j] = new byte[n];
                bufferedRandomAccessFile.readFully(this.packetHeaders[i][j], 0, n);
                n = this.positions[++n2 + 1] - this.positions[n2];
                n -= 2;
                if (this.tempEph) {
                    bufferedRandomAccessFile.skipBytes(2);
                }
                this.packetData[i][j] = new byte[n];
                bufferedRandomAccessFile.readFully(this.packetData[i][j], 0, n);
                ++n2;
            }
        }
    }

    private void createTileParts() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.tileParts = new byte[this.nt][][];
        this.maxtp = 0;
        for (int i = 0; i < this.nt; ++i) {
            if (this.pptp == 0) {
                this.pptp = this.ppt[i];
            }
            int n = this.ppt[i];
            int n2 = (int)Math.ceil((double)n / (double)this.pptp);
            int n3 = this.packetHeaders[i].length;
            this.maxtp = n2 > this.maxtp ? n2 : this.maxtp;
            this.tileParts[i] = new byte[n2][];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                int n7;
                int n8 = n7 = this.pptp > n ? n : this.pptp;
                if (j == 0) {
                    byteArrayOutputStream.write(this.tileHeaders[i], 0, this.tileHeaders[i].length - 2);
                } else {
                    byteArrayOutputStream.write(new byte[TP_HEAD_LEN - 2], 0, TP_HEAD_LEN - 2);
                }
                if (this.pptUsed) {
                    int n9;
                    int n10 = 3;
                    int n11 = 0;
                    n6 = n5;
                    while (n8 > 0) {
                        int n12 = this.packetHeaders[i][n6].length;
                        if (n10 + n12 > 65535) {
                            byteArrayOutputStream.write(0xFFFFFF);
                            byteArrayOutputStream.write(-159);
                            byteArrayOutputStream.write(n10 >>> 8);
                            byteArrayOutputStream.write(n10);
                            byteArrayOutputStream.write(n11++);
                            for (n9 = n5; n9 < n6; ++n9) {
                                byteArrayOutputStream.write(this.packetHeaders[i][n9], 0, this.packetHeaders[i][n9].length);
                            }
                            n10 = 3;
                            n5 = n6;
                        }
                        n10 += n12;
                        ++n6;
                        --n8;
                    }
                    byteArrayOutputStream.write(0xFFFFFF);
                    byteArrayOutputStream.write(-159);
                    byteArrayOutputStream.write(n10 >>> 8);
                    byteArrayOutputStream.write(n10);
                    byteArrayOutputStream.write(n11);
                    for (n9 = n5; n9 < n6; ++n9) {
                        byteArrayOutputStream.write(this.packetHeaders[i][n9], 0, this.packetHeaders[i][n9].length);
                    }
                }
                n5 = n6;
                n8 = n7;
                byteArrayOutputStream.write(0xFFFFFF);
                byteArrayOutputStream.write(-109);
                for (n6 = n4; n6 < n4 + n8; ++n6) {
                    if (!this.tempSop) {
                        byteArrayOutputStream.write(this.sopMarkSeg[i][n6], 0, 6);
                    }
                    if (!this.ppmUsed && !this.pptUsed) {
                        byteArrayOutputStream.write(this.packetHeaders[i][n6], 0, this.packetHeaders[i][n6].length);
                    }
                    byteArrayOutputStream.write(this.packetData[i][n6], 0, this.packetData[i][n6].length);
                }
                n4 += n8;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.tileParts[i][j] = byArray;
                int n13 = byteArrayOutputStream.size();
                if (j == 0) {
                    byArray[6] = (byte)(n13 >>> 24);
                    byArray[7] = (byte)(n13 >>> 16);
                    byArray[8] = (byte)(n13 >>> 8);
                    byArray[9] = (byte)n13;
                    byArray[10] = 0;
                    byArray[11] = (byte)n2;
                } else {
                    byArray[0] = -1;
                    byArray[1] = -112;
                    byArray[2] = 0;
                    byArray[3] = 10;
                    byArray[4] = (byte)(i >> 8);
                    byArray[5] = (byte)i;
                    byArray[6] = (byte)(n13 >>> 24);
                    byArray[7] = (byte)(n13 >>> 16);
                    byArray[8] = (byte)(n13 >>> 8);
                    byArray[9] = (byte)n13;
                    byArray[10] = (byte)j;
                    byArray[11] = (byte)n2;
                }
                byteArrayOutputStream.reset();
                n -= n8;
            }
        }
        byteArrayOutputStream.close();
    }

    private void writeNewCodestream(BufferedRandomAccessFile bufferedRandomAccessFile) throws IOException {
        int n;
        byte[] byArray;
        int n2;
        int n3;
        int n4 = this.tileParts.length;
        int[][] nArray = new int[n4][this.maxtp];
        bufferedRandomAccessFile.write(this.mainHeader, 0, this.mainHeader.length);
        if (this.ppmUsed) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n10 = 0;
            int[] nArray2 = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray2[n3] = this.packetHeaders[n3].length;
            }
            for (n2 = 0; n2 < this.maxtp; ++n2) {
                for (n3 = 0; n3 < n4; ++n3) {
                    if (this.tileParts[n3].length <= n2) continue;
                    n9 = this.packetHeaders[n3].length;
                    n8 = n2 == this.tileParts[n3].length - 1 ? nArray2[n3] : this.pptp;
                    n7 = n9 - nArray2[n3];
                    n6 = n7 + n8;
                    for (n5 = n7; n5 < n6; ++n5) {
                        int[] nArray3 = nArray[n3];
                        int n11 = n2;
                        nArray3[n11] = nArray3[n11] + this.packetHeaders[n3][n5].length;
                    }
                    int n12 = n3;
                    nArray2[n12] = nArray2[n12] - n8;
                }
            }
            byteArrayOutputStream.write(0xFFFFFF);
            byteArrayOutputStream.write(-160);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            int n13 = 3;
            ++n10;
            for (n3 = 0; n3 < n4; ++n3) {
                nArray2[n3] = this.packetHeaders[n3].length;
            }
            for (n2 = 0; n2 < this.maxtp; ++n2) {
                for (n3 = 0; n3 < n4; ++n3) {
                    if (this.tileParts[n3].length <= n2) continue;
                    n9 = this.packetHeaders[n3].length;
                    n8 = n2 == this.tileParts[n3].length - 1 ? nArray2[n3] : this.pptp;
                    n7 = n9 - nArray2[n3];
                    n6 = n7 + n8;
                    if (n13 + 4 > 65535) {
                        byArray = byteArrayOutputStream.toByteArray();
                        n = byArray.length - 2;
                        byArray[2] = (byte)(n >>> 8);
                        byArray[3] = (byte)n;
                        bufferedRandomAccessFile.write(byArray, 0, n + 2);
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.write(0xFFFFFF);
                        byteArrayOutputStream.write(-160);
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(n10++);
                        n13 = 3;
                    }
                    n = nArray[n3][n2];
                    byteArrayOutputStream.write(n >>> 24);
                    byteArrayOutputStream.write(n >>> 16);
                    byteArrayOutputStream.write(n >>> 8);
                    byteArrayOutputStream.write(n);
                    n13 += 4;
                    for (n5 = n7; n5 < n6; ++n5) {
                        n = this.packetHeaders[n3][n5].length;
                        if (n13 + n > 65535) {
                            byArray = byteArrayOutputStream.toByteArray();
                            n = byArray.length - 2;
                            byArray[2] = (byte)(n >>> 8);
                            byArray[3] = (byte)n;
                            bufferedRandomAccessFile.write(byArray, 0, n + 2);
                            byteArrayOutputStream.reset();
                            byteArrayOutputStream.write(0xFFFFFF);
                            byteArrayOutputStream.write(-160);
                            byteArrayOutputStream.write(0);
                            byteArrayOutputStream.write(0);
                            byteArrayOutputStream.write(n10++);
                            n13 = 3;
                        }
                        byteArrayOutputStream.write(this.packetHeaders[n3][n5], 0, this.packetHeaders[n3][n5].length);
                        n13 += this.packetHeaders[n3][n5].length;
                    }
                    int n14 = n3;
                    nArray2[n14] = nArray2[n14] - n8;
                }
            }
            byArray = byteArrayOutputStream.toByteArray();
            n = byArray.length - 2;
            byArray[2] = (byte)(n >>> 8);
            byArray[3] = (byte)n;
            bufferedRandomAccessFile.write(byArray, 0, n + 2);
        }
        for (n2 = 0; n2 < this.maxtp; ++n2) {
            for (n3 = 0; n3 < this.nt; ++n3) {
                if (this.tileParts[n3].length < n2) continue;
                byArray = this.tileParts[n3][n2];
                n = byArray.length;
                bufferedRandomAccessFile.write(byArray, 0, n);
            }
        }
        bufferedRandomAccessFile.writeShort(-39);
    }
}

