/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFJPEGDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    protected static final int SOI = 216;
    protected static final int EOI = 217;
    protected ImageReader JPEGReader = null;
    protected ImageReadParam JPEGParam;
    protected boolean hasJPEGTables = false;
    protected byte[] tables = null;
    private byte[] data = new byte[0];

    public void beginDecoding() {
        TIFFField tIFFField;
        Iterator<ImageReader> iterator;
        if (this.JPEGReader == null) {
            iterator = ImageIO.getImageReadersByFormatName("jpeg");
            if (!iterator.hasNext()) {
                throw new IllegalStateException("No JPEG readers found!");
            }
            this.JPEGReader = (ImageReader)iterator.next();
            this.JPEGParam = this.JPEGReader.getDefaultReadParam();
        }
        if ((tIFFField = ((TIFFImageMetadata)((Object)(iterator = (TIFFImageMetadata)this.metadata))).getTIFFField(347)) != null) {
            this.hasJPEGTables = true;
            this.tables = tIFFField.getAsBytes();
        } else {
            this.hasJPEGTables = false;
        }
    }

    public void decodeRaw(byte[] byArray, int n, int n2, int n3) throws IOException {
        ImageInputStream imageInputStream;
        this.stream.seek(this.offset);
        if (this.hasJPEGTables) {
            int n4;
            int n5 = this.tables.length + this.byteCount;
            if (this.data.length < n5) {
                this.data = new byte[n5];
            }
            int n6 = this.tables.length;
            for (n4 = this.tables.length - 2; n4 > 0; --n4) {
                if ((this.tables[n4] & 0xFF) != 255 || (this.tables[n4 + 1] & 0xFF) != 217) continue;
                n6 = n4;
                break;
            }
            System.arraycopy(this.tables, 0, this.data, 0, n6);
            n4 = (byte)this.stream.read();
            byte by = (byte)this.stream.read();
            if ((n4 & 0xFF) != 255 || (by & 0xFF) != 216) {
                this.data[n6++] = n4;
                this.data[n6++] = by;
            }
            this.stream.readFully(this.data, n6, this.byteCount - 2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
            imageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
        } else {
            imageInputStream = this.stream;
        }
        this.JPEGReader.setInput(imageInputStream, false, true);
        this.JPEGParam.setDestination(this.rawImage);
        this.JPEGReader.read(0, this.JPEGParam);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.JPEGReader.dispose();
    }
}

