/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class TIFFIFD
extends TIFFDirectory {
    private long stripOrTileByteCountsPosition = -1L;
    private long stripOrTileOffsetsPosition = -1L;
    private long lastPosition = -1L;

    public static TIFFTag getTag(int n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TIFFTagSet tIFFTagSet = (TIFFTagSet)iterator.next();
            TIFFTag tIFFTag = tIFFTagSet.getTag(n);
            if (tIFFTag == null) continue;
            return tIFFTag;
        }
        return null;
    }

    public static TIFFTag getTag(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TIFFTagSet tIFFTagSet = (TIFFTagSet)iterator.next();
            TIFFTag tIFFTag = tIFFTagSet.getTag(string);
            if (tIFFTag == null) continue;
            return tIFFTag;
        }
        return null;
    }

    private static void writeTIFFFieldToStream(TIFFField tIFFField, ImageOutputStream imageOutputStream) throws IOException {
        int n = tIFFField.getCount();
        Object object = tIFFField.getData();
        switch (tIFFField.getType()) {
            case 2: {
                for (int i = 0; i < n; ++i) {
                    String string = ((String[])object)[i];
                    int n2 = string.length();
                    for (int j = 0; j < n2; ++j) {
                        imageOutputStream.writeByte(string.charAt(j) & 0xFF);
                    }
                    imageOutputStream.writeByte(0);
                }
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                imageOutputStream.write((byte[])object);
                break;
            }
            case 3: {
                imageOutputStream.writeChars((char[])object, 0, ((char[])object).length);
                break;
            }
            case 8: {
                imageOutputStream.writeShorts((short[])object, 0, ((short[])object).length);
                break;
            }
            case 9: {
                imageOutputStream.writeInts((int[])object, 0, ((int[])object).length);
                break;
            }
            case 4: {
                for (int i = 0; i < n; ++i) {
                    imageOutputStream.writeInt((int)((long[])object)[i]);
                }
                break;
            }
            case 13: {
                imageOutputStream.writeInt(0);
                break;
            }
            case 11: {
                imageOutputStream.writeFloats((float[])object, 0, ((float[])object).length);
                break;
            }
            case 12: {
                imageOutputStream.writeDoubles((double[])object, 0, ((double[])object).length);
                break;
            }
            case 10: {
                for (int i = 0; i < n; ++i) {
                    imageOutputStream.writeInt(((int[][])object)[i][0]);
                    imageOutputStream.writeInt(((int[][])object)[i][1]);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < n; ++i) {
                    long l = ((long[][])object)[i][0];
                    long l2 = ((long[][])object)[i][1];
                    imageOutputStream.writeInt((int)l);
                    imageOutputStream.writeInt((int)l2);
                }
                break;
            }
        }
    }

    public TIFFIFD(List list, TIFFTag tIFFTag) {
        super(list.toArray(new TIFFTagSet[list.size()]), tIFFTag);
    }

    public TIFFIFD(List list) {
        this(list, null);
    }

    public List getTagSetList() {
        return Arrays.asList(this.getTagSets());
    }

    public Iterator iterator() {
        return Arrays.asList(this.getTIFFFields()).iterator();
    }

    public void initialize(ImageInputStream imageInputStream, boolean bl) throws IOException {
        this.removeTIFFFields();
        List list = this.getTagSetList();
        int n = imageInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            long l;
            TIFFTag tIFFTag;
            int n2;
            int n3;
            int n4;
            block36: {
                n4 = imageInputStream.readUnsignedShort();
                n3 = imageInputStream.readUnsignedShort();
                n2 = (int)imageInputStream.readUnsignedInt();
                tIFFTag = TIFFIFD.getTag(n4, list);
                if (bl && tIFFTag == null) {
                    imageInputStream.skipBytes(4);
                    continue;
                }
                l = imageInputStream.getStreamPosition() + 4L;
                int n5 = TIFFTag.getSizeOfType(n3);
                if (n2 * n5 > 4) {
                    long l2 = imageInputStream.readUnsignedInt();
                    imageInputStream.seek(l2);
                }
                if (n4 == 279 || n4 == 325 || n4 == 514) {
                    this.stripOrTileByteCountsPosition = imageInputStream.getStreamPosition();
                } else if (n4 == 273 || n4 == 324 || n4 == 513) {
                    this.stripOrTileOffsetsPosition = imageInputStream.getStreamPosition();
                }
                object3 = null;
                try {
                    switch (n3) {
                        case 1: 
                        case 2: 
                        case 6: 
                        case 7: {
                            object2 = new byte[n2];
                            imageInputStream.readFully((byte[])object2, 0, n2);
                            if (n3 == 2) {
                                String[] stringArray;
                                object = new Vector();
                                boolean bl2 = false;
                                int n6 = 0;
                                for (int j = 0; j <= n2; ++j) {
                                    if (j < n2 && object2[j] != 0) {
                                        if (bl2) continue;
                                        n6 = j;
                                        bl2 = true;
                                        continue;
                                    }
                                    if (!bl2) continue;
                                    String string = new String((byte[])object2, n6, j - n6);
                                    ((Vector)object).add(string);
                                    bl2 = false;
                                }
                                n2 = ((Vector)object).size();
                                if (n2 != 0) {
                                    stringArray = new String[n2];
                                    for (int j = 0; j < n2; ++j) {
                                        stringArray[j] = (String)((Vector)object).elementAt(j);
                                    }
                                } else {
                                    n2 = 1;
                                    stringArray = new String[]{""};
                                }
                                object3 = stringArray;
                                break;
                            }
                            object3 = object2;
                            break;
                        }
                        case 3: {
                            object = new char[n2];
                            for (int j = 0; j < n2; ++j) {
                                object[j] = (char)imageInputStream.readUnsignedShort();
                            }
                            object3 = object;
                            break;
                        }
                        case 4: 
                        case 13: {
                            long[] lArray = new long[n2];
                            for (int j = 0; j < n2; ++j) {
                                lArray[j] = imageInputStream.readUnsignedInt();
                            }
                            object3 = lArray;
                            break;
                        }
                        case 5: {
                            long[][] lArray = new long[n2][2];
                            for (int j = 0; j < n2; ++j) {
                                lArray[j][0] = imageInputStream.readUnsignedInt();
                                lArray[j][1] = imageInputStream.readUnsignedInt();
                            }
                            object3 = lArray;
                            break;
                        }
                        case 8: {
                            short[] sArray = new short[n2];
                            for (int j = 0; j < n2; ++j) {
                                sArray[j] = imageInputStream.readShort();
                            }
                            object3 = sArray;
                            break;
                        }
                        case 9: {
                            int[] nArray = new int[n2];
                            for (int j = 0; j < n2; ++j) {
                                nArray[j] = imageInputStream.readInt();
                            }
                            object3 = nArray;
                            break;
                        }
                        case 10: {
                            int[][] nArray = new int[n2][2];
                            for (int j = 0; j < n2; ++j) {
                                nArray[j][0] = imageInputStream.readInt();
                                nArray[j][1] = imageInputStream.readInt();
                            }
                            object3 = nArray;
                            break;
                        }
                        case 11: {
                            float[] fArray = new float[n2];
                            for (int j = 0; j < n2; ++j) {
                                fArray[j] = imageInputStream.readFloat();
                            }
                            object3 = fArray;
                            break;
                        }
                        case 12: {
                            double[] dArray = new double[n2];
                            for (int j = 0; j < n2; ++j) {
                                dArray[j] = imageInputStream.readDouble();
                            }
                            object3 = dArray;
                            break;
                        }
                    }
                }
                catch (EOFException eOFException) {
                    if (BaselineTIFFTagSet.getInstance().getTag(n4) != null) break block36;
                    throw eOFException;
                }
            }
            if (tIFFTag != null && tIFFTag.isDataTypeOK(n3) && tIFFTag.isIFDPointer() && object3 != null) {
                imageInputStream.mark();
                imageInputStream.seek(((long[])object3)[0]);
                object2 = new ArrayList(1);
                object2.add(tIFFTag.getTagSet());
                object = new TIFFIFD((List)object2);
                ((TIFFIFD)object).initialize(imageInputStream, bl);
                object3 = object;
                imageInputStream.reset();
            }
            if (tIFFTag == null) {
                tIFFTag = new TIFFTag(null, n4, 1 << n3, null);
            }
            if (object3 != null) {
                object2 = new TIFFField(tIFFTag, n3, n2, object3);
                this.addTIFFField((TIFFField)object2);
            }
            imageInputStream.seek(l);
        }
        this.lastPosition = imageInputStream.getStreamPosition();
    }

    public void writeToStream(ImageOutputStream imageOutputStream) throws IOException {
        int n = this.getNumTIFFFields();
        imageOutputStream.writeShort(n);
        long l = imageOutputStream.getStreamPosition() + (long)(12 * n) + 4L;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            long l2;
            int n2;
            TIFFField tIFFField = (TIFFField)iterator.next();
            TIFFTag tIFFTag = tIFFField.getTag();
            int n3 = tIFFField.getType();
            int n4 = tIFFField.getCount();
            if (n3 == 0) {
                n3 = 7;
            }
            int n5 = n4 * TIFFTag.getSizeOfType(n3);
            if (n3 == 2) {
                n2 = 0;
                for (int i = 0; i < n4; ++i) {
                    n2 += tIFFField.getAsString(i).length() + 1;
                }
                n5 = n4 = n2;
            }
            n2 = tIFFField.getTagNumber();
            imageOutputStream.writeShort(n2);
            imageOutputStream.writeShort(n3);
            imageOutputStream.writeInt(n4);
            imageOutputStream.writeInt(0);
            imageOutputStream.mark();
            imageOutputStream.skipBytes(-4);
            if (n5 > 4 || tIFFTag.isIFDPointer()) {
                l = l + 3L & 0xFFFFFFFFFFFFFFFCL;
                imageOutputStream.writeInt((int)l);
                imageOutputStream.seek(l);
                l2 = l;
                if (tIFFTag.isIFDPointer()) {
                    TIFFIFD tIFFIFD = (TIFFIFD)tIFFField.getData();
                    tIFFIFD.writeToStream(imageOutputStream);
                    l = tIFFIFD.lastPosition;
                } else {
                    TIFFIFD.writeTIFFFieldToStream(tIFFField, imageOutputStream);
                    l = imageOutputStream.getStreamPosition();
                }
            } else {
                l2 = imageOutputStream.getStreamPosition();
                TIFFIFD.writeTIFFFieldToStream(tIFFField, imageOutputStream);
            }
            if (n2 == 279 || n2 == 325 || n2 == 514) {
                this.stripOrTileByteCountsPosition = l2;
            } else if (n2 == 273 || n2 == 324 || n2 == 513) {
                this.stripOrTileOffsetsPosition = l2;
            }
            imageOutputStream.reset();
        }
        this.lastPosition = l;
    }

    public long getStripOrTileByteCountsPosition() {
        return this.stripOrTileByteCountsPosition;
    }

    public long getStripOrTileOffsetsPosition() {
        return this.stripOrTileOffsetsPosition;
    }

    public long getLastPosition() {
        return this.lastPosition;
    }

    void setPositions(long l, long l2, long l3) {
        this.stripOrTileOffsetsPosition = l;
        this.stripOrTileByteCountsPosition = l2;
        this.lastPosition = l3;
    }

    public TIFFIFD getShallowClone() {
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        List list = this.getTagSetList();
        if (!list.contains(baselineTIFFTagSet)) {
            return this;
        }
        TIFFIFD tIFFIFD = new TIFFIFD(list, this.getParentTag());
        SortedSet sortedSet = baselineTIFFTagSet.getTagNumbers();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField;
            TIFFField tIFFField2 = (TIFFField)iterator.next();
            Integer n = new Integer(tIFFField2.getTagNumber());
            if (sortedSet.contains(n)) {
                Object object = tIFFField2.getData();
                int n2 = tIFFField2.getType();
                try {
                    switch (n2) {
                        case 1: 
                        case 6: 
                        case 7: {
                            object = ((byte[])object).clone();
                            break;
                        }
                        case 2: {
                            object = ((String[])object).clone();
                            break;
                        }
                        case 3: {
                            object = ((char[])object).clone();
                            break;
                        }
                        case 4: 
                        case 13: {
                            object = ((long[])object).clone();
                            break;
                        }
                        case 5: {
                            object = ((long[][])object).clone();
                            break;
                        }
                        case 8: {
                            object = ((short[])object).clone();
                            break;
                        }
                        case 9: {
                            object = ((int[])object).clone();
                            break;
                        }
                        case 10: {
                            object = ((int[][])object).clone();
                            break;
                        }
                        case 11: {
                            object = ((float[])object).clone();
                            break;
                        }
                        case 12: {
                            object = ((double[])object).clone();
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tIFFField = new TIFFField(tIFFField2.getTag(), n2, tIFFField2.getCount(), object);
            } else {
                tIFFField = tIFFField2;
            }
            tIFFIFD.addTIFFField(tIFFField);
        }
        tIFFIFD.setPositions(this.stripOrTileOffsetsPosition, this.stripOrTileByteCountsPosition, this.lastPosition);
        return tIFFIFD;
    }
}

