/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataEntryURLBox
extends Box {
    private static String[] elementNames = new String[]{"Version", "Flags", "URL"};
    private byte version;
    private byte[] flags;
    private String url;

    public static String[] getElementNames() {
        return elementNames;
    }

    public DataEntryURLBox(byte[] byArray) {
        super(8 + byArray.length, 1970433056, byArray);
    }

    public DataEntryURLBox(byte by, byte[] byArray, String string) {
        super(12 + string.length(), 1970433056, null);
        this.version = by;
        this.flags = byArray;
        this.url = string;
    }

    public DataEntryURLBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if ("Version".equals(string)) {
                this.version = Box.getByteElementValue(node2);
            }
            if ("Flags".equals(string)) {
                this.flags = Box.getByteArrayElementValue(node2);
            }
            if (!"URL".equals(string)) continue;
            this.url = Box.getStringElementValue(node2);
        }
    }

    protected void parse(byte[] byArray) {
        this.version = byArray[0];
        this.flags = new byte[3];
        this.flags[0] = byArray[1];
        this.flags[1] = byArray[2];
        this.flags[2] = byArray[3];
        this.url = new String(byArray, 4, byArray.length - 4);
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    public byte getVersion() {
        return this.version;
    }

    public byte[] getFlags() {
        return this.flags;
    }

    public String getURL() {
        return this.url;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[4 + this.url.length()];
        this.data[0] = this.version;
        this.data[1] = this.flags[0];
        this.data[2] = this.flags[1];
        this.data[3] = this.flags[2];
        System.arraycopy(this.url.getBytes(), 0, this.data, 4, this.url.length());
    }
}

