/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.ErrorTracker;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.TextState;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.Cmd;
import org.jpedal.parser.ColorCommands;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.ImageCommands;
import org.jpedal.parser.ImageDecoder;
import org.jpedal.parser.LayerDecoder;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.ShadingCommands;
import org.jpedal.parser.ShapeCommands;
import org.jpedal.parser.T3Decoder;
import org.jpedal.parser.TextDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.StringUtils;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class PdfStreamDecoder
extends BaseDecoder {
    protected GraphicsState newGS = null;
    protected byte[] pageStream = null;
    PdfLayerList layers;
    protected boolean getSamplingOnly = false;
    TextState currentTextState = new TextState();
    private Map shadingColorspacesObjects = new HashMap(50);
    private boolean isStackInitialised = false;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object textStateStack;
    private boolean isTTHintingRequired = false;
    private Vector_Int textDirections = new Vector_Int();
    private Vector_Rectangle textAreas = new Vector_Rectangle();
    public boolean ignoreColors = false;
    int lastDataPointer = -1;
    private T3Decoder t3Decoder = null;
    private boolean removeRenderImages = false;
    private boolean textColorExtracted = false;
    private boolean colorExtracted = false;
    private boolean textExtracted = true;
    private boolean renderText = false;
    private boolean isFlattenedForm = false;
    private float flattenX = 0.0f;
    private float flattenY = 0.0f;
    private String imagesInFile = null;
    public static float currentThreshold = 0.595f;
    private boolean flattenXFormToImage = false;
    private boolean requestTimeout = false;
    private int timeoutInterval = -1;
    protected ImageHandler customImageHandler = null;
    private PdfFontFactory pdfFontFactory;
    private boolean isXMLExtraction = false;
    private StatusBar statusBar = null;
    private boolean markedContentExtracted = false;
    private PdfData pdfData = new PdfData();
    private PdfImageData pdfImages = new PdfImageData();
    protected static String indent = "";
    protected boolean isDataValid = true;
    private PdfFont currentFontData;
    protected boolean useHiResImageForDisplay = false;
    protected ObjectStore objectStoreStreamRef;
    private String formName = "";
    protected boolean isType3Font;
    public static boolean useTextPrintingForNonEmbeddedFonts = false;
    private boolean isTimeout = false;
    boolean isPrinting = false;
    private static final float[] matches;

    public PdfStreamDecoder(PdfObjectReader pdfObjectReader) {
        this.init(pdfObjectReader);
    }

    public PdfStreamDecoder(PdfObjectReader pdfObjectReader, boolean bl, PdfLayerList pdfLayerList) {
        if (pdfLayerList != null) {
            this.layers = pdfLayerList;
        }
        this.init(pdfObjectReader);
    }

    private void init(PdfObjectReader pdfObjectReader) {
        this.cache = new PdfObjectCache();
        this.gs = new GraphicsState();
        this.layerDecoder = new LayerDecoder();
        this.errorTracker = new ErrorTracker();
        this.pageData = new PdfPageData();
        StandardFonts.checkLoaded(1);
        this.currentPdfFile = pdfObjectReader;
        this.pdfFontFactory = new PdfFontFactory(pdfObjectReader);
    }

    public final T3Size decodePageContent(GraphicsState graphicsState, byte[] byArray) throws PdfException {
        this.newGS = graphicsState;
        this.pageStream = byArray;
        return this.decodePageContent(null);
    }

    public final T3Size decodePageContent(PdfObject pdfObject) throws PdfException {
        try {
            this.imagesProcessedFully = true;
            this.imageCount = 0;
            this.isTimeout = false;
            this.layerDecoder.setPdfLayerList(this.layers);
            this.imagesInFile = null;
            if (!this.renderDirectly && this.statusBar != null) {
                this.statusBar.percentageDone = 0.0f;
            }
            this.gs = this.newGS != null ? this.newGS : new GraphicsState(0, 0);
            if (this.renderPage) {
                if (this.current == null) {
                    throw new PdfException("DynamicVectorRenderer not setup PdfStreamDecoder setStore(...) should be called");
                }
                this.current.drawClip(this.gs, this.defaultClip, false);
            }
            byte[][] byArray = null;
            if (pdfObject != null) {
                byArray = pdfObject.getKeyArray(1216184967);
                this.isDataValid = pdfObject.streamMayBeCorrupt();
            }
            this.cache.pageGroupingObj = pdfObject == null ? null : pdfObject.getDictionary(1111442775);
            byte[] byArray2 = pdfObject != null && byArray == null ? this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader())) : (this.pageStream != null ? this.pageStream : this.currentPdfFile.getObjectReader().readPageIntoStream(pdfObject));
            this.lastDataPointer = -1;
            if (byArray2 != null && byArray2.length > 0) {
                this.decodeStreamIntoObjects(byArray2, false);
            }
            if (!this.isType3Font) {
                this.cache.resetFonts();
            }
            T3Size t3Size = new T3Size();
            if (this.t3Decoder != null) {
                t3Size.x = this.t3Decoder.T3maxWidth;
                t3Size.y = this.t3Decoder.T3maxHeight;
                this.ignoreColors = this.t3Decoder.ignoreColors;
                this.t3Decoder = null;
            }
            return t3Size;
        }
        catch (Error error) {
            if (ExternalHandlers.throwMissingCIDError && error.getMessage().contains("kochi")) {
                throw error;
            }
            this.errorTracker.addPageFailureMessage("Problem decoding page " + error);
            return null;
        }
    }

    public void drawFlattenedForm(PdfObject pdfObject) throws PdfException {
        Object object;
        Object object22;
        Object object3;
        this.isFlattenedForm = true;
        boolean[] blArray = ((FormObject)pdfObject).getCharacteristics();
        if (blArray[0] || blArray[1] || blArray[5] || !pdfObject.getBoolean(524301630) && pdfObject.getParameterConstant(1147962727) == 1061176672) {
            return;
        }
        Object object4 = null;
        PdfObject pdfObject2 = pdfObject.getDictionary(4384).getDictionary(30);
        String string = pdfObject.getName(4387);
        if (string != null && string.equals(((FormObject)pdfObject).getNormalOnState())) {
            if (pdfObject2.getDictionary(7998) != null) {
                object4 = pdfObject2.getDictionary(7998);
            } else {
                object3 = pdfObject2.getOtherDictionaries();
                if (object3 != null && !object3.isEmpty()) {
                    for (Object object22 : object3.keySet()) {
                        object = (PdfObject)object3.get(object22);
                        object4 = object;
                    }
                }
            }
        } else if (pdfObject2 != null || pdfObject.getDictionary(7451).getDictionary(25) != null) {
            if (pdfObject2 != null && pdfObject2.getDictionary(2045494) != null) {
                object4 = pdfObject2.getDictionary(2045494);
            } else if (pdfObject.getDictionary(7451).getDictionary(25) != null && pdfObject.getDictionary(7451).getDictionary(6422) == null) {
                object4 = pdfObject.getDictionary(7451).getDictionary(25);
            } else if (pdfObject2 != null && pdfObject2.getDecodedStream() != null) {
                object4 = pdfObject2;
            }
        }
        if (object4 == null) {
            return;
        }
        this.currentPdfFile.checkResolved((PdfObject)object4);
        object3 = ((PdfObject)object4).getDecodedStream();
        PdfObject pdfObject3 = ((PdfObject)object4).getDictionary(2004251818);
        this.readResources(pdfObject3, false);
        object = pdfObject.getFloatArray(573911876);
        if (this.isFlattenedForm) {
            this.flattenX = object[0];
            this.flattenY = object[1];
        }
        object22 = ((PdfObject)object4).getFloatArray(1145198201);
        int n = this.pageData.getRotation(this.pageNum);
        float f = object[0];
        float f2 = object[1];
        Area area = null;
        if (object22 != null) {
            switch (n) {
                case 90: {
                    f = object[2];
                    break;
                }
                default: {
                    f = object[0] + object22[4];
                    area = new Area(new Rectangle((int)object[0], (int)object[1], (int)object[2], (int)object[3]));
                }
            }
            f2 = object[1] + object22[5];
            this.gs.CTM = new float[][]{{(float)object22[0], (float)object22[1], 0.0f}, {(float)object22[2], (float)object22[3], 0.0f}, {f, f2, 1.0f}};
        } else {
            this.gs.CTM = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {f, f2, 1.0f}};
            area = new Area(new Rectangle((int)object[0], (int)object[1], (int)object[2], (int)object[3]));
        }
        if (area != null) {
            this.gs.updateClip(new Area(area));
        }
        this.current.drawClip(this.gs, this.defaultClip, false);
        this.setBooleanValue(24, this.isFlattenedForm);
        this.decodeStreamIntoObjects((byte[])object3, false);
        this.gs.updateClip(null);
        this.current.drawClip(this.gs, null, true);
    }

    public void setObjectValue(int n, Object object) {
        switch (n) {
            case -9: {
                this.setName((String)object);
                break;
            }
            case 23: {
                boolean bl;
                this.current = (DynamicVectorRenderer)object;
                boolean bl2 = bl = (this.renderMode & 0x20) == 32;
                if (!bl || this.current == null) break;
                this.current.setOCR(true);
                break;
            }
            case -18: {
                this.pageData = (PdfPageData)object;
                if (!this.textColorExtracted) break;
                this.pdfData.enableTextColorDataExtraction();
                break;
            }
            case -3: {
                this.statusBar = (StatusBar)object;
                break;
            }
            case -4: {
                this.layers = (PdfLayerList)object;
                break;
            }
            case -6: {
                this.customImageHandler = (ImageHandler)object;
                if (this.customImageHandler == null || this.current == null) break;
                this.current.setCustomImageHandler(this.customImageHandler);
                break;
            }
            case -7: {
                this.renderDirectly = true;
                Graphics2D graphics2D = (Graphics2D)object;
                this.defaultClip = graphics2D.getClip();
                break;
            }
            case -8: {
                this.objectStoreStreamRef = (ObjectStore)object;
                this.current = new SwingDisplay(this.pageNum, this.objectStoreStreamRef, false);
                this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                if (this.customImageHandler == null || this.current == null) break;
                this.current.setCustomImageHandler(this.customImageHandler);
                break;
            }
            default: {
                super.setObjectValue(n, object);
            }
        }
    }

    public void setBooleanValue(int n, boolean bl) {
        switch (n) {
            case 25: {
                this.isPrinting = bl;
                break;
            }
            case -16: {
                this.flattenXFormToImage = bl;
                break;
            }
            default: {
                super.setBooleanValue(n, bl);
            }
        }
    }

    public void setDefaultColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.gs.strokeColorSpace.setColor(pdfPaint);
        this.gs.nonstrokeColorSpace.setColor(pdfPaint2);
        this.gs.setStrokeColor(pdfPaint);
        this.gs.setNonstrokeColor(pdfPaint2);
    }

    public Object getObjectValue(int n) {
        switch (n) {
            case -19: {
                if (PdfDecoder.embedWidthData) {
                    this.pdfData.widthIsEmbedded();
                }
                this.pdfData.maxX = this.pageData.getMediaBoxWidth(this.pageNum);
                this.pdfData.maxY = this.pageData.getMediaBoxHeight(this.pageNum);
                return this.pdfData;
            }
            case -20: {
                return this.pdfImages;
            }
            case -21: {
                return this.textAreas;
            }
            case 22: {
                return this.textDirections;
            }
            case 23: {
                return this.current;
            }
            case 373243460: {
                return this.pdfFontFactory.getFontsInFile();
            }
            case 1026635598: {
                return this.imagesInFile;
            }
            case 4: {
                return this.pdfFontFactory.getnonEmbeddedCIDFonts();
            }
            case 1: {
                return this.cache.iterator(1);
            }
        }
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Unknown parameter " + n);
        }
        return null;
    }

    public final void readResources(PdfObject pdfObject, boolean bl) throws PdfException {
        if (bl) {
            this.pdfFontFactory.resetfontsInFile();
        }
        this.cache.readResources(pdfObject, bl, this.currentPdfFile);
    }

    public String decodeStreamIntoObjects(byte[] byArray, boolean bl) {
        TextDecoder textDecoder;
        CommandParser commandParser;
        if (byArray.length == 0) {
            return null;
        }
        int n = 0;
        long l = System.currentTimeMillis();
        this.parser = commandParser = new CommandParser(byArray);
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        Object object = "";
        Object object2 = "";
        PdfShape pdfShape = new PdfShape();
        if (this.markedContentExtracted) {
            textDecoder = new TextDecoder(this.layerDecoder);
        } else {
            textDecoder = new TextDecoder(this.pdfData, this.isXMLExtraction, this.layerDecoder);
            textDecoder.setReturnText(bl);
        }
        if (this.errorTracker != null) {
            textDecoder.setHandlerValue(23, this.errorTracker);
        }
        textDecoder.setParameters(this.isPageContent, this.renderPage, this.renderMode, this.extractionMode, this.isPrinting);
        textDecoder.setFileHandler(this.currentPdfFile);
        textDecoder.setIntValue(19, this.formLevel);
        textDecoder.setIntValue(20, this.textPrint);
        textDecoder.setBooleanValue(19, this.renderDirectly);
        textDecoder.setBooleanValue(21, this.generateGlyphOnRender);
        textDecoder.setRenderer(this.current);
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        do {
            block93: {
                if (this.requestTimeout || this.timeoutInterval != -1 && System.currentTimeMillis() - l > (long)this.timeoutInterval) {
                    this.requestTimeout = false;
                    this.timeoutInterval = -1;
                    this.isTimeout = true;
                    break;
                }
                if (!this.renderDirectly && this.statusBar != null) {
                    this.statusBar.percentageDone = 90 * n3 / n2;
                }
                n3 = commandParser.getCommandValues(n3, n2, this.tokenNumber);
                int n5 = commandParser.getCommandID();
                if (n3 >= 0) continue;
                n3 = -n3;
                try {
                    int n6 = Cmd.getCommandType(n5);
                    block1 : switch (n6) {
                        case 0: {
                            Object object3;
                            Object object4;
                            if (n5 != 4541763 && !this.layerDecoder.isLayerVisible() || this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                            textDecoder.setCommands(commandParser);
                            textDecoder.setGS(this.gs);
                            textDecoder.setTextState(this.currentTextState);
                            textDecoder.setIntValue(18, this.tokenNumber);
                            if (this.renderPage && n5 == 16980) {
                                this.current.drawClip(this.gs, this.defaultClip, true);
                                this.current.drawTR(2);
                                this.current.flagCommand(16980, this.tokenNumber);
                            }
                            if (n5 == 21610 || n5 == 21578 || n5 == 39 || n5 == 34) {
                                this.current.flagCommand(21610, this.tokenNumber);
                                if (this.currentTextState.hasFontChanged() && (object4 = this.resolveFont((String)(object3 = this.currentTextState.getFontID()))) != null) {
                                    this.currentFontData = object4;
                                    this.current.drawFontBounds(this.currentFontData.getBoundingBox());
                                }
                                if (this.currentFontData == null) {
                                    this.currentFontData = new PdfFont(this.currentPdfFile);
                                }
                                if (this.currentTextState.hasFontChanged()) {
                                    this.currentTextState.setFontChanged(false);
                                }
                                textDecoder.setFont(this.currentFontData);
                            }
                            n3 = textDecoder.processToken(this.currentTextState, n5, n4, n3);
                            break;
                        }
                        case 2: {
                            Object object3;
                            if (this.getSamplingOnly) break;
                            switch (n5) {
                                case 66: {
                                    if (this.removeRenderImages) break;
                                    object3 = ShapeCommands.B(false, false, this.gs, this.formLevel, pdfShape, this.layerDecoder, this.renderPage, this.current);
                                    break block1;
                                }
                                case 98: {
                                    if (this.removeRenderImages) break;
                                    object3 = ShapeCommands.B(false, true, this.gs, this.formLevel, pdfShape, this.layerDecoder, this.renderPage, this.current);
                                    break block1;
                                }
                                case 25130: {
                                    if (this.removeRenderImages) break;
                                    object3 = ShapeCommands.B(true, true, this.gs, this.formLevel, pdfShape, this.layerDecoder, this.renderPage, this.current);
                                    break block1;
                                }
                                case 16938: {
                                    if (this.removeRenderImages) break;
                                    object3 = ShapeCommands.B(true, false, this.gs, this.formLevel, pdfShape, this.layerDecoder, this.renderPage, this.current);
                                    break block1;
                                }
                                case 99: {
                                    float f = commandParser.parseFloat(1);
                                    float f2 = commandParser.parseFloat(0);
                                    float f3 = commandParser.parseFloat(3);
                                    float f4 = commandParser.parseFloat(2);
                                    float f5 = commandParser.parseFloat(5);
                                    float f6 = commandParser.parseFloat(4);
                                    pdfShape.addBezierCurveC(f5, f6, f3, f4, f, f2);
                                    break block1;
                                }
                                case 100: {
                                    ShapeCommands.D(commandParser, this.gs);
                                    break block1;
                                }
                                case 70: {
                                    if (this.removeRenderImages) break;
                                    this.F(false, this.formLevel, pdfShape);
                                    break block1;
                                }
                                case 102: {
                                    if (this.removeRenderImages) break;
                                    this.F(false, this.formLevel, pdfShape);
                                    break block1;
                                }
                                case 17962: {
                                    if (this.removeRenderImages) break;
                                    this.F(true, this.formLevel, pdfShape);
                                    break block1;
                                }
                                case 26154: {
                                    if (this.removeRenderImages) break;
                                    this.F(true, this.formLevel, pdfShape);
                                    break block1;
                                }
                                case 104: {
                                    pdfShape.closeShape();
                                    break block1;
                                }
                                case 74: {
                                    ShapeCommands.J(false, commandParser.parseInt(0), this.gs);
                                    break block1;
                                }
                                case 106: {
                                    ShapeCommands.J(true, commandParser.parseInt(0), this.gs);
                                    break block1;
                                }
                                case 108: {
                                    pdfShape.lineTo(commandParser.parseFloat(1), commandParser.parseFloat(0));
                                    break block1;
                                }
                                case 77: {
                                    this.gs.setMitreLimit((int)commandParser.parseFloat(0));
                                    break block1;
                                }
                                case 109: {
                                    pdfShape.moveTo(commandParser.parseFloat(1), commandParser.parseFloat(0));
                                    break block1;
                                }
                                case 110: {
                                    ShapeCommands.N(pdfShape, this.gs, this.formLevel, this.defaultClip, this.renderPage, this.current, this.pageData, this.pageNum);
                                    break block1;
                                }
                                case 29285: {
                                    pdfShape.appendRectangle(commandParser.parseFloat(3), commandParser.parseFloat(2), commandParser.parseFloat(1), commandParser.parseFloat(0));
                                    break block1;
                                }
                                case 83: {
                                    if (this.removeRenderImages) break;
                                    Shape shape = ShapeCommands.S(false, this.layerDecoder, this.gs, pdfShape, this.current, this.renderPage);
                                    break block1;
                                }
                                case 115: {
                                    if (this.removeRenderImages) break;
                                    Shape shape = ShapeCommands.S(true, this.layerDecoder, this.gs, pdfShape, this.current, this.renderPage);
                                    break block1;
                                }
                                case 118: {
                                    pdfShape.addBezierCurveV(commandParser.parseFloat(3), commandParser.parseFloat(2), commandParser.parseFloat(1), commandParser.parseFloat(0));
                                    break block1;
                                }
                                case 119: {
                                    this.gs.setLineWidth(commandParser.parseFloat(0));
                                    break block1;
                                }
                                case 22314: {
                                    pdfShape.setEVENODDWindingRule();
                                    pdfShape.setClip(true);
                                    break block1;
                                }
                                case 87: {
                                    pdfShape.setNONZEROWindingRule();
                                    pdfShape.setClip(true);
                                    break block1;
                                }
                                case 121: {
                                    pdfShape.addBezierCurveY(commandParser.parseFloat(3), commandParser.parseFloat(2), commandParser.parseFloat(1), commandParser.parseFloat(0));
                                }
                            }
                            break;
                        }
                        case 3: {
                            if (this.getSamplingOnly || !this.renderPage && !this.textColorExtracted && !this.colorExtracted || !this.renderPage) break;
                            ShadingCommands.sh(commandParser.generateOpAsString(0, true), this.cache, this.gs, this.isPrinting, this.shadingColorspacesObjects, this.pageNum, this.currentPdfFile, this.pageData, this.current);
                            break;
                        }
                        case 1: {
                            Object object3;
                            if (this.getSamplingOnly || !this.renderPage && !this.textColorExtracted && !this.colorExtracted) break;
                            if (n5 != 5456718 && n5 != 7562094 && n5 != 21315 && n5 != 29539) {
                                this.current.resetOnColorspaceChange();
                            }
                            switch (n5) {
                                case 25459: {
                                    boolean bl2;
                                    object3 = commandParser.generateOpAsString(0, true);
                                    boolean bl3 = true;
                                    boolean bl4 = bl2 = !bl3 && ((String)object3).equals(object) || bl3 && ((String)object3).equals(object2);
                                    if (bl3) {
                                        object = object3;
                                    } else {
                                        object2 = object3;
                                    }
                                    ColorCommands.CS(bl3, (String)object3, this.gs, this.cache, this.currentPdfFile, this.isPrinting, this.pageNum, this.pageData, bl2);
                                    break block1;
                                }
                                case 17235: {
                                    boolean bl5;
                                    object3 = commandParser.generateOpAsString(0, true);
                                    boolean bl6 = false;
                                    boolean bl7 = bl5 = !bl6 && ((String)object3).equals(object) || bl6 && ((String)object3).equals(object2);
                                    if (bl6) {
                                        object = object3;
                                    } else {
                                        object2 = object3;
                                    }
                                    ColorCommands.CS(bl6, (String)object3, this.gs, this.cache, this.currentPdfFile, this.isPrinting, this.pageNum, this.pageData, bl5);
                                    break block1;
                                }
                                case 29287: {
                                    ColorCommands.RG(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 21063: {
                                    ColorCommands.RG(false, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 5456718: {
                                    ColorCommands.SCN(false, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 7562094: {
                                    ColorCommands.SCN(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 21315: {
                                    ColorCommands.SCN(false, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 29539: {
                                    ColorCommands.SCN(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 103: {
                                    ColorCommands.G(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 71: {
                                    ColorCommands.G(false, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 107: {
                                    ColorCommands.K(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 75: {
                                    ColorCommands.K(false, this.gs, commandParser, this.cache);
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (n5) {
                                case 25453: {
                                    PdfStreamDecoder.CM(this.gs, commandParser);
                                    break;
                                }
                                case 113: {
                                    this.gs = this.Q(this.gs, true);
                                    break;
                                }
                                case 81: {
                                    this.gs = this.Q(this.gs, false);
                                    break;
                                }
                                case 26483: {
                                    if (this.getSamplingOnly) break;
                                    this.gs.setMode((PdfObject)this.cache.GraphicsStates.get(commandParser.generateOpAsString(0, true)));
                                    this.current.setGraphicsState(2, this.gs.getAlpha(2));
                                    this.current.setGraphicsState(1, this.gs.getAlpha(1));
                                }
                            }
                            this.gs.setTextState(this.currentTextState);
                            if (n5 != 25453 || textDecoder == null) break;
                            textDecoder.reset();
                            break;
                        }
                        case 5: {
                            Object object3;
                            if (n5 == 16969) {
                                n = n3;
                                break;
                            }
                            Object object4 = null;
                            int n7 = 1;
                            if (n5 == 17519) {
                                String string = commandParser.generateOpAsString(0, true);
                                byte[] byArray2 = null;
                                object4 = this.cache.getXObjects(string);
                                if (object4 != null) {
                                    byArray2 = ((PdfObject)object4).getUnresolvedData();
                                    this.currentPdfFile.checkResolved((PdfObject)object4);
                                    n7 = ((PdfObject)object4).getParameterConstant(1147962727);
                                }
                                if (n7 == 373244477 && (this.formLevel <= 10 || n3 != this.lastDataPointer)) {
                                    this.lastDataPointer = n3;
                                    this.processXForm(n3, (PdfObject)object4, this.defaultClip, commandParser);
                                    if (byArray2 != null && this.cache.getXObjectCount() > 30) {
                                        String string2 = ((PdfObject)object4).getObjectRefAsString();
                                        this.cache.resetXObject(string, string2, byArray2);
                                        object4 = null;
                                    }
                                }
                            }
                            if (n7 != 373244477) {
                                object3 = new ImageDecoder(this.customImageHandler, this.objectStoreStreamRef, this.renderDirectly, this.pdfImages, this.formLevel, this.pageData, this.imagesInFile, this.formName);
                                ((BaseDecoder)object3).setIntValue(22, this.pageNum);
                                ((BaseDecoder)object3).setIntValue(19, this.formLevel);
                                ((BaseDecoder)object3).setHandlerValue(23, this.errorTracker);
                                ((BaseDecoder)object3).setRes(this.cache);
                                ((BaseDecoder)object3).setGS(this.gs);
                                ((ImageDecoder)object3).setSamplingOnly(this.getSamplingOnly);
                                ((BaseDecoder)object3).setIntValue(-12, this.streamType);
                                ((BaseDecoder)object3).setName(this.fileName);
                                ((BaseDecoder)object3).setFloatValue(17, this.multiplyer);
                                ((BaseDecoder)object3).setFloatValue(12, this.samplingUsed);
                                ((BaseDecoder)object3).setFileHandler(this.currentPdfFile);
                                ((BaseDecoder)object3).setRenderer(this.current);
                                ((BaseDecoder)object3).setIntValue(26, this.imageStatus);
                                ((ImageDecoder)object3).setParameters(this.isPageContent, this.renderPage, this.renderMode, this.extractionMode, this.isPrinting, this.isType3Font, this.useHiResImageForDisplay);
                                ((BaseDecoder)object3).setIntValue(14, this.imageCount);
                                if (n5 == 17519) {
                                    if (object4 != null && this.layerDecoder.isLayerVisible() && (this.layers == null || this.layers.isVisible((PdfObject)object4))) {
                                        n3 = ((ImageDecoder)object3).processDOImage(commandParser.generateOpAsString(0, true), n3, (PdfObject)object4);
                                    }
                                } else if (this.layerDecoder.isLayerVisible()) {
                                    n3 = ((ImageDecoder)object3).processIDImage(n3, n, commandParser.getStream(), this.tokenNumber);
                                }
                                this.samplingUsed = ((BaseDecoder)object3).getFloatValue(12);
                                this.imageCount = ((BaseDecoder)object3).getIntValue(14);
                                this.imagesInFile = ((ImageDecoder)object3).getImagesInFile();
                                if (((BaseDecoder)object3).getBooleanValue(16)) {
                                    this.hasYCCKimages = true;
                                }
                                if (((BaseDecoder)object3).getBooleanValue(15)) {
                                    this.imagesProcessedFully = true;
                                }
                            }
                            break;
                        }
                        case 6: {
                            if (this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                            if (this.t3Decoder == null) {
                                this.t3Decoder = new T3Decoder();
                            }
                            this.t3Decoder.setCommands(commandParser);
                            this.t3Decoder.setCommands(commandParser);
                            this.t3Decoder.processToken(n5);
                        }
                    }
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[PDF] " + exception + " Processing token >" + Cmd.getCommandAsString(n5) + "<>" + this.fileName + " <" + this.pageNum);
                    }
                    if (!this.isDataValid) {
                        n3 = n2;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.errorTracker.addPageFailureMessage("Memory error decoding token stream");
                    if (!LogWriter.isOutput()) break block93;
                    LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                }
            }
            n4 = n3;
            commandParser.reset();
            ++this.tokenNumber;
        } while (n2 > n3);
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 100.0f;
        }
        this.isTTHintingRequired = textDecoder.isTTHintingRequired();
        this.textAreas = (Vector_Rectangle)textDecoder.getObjectValue(-21);
        this.textDirections = (Vector_Int)textDecoder.getObjectValue(22);
        return "";
    }

    private PdfFont resolveFont(String string) {
        PdfFont pdfFont = (PdfFont)this.cache.resolvedFonts.get(string);
        if (pdfFont == null) {
            PdfObject pdfObject;
            String string2 = (String)this.cache.unresolvedFonts.get(string);
            if (string2 != null) {
                this.cache.unresolvedFonts.remove(string);
                pdfObject = new FontObject(string2);
                pdfObject.setStatus(1);
                pdfObject.setUnresolvedData(StringUtils.toBytes(string2), 373243460);
                this.currentPdfFile.checkResolved(pdfObject);
            } else {
                pdfObject = (PdfObject)this.cache.directFonts.get(string);
                if (pdfObject != null) {
                    this.cache.directFonts.remove(string);
                }
            }
            if (pdfObject != null) {
                try {
                    pdfFont = this.pdfFontFactory.createFont(pdfObject, string, this.objectStoreStreamRef, this.renderPage, this.errorTracker, this.isPrinting);
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
            }
            if (pdfFont != null) {
                this.cache.resolvedFonts.put(string, pdfFont);
            }
        }
        return pdfFont;
    }

    public boolean getBooleanValue(int n) {
        switch (n) {
            case -1: {
                return this.pdfFontFactory.hasEmbeddedFonts();
            }
            case 1: {
                return this.errorTracker.pageSuccessful;
            }
            case 4: {
                return this.pdfFontFactory.hasNonEmbeddedCIDFonts();
            }
            case 2: {
                return this.imagesProcessedFully;
            }
            case 8: {
                return this.hasYCCKimages;
            }
            case 16: {
                return this.isTimeout;
            }
            case 32: {
                return this.isTTHintingRequired;
            }
        }
        throw new RuntimeException("Unknown value " + n);
    }

    public void dispose() {
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
    }

    public void reqestTimeout(Object object) {
        if (object == null) {
            this.requestTimeout = true;
        } else if (object instanceof Integer) {
            this.timeoutInterval = (Integer)object;
        }
    }

    public void setIntValue(int n, int n2) {
        switch (n) {
            case -10: {
                this.pageNum = n2;
                break;
            }
            case 20: {
                this.textPrint = n2;
                break;
            }
            default: {
                super.setIntValue(n, n2);
            }
        }
    }

    public void setXMLExtraction(boolean bl) {
        this.isXMLExtraction = bl;
    }

    public void setParameters(boolean bl, boolean bl2, int n, int n2) {
        super.setParameters(bl, bl2, n, n2);
        this.renderText = bl2 && (n & 1) == 1;
        this.textExtracted = (n2 & 1) == 1;
        this.textColorExtracted = (n2 & 0x40) == 64;
        this.colorExtracted = (n2 & 0x200) == 512;
        this.removeRenderImages = bl2 && (n & 0x10) == 16;
    }

    private int processXForm(int n, PdfObject pdfObject, Shape shape, CommandParser commandParser) throws PdfException {
        if (!this.layerDecoder.isLayerVisible() || this.layers != null && !this.layers.isVisible(pdfObject) || pdfObject == null) {
            return n;
        }
        String string = this.formName;
        String string2 = commandParser.generateOpAsString(0, true);
        if (this.formLevel > 1) {
            string2 = this.formName + '_' + this.formLevel + '_' + string2;
        }
        String string3 = string2;
        try {
            if (ImageCommands.trackImages) {
                this.imagesInFile = this.imagesInFile == null ? string3 + " Form" : string3 + " Form\n" + this.imagesInFile;
            }
            commandParser.reset();
            byte[] byArray = this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader()));
            if (byArray != null) {
                Object object;
                Object object2;
                boolean bl;
                String string4 = indent;
                indent = indent + "   ";
                float[] fArray = new float[6];
                float[] fArray2 = pdfObject.getFloatArray(1145198201);
                boolean bl2 = bl = fArray2 == null || PdfStreamDecoder.isIdentity(fArray2);
                if (fArray2 != null) {
                    fArray = fArray2;
                }
                float[][] fArray3 = null;
                float f = -1.0f;
                if (fArray2 != null && !bl) {
                    object2 = new float[3][3];
                    for (int i = 0; i < 3; ++i) {
                        System.arraycopy(this.gs.CTM[i], 0, object2[i], 0, 3);
                    }
                    fArray3 = object2;
                    float[][] fArray4 = this.gs.CTM;
                    object = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
                    object = Matrix.multiply((float[][])object, fArray4);
                    this.gs.CTM = (float[][])object;
                    f = fArray[0] * this.gs.getLineWidth();
                    if (f == 0.0f) {
                        f = fArray[1] * this.gs.getLineWidth();
                    }
                    if (f < 0.0f) {
                        f = -f;
                    }
                }
                ++this.formLevel;
                this.formName = this.formLevel == 1 ? string2 : this.formName + '_' + string2;
                object2 = (GenericColorSpace)this.gs.strokeColorSpace.clone();
                object = (GenericColorSpace)this.gs.nonstrokeColorSpace.clone();
                if (f > 0.0f) {
                    this.gs.setLineWidth(f);
                }
                float f2 = this.gs.getAlphaMax(1);
                float f3 = this.gs.getAlphaMax(2);
                this.gs.setMaxAlpha(1, this.gs.getAlpha(1));
                if (this.formLevel == 1) {
                    this.gs.setMaxAlpha(2, this.gs.getAlpha(2));
                }
                PdfObjectCache pdfObjectCache = this.cache.copy();
                this.cache.reset(pdfObjectCache);
                PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
                this.readResources(pdfObject2, false);
                this.cache.groupObj = pdfObject.getDictionary(1111442775);
                this.currentPdfFile.checkResolved(this.cache.groupObj);
                float[] fArray5 = pdfObject.getFloatArray(303185736);
                Area area = null;
                boolean bl3 = false;
                if (fArray5 != null && fArray5[2] > 1.0f && fArray5[3] > 1.0f && this.gs.getClippingShape() == null && this.gs.CTM[0][1] == 0.0f && this.gs.CTM[1][0] == 0.0f && this.gs.CTM[2][1] != 0.0f && this.gs.CTM[2][0] < 0.0f) {
                    area = this.setClip(shape, fArray5);
                    bl3 = true;
                } else if (fArray5 != null && fArray5[0] == 0.0f && fArray5[1] == 0.0f && fArray5[2] > 1.0f && fArray5[3] > 1.0f && ((double)this.gs.CTM[0][0] > 0.99 || this.gs.CTM[2][1] < -1.0f) && (this.gs.CTM[2][0] < -1.0f || this.gs.CTM[2][0] > 1.0f) && this.gs.CTM[2][1] != 0.0f) {
                    area = this.setClip(shape, fArray5);
                    bl3 = true;
                }
                if (byArray.length > 0) {
                    PdfObject pdfObject3 = this.getSMask(fArray5);
                    int n2 = PdfStreamDecoder.getFirstValue(this.gs.getBM());
                    if (!PdfStreamDecoder.isTransparent(this.cache.groupObj) && (this.flattenXFormToImage || this.isPrinting && this.gs.CTM[2][0] == 0.0f && this.gs.CTM[2][1] == 0.0f && pdfObject3 == null && n2 != 1451587725 && this.gs.getAlpha(2) == 1.0f || (this.gs.getAlpha(2) == 1.0f || this.layerDecoder.layerLevel > 0 || this.formLevel == 1 && this.gs.getAlpha(2) < 0.1f) && pdfObject3 == null && n2 != 1451587725)) {
                        this.decodeStreamIntoObjects(byArray, false);
                    } else if (pdfObject3 != null || n2 == 1451587725) {
                        this.createMaskForm(pdfObject, string2, pdfObject3, n2);
                    } else {
                        DynamicVectorRenderer dynamicVectorRenderer = this.current;
                        this.current = new SwingDisplay(this.pageNum, this.objectStoreStreamRef, false);
                        this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                        boolean bl4 = this.renderDirectly;
                        float f4 = this.gs.getAlpha(1);
                        float f5 = this.gs.getAlphaMax(1);
                        float f6 = this.gs.getAlpha(2);
                        float f7 = this.gs.getAlphaMax(2);
                        this.currentPdfFile.checkResolved(this.cache.pageGroupingObj);
                        if (this.cache.pageGroupingObj != null && this.renderDirectly) {
                            this.gs.setMaxAlpha(1, 1.0f);
                        } else {
                            this.gs.setMaxAlpha(1, f4);
                            this.gs.setMaxAlpha(2, f6);
                        }
                        if (this.renderDirectly && (this.cache.pageGroupingObj == null || this.cache.pageGroupingObj != null && this.cache.groupObj != null && (this.cache.groupObj.getDictionary(2087749783).getParameterConstant(2087749783) == 1247168582 || this.cache.groupObj.getDictionary(2087749783).getParameterConstant(2087749783) != this.cache.pageGroupingObj.getDictionary(2087749783).getParameterConstant(2087749783)))) {
                            this.gs.setMaxAlpha(2, 1.0f);
                        }
                        if (!this.renderDirectly) {
                            this.gs.setAlpha(1, 1.0f);
                            this.gs.setAlpha(2, 1.0f);
                        }
                        this.renderDirectly = false;
                        dynamicVectorRenderer.setGraphicsState(1, 1.0f);
                        dynamicVectorRenderer.setGraphicsState(2, 1.0f);
                        this.decodeStreamIntoObjects(byArray, false);
                        this.gs.setMaxAlpha(1, f5);
                        this.gs.setMaxAlpha(2, f7);
                        if (!this.renderDirectly) {
                            this.gs.setAlpha(1, f4);
                            this.gs.setAlpha(2, f6);
                        }
                        dynamicVectorRenderer.drawXForm(this.current, this.gs);
                        this.current = dynamicVectorRenderer;
                        this.current.setGraphicsState(1, f4);
                        this.current.setGraphicsState(2, f6);
                        this.renderDirectly = bl4;
                    }
                }
                if (bl3) {
                    this.gs.setClippingShape(area);
                    this.current.drawClip(this.gs, area, false);
                }
                --this.formLevel;
                if (fArray3 != null) {
                    this.gs.CTM = fArray3;
                }
                this.gs.strokeColorSpace = object2;
                this.gs.nonstrokeColorSpace = object;
                this.cache.restore(pdfObjectCache);
                this.gs.setMaxAlpha(1, f2);
                this.gs.setMaxAlpha(2, f3);
                indent = string4;
            }
        }
        catch (Error error) {
            error.printStackTrace();
            this.imagesProcessedFully = false;
            this.errorTracker.addPageFailureMessage("Error " + error + " in DO");
            if (ExternalHandlers.throwMissingCIDError && error.getMessage().contains("kochi")) {
                throw error;
            }
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception);
            }
            this.imagesProcessedFully = false;
            this.errorTracker.addPageFailureMessage("Error " + exception + " in DO");
        }
        this.formName = string;
        return n;
    }

    private PdfObject getSMask(float[] fArray) {
        PdfObject pdfObject = null;
        if (this.gs.SMask != null && this.gs.SMask.getGeneralType(489767774) == 507461173) {
            return null;
        }
        if (this.gs.SMask != null && fArray != null && fArray[2] > 0.0f && (this.gs.SMask.getParameterConstant(608780341) != 489767739 || this.gs.SMask.getFloatArray(4627) != null)) {
            pdfObject = this.gs.SMask.getDictionary(23);
            this.currentPdfFile.checkResolved(pdfObject);
        }
        return pdfObject;
    }

    private static int getFirstValue(PdfArrayIterator pdfArrayIterator) {
        int n = -1;
        if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
            n = pdfArrayIterator.getNextValueAsConstant(false);
        }
        return n;
    }

    private void createMaskForm(PdfObject pdfObject, String string, PdfObject pdfObject2, int n) throws PdfException {
        Object object;
        float[] fArray = pdfObject.getFloatArray(303185736);
        int n2 = (int)fArray[0];
        int n3 = (int)fArray[1];
        int n4 = (int)fArray[2];
        int n5 = (int)fArray[3];
        if (n2 < 0) {
            n2 = 0;
        }
        BufferedImage bufferedImage = null;
        if (pdfObject2 != null) {
            bufferedImage = this.getImageFromPdfObject(pdfObject, n2, n4, n3, n5);
            object = this.getImageFromPdfObject(pdfObject2, n2, n4, n3, n5);
            PdfObject pdfObject3 = null;
            PdfObject pdfObject4 = pdfObject2.getDictionary(1111442775);
            if (pdfObject4 != null) {
                this.currentPdfFile.checkResolved(pdfObject4);
                pdfObject3 = pdfObject4.getDictionary(2087749783);
            }
            bufferedImage = ImageCommands.applySmask(bufferedImage, (BufferedImage)object, pdfObject2, true, true, pdfObject3, pdfObject, this.gs);
            ((Image)object).flush();
        }
        object = new GraphicsState();
        ((GraphicsState)object).CTM = new float[][]{{bufferedImage.getWidth(), 0.0f, 1.0f}, {0.0f, bufferedImage.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
        if (this.isFlattenedForm) {
            ((GraphicsState)object).x = this.flattenX;
            ((GraphicsState)object).y = this.flattenY;
        } else {
            ((GraphicsState)object).x = n2;
            ((GraphicsState)object).y = n3 - bufferedImage.getHeight();
        }
        ((GraphicsState)object).CTM[2][0] = ((GraphicsState)object).x;
        ((GraphicsState)object).CTM[2][1] = ((GraphicsState)object).y;
        this.current.drawImage(this.pageNum, bufferedImage, (GraphicsState)object, false, string, 1, -1);
    }

    private BufferedImage createTransparentForm(PdfObject pdfObject, int n, int n2, int n3, int n4) {
        byte[] byArray = this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader()));
        ObjectStore objectStore = new ObjectStore();
        SwingDisplay swingDisplay = new SwingDisplay(0, false, 20, objectStore);
        swingDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile, this.useHiResImageForDisplay, null);
        pdfStreamDecoder.setParameters(this.isPageContent, this.renderPage, this.renderMode, this.extractionMode);
        pdfStreamDecoder.setObjectValue(-8, objectStore);
        pdfStreamDecoder.setIntValue(19, this.formLevel);
        pdfStreamDecoder.setFloatValue(17, this.multiplyer);
        pdfStreamDecoder.setFloatValue(12, this.samplingUsed);
        pdfStreamDecoder.setObjectValue(23, swingDisplay);
        try {
            PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
            if (pdfObject2 != null) {
                pdfStreamDecoder.readResources(pdfObject2, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (byArray != null) {
            pdfStreamDecoder.decodeStreamIntoObjects(byArray, false);
        }
        int n5 = n4;
        if (n2 > n4) {
            n5 = n2 - n4;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!this.isFlattenedForm) {
            graphics2D.translate(-n, -n4);
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        swingDisplay.setG2(graphics2D);
        swingDisplay.paint(null, null, null);
        objectStore.flush();
        return bufferedImage;
    }

    private static boolean isTransparent(PdfObject pdfObject) {
        boolean bl = false;
        if (pdfObject != null) {
            String string = pdfObject.getName(35);
            PdfObject pdfObject2 = pdfObject.getDictionary(2087749783);
            bl = string != null && string.equals("Transparency") && pdfObject2 != null && pdfObject2.getParameterConstant(2087749783) == 1785221209;
        }
        return bl;
    }

    private Area setClip(Shape shape, float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        float f;
        float f2 = this.gs.CTM[0][0];
        if (f2 == 0.0f) {
            f2 = this.gs.CTM[0][1];
        }
        if ((f = this.gs.CTM[1][1]) == 0.0f) {
            f = this.gs.CTM[1][0];
        }
        if (this.gs.CTM[0][1] > 0.0f && this.gs.CTM[1][0] < 0.0f) {
            n4 = (int)(this.gs.CTM[2][0] - fArray[3]);
            n3 = (int)(this.gs.CTM[2][1] + fArray[0]);
            n2 = (int)((fArray[3] - fArray[1]) * f2);
            n = (int)((fArray[2] - fArray[0]) * f);
        } else if (this.gs.CTM[0][1] < 0.0f && this.gs.CTM[1][0] > 0.0f) {
            n4 = (int)(this.gs.CTM[2][0] + fArray[1]);
            n3 = (int)(this.gs.CTM[2][1] - fArray[2]);
            n2 = (int)((fArray[3] - fArray[1]) * -f2);
            n = (int)((fArray[2] - fArray[0]) * -f);
        } else {
            n4 = (int)(this.gs.CTM[2][0] + fArray[0]);
            n3 = (int)(this.gs.CTM[2][1] + fArray[1]);
            n2 = (int)(1.0f + (fArray[2] - fArray[0]) * f2);
            n = (int)(1.0f + (fArray[3] - fArray[1]) * f);
            if (this.gs.CTM[1][1] < 0.0f) {
                n3 -= n;
            }
        }
        Area area = this.gs.getClippingShape() == null ? null : (Area)this.gs.getClippingShape().clone();
        Area area2 = new Area(new Rectangle(n4, n3, n2, n));
        this.gs.updateClip(new Area(area2));
        this.current.drawClip(this.gs, shape, false);
        return area;
    }

    private static boolean isIdentity(float[] fArray) {
        boolean bl = true;
        if (fArray != null) {
            for (int i = 0; i < 6; ++i) {
                if (fArray[i] == matches[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private BufferedImage getImageFromPdfObject(PdfObject pdfObject, int n, int n2, int n3, int n4) throws PdfException {
        byte[] byArray = this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader()));
        ObjectStore objectStore = new ObjectStore();
        SwingDisplay swingDisplay = new SwingDisplay(0, false, 20, objectStore);
        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile, this.useHiResImageForDisplay, null);
        pdfStreamDecoder.setParameters(this.isPageContent, this.renderPage, this.renderMode, this.extractionMode);
        pdfStreamDecoder.setObjectValue(-8, objectStore);
        swingDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
        pdfStreamDecoder.setObjectValue(23, swingDisplay);
        pdfStreamDecoder.setFloatValue(17, this.multiplyer);
        pdfStreamDecoder.setFloatValue(12, this.samplingUsed);
        pdfStreamDecoder.setBooleanValue(24, this.isFlattenedForm);
        pdfStreamDecoder.setIntValue(19, this.formLevel);
        if (this.renderDirectly) {
            pdfStreamDecoder.setIntValue(26, 1);
        } else {
            pdfStreamDecoder.setIntValue(26, 2);
        }
        try {
            PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
            if (pdfObject2 != null) {
                pdfStreamDecoder.readResources(pdfObject2, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (byArray != null) {
            pdfStreamDecoder.decodeStreamIntoObjects(byArray, false);
        }
        pdfStreamDecoder.dispose();
        int n5 = n4;
        if (n3 > n4) {
            n5 = n3 - n4;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(-n, -n4);
        swingDisplay.setG2(graphics2D);
        swingDisplay.paint(null, null, null);
        objectStore.flush();
        return bufferedImage;
    }

    private void pushGraphicsState(GraphicsState graphicsState) {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
        }
        this.graphicsStateStack.push(graphicsState.clone());
        this.textStateStack.push(this.currentTextState.clone());
        this.nonstrokeColorStateStack.push(graphicsState.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(graphicsState.strokeColorSpace.clone());
        this.current.resetOnColorspaceChange();
    }

    private GraphicsState restoreGraphicsState(GraphicsState graphicsState) {
        boolean bl = false;
        if (!this.isStackInitialised) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No GraphicsState saved to retrieve");
            }
            graphicsState = new GraphicsState();
            this.currentTextState = new TextState();
        } else {
            bl = graphicsState.hasClipChanged();
            graphicsState = (GraphicsState)this.graphicsStateStack.pull();
            this.currentTextState = (TextState)this.textStateStack.pull();
            graphicsState.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            graphicsState.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            if (graphicsState.strokeColorSpace.getID() == -2073385820) {
                graphicsState.strokeColorSpace.restoreColorStatus();
            }
            if (graphicsState.nonstrokeColorSpace.getID() == -2073385820) {
                graphicsState.nonstrokeColorSpace.restoreColorStatus();
            }
        }
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(graphicsState.CTM, 0, graphicsState.lastCTM, 0, 3);
        }
        if (this.renderPage) {
            if (bl) {
                this.current.drawClip(graphicsState, this.defaultClip, true);
            }
            this.current.resetOnColorspaceChange();
            this.current.drawFillColor(graphicsState.getNonstrokeColor());
            this.current.drawStrokeColor(graphicsState.getStrokeColor());
            this.current.setGraphicsState(2, graphicsState.getAlpha(2));
            this.current.setGraphicsState(1, graphicsState.getAlpha(1));
        }
        return graphicsState;
    }

    private GraphicsState Q(GraphicsState graphicsState, boolean bl) {
        if (bl) {
            this.pushGraphicsState(graphicsState);
        } else {
            graphicsState = this.restoreGraphicsState(graphicsState);
            this.currentTextState.setFontChanged(true);
        }
        return graphicsState;
    }

    private static void CM(GraphicsState graphicsState, CommandParser commandParser) {
        float[][] fArray = new float[3][3];
        fArray[0][0] = commandParser.parseFloat(5);
        fArray[0][1] = commandParser.parseFloat(4);
        fArray[0][2] = 0.0f;
        fArray[1][0] = commandParser.parseFloat(3);
        fArray[1][1] = commandParser.parseFloat(2);
        fArray[1][2] = 0.0f;
        fArray[2][0] = commandParser.parseFloat(1);
        fArray[2][1] = commandParser.parseFloat(0);
        fArray[2][2] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(graphicsState.CTM, 0, graphicsState.lastCTM, 0, 3);
        }
        graphicsState.CTM = Matrix.multiply(fArray, graphicsState.CTM);
        if (graphicsState.CTM[0][0] > 0.0f && graphicsState.CTM[1][1] > 0.0f && graphicsState.CTM[1][0] > 0.0f && (double)graphicsState.CTM[1][0] < 0.01 && graphicsState.CTM[0][1] < 0.0f) {
            graphicsState.CTM[0][1] = 0.0f;
            graphicsState.CTM[1][0] = 0.0f;
        }
    }

    private void F(boolean bl, int n, PdfShape pdfShape) {
        Object object;
        if (n > 0 && this.cache.groupObj != null && !this.cache.groupObj.getBoolean(27) && this.gs.getAlphaMax(2) > 0.84f && this.gs.nonstrokeColorSpace.getID() == 1498837125) {
            object = this.gs.getBM();
            int n2 = -1;
            if (object != null && object.hasMoreTokens()) {
                n2 = object.getNextValueAsConstant(false);
            }
            if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -1 || n2 == 1451587725 && this.gs.getAlpha(2) == 1.0f) {
                return;
            }
        }
        if (this.gs.SMask != null && this.gs.nonstrokeColorSpace.getID() == 1498837125) {
            object = this.gs.SMask.getFloatArray(4627);
            if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 && object != null && object[0] == 1.0f) {
                return;
            }
        }
        if (this.gs.SMask != null && this.gs.nonstrokeColorSpace.getID() == 1247168582) {
            object = this.gs.SMask.getFloatArray(4627);
            if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 && object != null && object[0] == 0.0f) {
                return;
            }
        }
        if (this.gs.SMask != null && this.gs.SMask.getDictionary(23) != null && this.gs.nonstrokeColorSpace.getID() == 1785221209) {
            if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -1 && this.gs.getOPM() == 1.0f) {
                return;
            }
            object = this.gs.SMask.getFloatArray(4627);
            if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 && object != null && object[0] == 1.0f && object[1] == 1.0f && object[2] == 1.0f) {
                return;
            }
            try {
                this.createSMaskFill();
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
            return;
        }
        if (this.gs.SMask != null && this.gs.SMask.getGeneralType(489767774) != 507461173 && this.gs.nonstrokeColorSpace.getID() == 1785221209 && this.gs.getOPM() == 1.0f && this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216) {
            return;
        }
        if (this.layerDecoder.isLayerVisible()) {
            int n3;
            float[] fArray;
            int n4;
            if (bl) {
                pdfShape.setEVENODDWindingRule();
            } else {
                pdfShape.setNONZEROWindingRule();
            }
            pdfShape.closeShape();
            object = pdfShape.generateShapeFromPath(this.gs.CTM, this.gs.getLineWidth(), 70);
            if (this.gs.nonstrokeColorSpace.getID() == 1498837125 && this.gs.getOPM() == 1.0f) {
                PdfArrayIterator pdfArrayIterator = this.gs.getBM();
                n4 = -1;
                if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                    n4 = pdfArrayIterator.getNextValueAsConstant(false);
                }
                if (n4 == 1451587725 && (fArray = this.gs.nonstrokeColorSpace.getRawValues()) != null && fArray[3] == 1.0f) {
                    object = null;
                }
            }
            if (object != null && this.gs.nonstrokeColorSpace.getID() == 1247168582 && this.gs.getOPM() == 1.0f) {
                PdfArrayIterator pdfArrayIterator = this.gs.getBM();
                n4 = -1;
                if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                    n4 = pdfArrayIterator.getNextValueAsConstant(false);
                }
                if (n4 == 1451587725) {
                    fArray = this.gs.nonstrokeColorSpace.getRawValues();
                    n3 = fArray.length;
                    boolean bl2 = true;
                    for (int i = 0; i < n3; ++i) {
                        if (fArray[i] == 0.0f) continue;
                        bl2 = false;
                    }
                    if (bl2) {
                        object = null;
                    }
                }
            }
            if (object != null && this.gs.getAlpha(2) < 1.0f && this.gs.nonstrokeColorSpace.getID() == 960981604 && this.gs.getOPM() == 1.0f && this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216) {
                boolean bl3 = true;
                float[] fArray2 = this.gs.nonstrokeColorSpace.getRawValues();
                if (fArray2 != null) {
                    int n5 = fArray2.length;
                    for (n3 = 0; n3 < n5; ++n3) {
                        if (!(fArray2[n3] > 0.0f)) continue;
                        bl3 = false;
                        n3 = n5;
                    }
                }
                if (bl3) {
                    object = null;
                }
            }
            if (object != null && this.renderPage) {
                this.gs.setStrokeColor(this.gs.strokeColorSpace.getColor());
                this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
                this.gs.setFillType(2);
                this.current.drawShape((Shape)object, this.gs, 70);
            }
        }
        pdfShape.setClip(false);
        pdfShape.resetPath();
    }

    private void createSMaskFill() throws PdfException {
        PdfObject pdfObject = this.gs.SMask.getDictionary(23);
        this.currentPdfFile.checkResolved(pdfObject);
        float[] fArray = pdfObject.getFloatArray(303185736);
        int n = (int)fArray[0];
        int n2 = (int)fArray[1];
        int n3 = (int)fArray[2];
        int n4 = (int)fArray[3];
        if (n < 0) {
            n = 0;
        }
        BufferedImage bufferedImage = this.getImageFromPdfObject(pdfObject, n, n3, n2, n4);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n5 = writableRaster.getWidth();
        int n6 = writableRaster.getHeight();
        int[] nArray = new int[4];
        int n7 = this.gs.nonstrokeColorSpace.getColor().getRGB();
        nArray[0] = (byte)(n7 >> 16 & 0xFF);
        nArray[1] = (byte)(n7 >> 8 & 0xFF);
        nArray[2] = (byte)(n7 & 0xFF);
        int[] nArray2 = new int[]{0, 0, 0, 0};
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                boolean bl;
                writableRaster.getPixels(j, i, 1, 1, nArray);
                boolean bl2 = bl = nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 255;
                if (bl) {
                    writableRaster.setPixels(j, i, 1, 1, nArray2);
                    continue;
                }
                int[] nArray3 = new int[4];
                nArray3[3] = 191;
                nArray3[0] = nArray[0];
                nArray3[1] = nArray[1];
                nArray3[2] = nArray[2];
                writableRaster.setPixels(j, i, 1, 1, nArray3);
            }
        }
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.CTM = new float[][]{{bufferedImage.getWidth(), 0.0f, 1.0f}, {0.0f, bufferedImage.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
        graphicsState.x = n;
        graphicsState.y = n2 - bufferedImage.getHeight();
        graphicsState.CTM[2][0] = graphicsState.x;
        graphicsState.CTM[2][1] = graphicsState.y;
        this.current.drawImage(this.pageNum, bufferedImage, graphicsState, false, "F" + this.tokenNumber, 1, -1);
        bufferedImage.flush();
    }

    static {
        SamplingFactory.setDownsampleMode(null);
        matches = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    }
}

