/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.LogWriter;

public class RandomAccessMemoryMapBuffer
implements RandomAccessBuffer {
    private long pointer;
    private int length;
    private File file;
    private RandomAccessFile buf;

    public RandomAccessMemoryMapBuffer(InputStream inputStream) {
        block9: {
            this.length = 0;
            this.pointer = -1L;
            this.length = 0;
            FileOutputStream fileOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                int n;
                this.file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
                fileOutputStream = new FileOutputStream(this.file);
                bufferedInputStream = new BufferedInputStream(inputStream);
                byte[] byArray = new byte[65535];
                while ((n = bufferedInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                    this.length += n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Exception " + exception + " closing files");
            }
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RandomAccessMemoryMapBuffer(byte[] byArray) {
        this.length = 0;
        this.pointer = -1L;
        this.length = byArray.length;
        try {
            this.file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.buf = new RandomAccessFile(this.file, "r");
    }

    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    public void seek(long l) throws IOException {
        if (!this.checkPos(l)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = l;
    }

    public void close() throws IOException {
        if (this.buf != null) {
            this.buf.close();
            this.buf = null;
        }
        this.pointer = -1L;
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public long length() throws IOException {
        if (this.buf != null) {
            return this.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.buf.seek(this.pointer++);
            return RandomAccessMemoryMapBuffer.b2i(this.buf.readByte());
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.buf.seek(this.pointer++);
            return RandomAccessMemoryMapBuffer.b2i(this.buf.readByte());
        }
        return -1;
    }

    public String readLine() throws IOException {
        int n;
        if (this.pointer >= (long)(this.length - 1)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) >= 0) {
            if (n == 10 || n == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == n) break;
                this.read();
                break;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public int read(byte[] byArray) throws IOException {
        if (this.buf == null) {
            throw new IOException("Data buffer not initialized.");
        }
        if (this.pointer < 0L || this.pointer >= (long)this.length) {
            return -1;
        }
        int n = this.length - (int)this.pointer;
        if (n > byArray.length) {
            n = byArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.buf.seek(this.pointer++);
            byArray[i] = this.buf.readByte();
        }
        return n;
    }

    private static int b2i(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    private boolean checkPos(long l) throws IOException {
        return l >= 0L && l < this.length();
    }

    public byte[] getPdfBuffer() {
        byte[] byArray = new byte[this.length];
        try {
            this.buf.seek(0L);
            this.buf.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }
}

